/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.deequ;

import ai.databand.DbndWrapper;
import ai.databand.deequ.DbndResultKey;
import ai.databand.deequ.DeequToDbnd;
import ai.databand.deequ.NoopMetricsRepository;
import com.amazon.deequ.analyzers.runners.AnalyzerContext;
import com.amazon.deequ.repository.MetricsRepository;
import com.amazon.deequ.repository.MetricsRepositoryMultipleResultsLoader;
import com.amazon.deequ.repository.ResultKey;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Map;

public class DbndMetricsRepository
implements MetricsRepository {
    private final DbndWrapper dbnd;
    private final MetricsRepository origin;

    public DbndMetricsRepository(DbndWrapper dbnd) {
        this.dbnd = dbnd;
        this.origin = new NoopMetricsRepository();
    }

    public DbndMetricsRepository(DbndWrapper dbnd, MetricsRepository originRepo) {
        this.dbnd = dbnd;
        this.origin = originRepo;
    }

    public DbndMetricsRepository() {
        this.dbnd = DbndWrapper.instance();
        this.origin = new NoopMetricsRepository();
    }

    public DbndMetricsRepository(MetricsRepository originRepo) {
        this.dbnd = DbndWrapper.instance();
        this.origin = originRepo;
    }

    public void save(ResultKey resultKey, AnalyzerContext analyzerContext) {
        String dfName;
        this.origin.save(resultKey, analyzerContext);
        if (resultKey instanceof DbndResultKey) {
            dfName = ((DbndResultKey)resultKey).dataSetName();
        } else {
            java.util.Map tags = (java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)resultKey.tags()).asJava();
            dfName = tags.getOrDefault("name", "data");
        }
        DeequToDbnd converted = new DeequToDbnd(dfName, analyzerContext);
        this.dbnd.logMetrics(converted.metrics());
        this.dbnd.logHistogram(converted.histograms());
    }

    public Option<AnalyzerContext> loadByKey(ResultKey resultKey) {
        return this.origin.loadByKey(resultKey);
    }

    public MetricsRepositoryMultipleResultsLoader load() {
        return this.origin.load();
    }
}

