/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.azkaban;

import ai.databand.config.NormalizedProps;
import ai.databand.config.PropertiesSource;
import azkaban.execapp.FlowRunner;
import azkaban.utils.Props;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzkabanFlowSharedProps
implements PropertiesSource {
    private static final Logger LOG = LoggerFactory.getLogger(AzkabanFlowSharedProps.class);
    private final Map<String, String> props;

    public AzkabanFlowSharedProps(FlowRunner flowRunner) {
        HashMap azkabanProps = new HashMap();
        try {
            Field sharedPropsField = flowRunner.getClass().getDeclaredField("sharedProps");
            if (!sharedPropsField.isAccessible()) {
                sharedPropsField.setAccessible(true);
            }
            Map sharedProps = (Map)sharedPropsField.get(flowRunner);
            for (Props nextProps : sharedProps.values()) {
                azkabanProps.putAll(nextProps.getFlattened());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOG.error("Unable to load shared properties from the Azkaban Flow", (Throwable)e);
        }
        this.props = new NormalizedProps(azkabanProps).values();
    }

    public Map<String, String> values() {
        return this.props;
    }

    public Optional<String> getValue(String key) {
        return Optional.ofNullable(this.props.get(key));
    }
}

