/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.schema;

import ai.databand.config.DbndConfig;
import ai.databand.id.Uuid5;
import ai.databand.schema.RootRun;
import ai.databand.schema.TrackingSource;
import java.util.Optional;

public class AzkabanTaskContext {
    private final String projectName;
    private final String flowId;
    private final String flowUuid;
    private final String executionId;
    private final String jobId;
    private final DbndConfig config;

    public AzkabanTaskContext(String projectName, String flowId, String flowUuid, String executionId, String jobId, DbndConfig config) {
        this.projectName = projectName;
        this.flowId = flowId;
        this.flowUuid = flowUuid;
        this.executionId = executionId;
        this.jobId = jobId;
        this.config = config;
    }

    public AzkabanTaskContext forJob(String jobId) {
        return new AzkabanTaskContext(this.projectName, this.flowId, this.flowUuid, this.executionId, jobId, this.config);
    }

    public TrackingSource trackingSource() {
        if (this.config.getValue("azkaban.name").isPresent()) {
            return new TrackingSource(this);
        }
        return null;
    }

    public String databandJobName() {
        return String.format("%s.%s", this.flowId, this.jobId);
    }

    public String projectName() {
        return this.projectName;
    }

    public String flowId() {
        return this.flowId;
    }

    public String flowUuid() {
        return this.flowUuid;
    }

    public String executionId() {
        return this.executionId;
    }

    public String jobId() {
        return this.jobId;
    }

    public Optional<String> userId() {
        return Optional.of(System.getenv("azkaban.flow.submituser"));
    }

    public String azkabanInstanceId() {
        return String.format("%s:%s", this.config.getValue("azkaban.name").orElse("azkaban"), this.config.getValue("azkaban.label").orElse("azkaban"));
    }

    public String azkabanInstanceUuid() {
        return new Uuid5("AZ_INSTANCE_UUID", this.azkabanInstanceId()).toString();
    }

    public String azkabanUrl() {
        String hostName = this.config.getValue("server.hostname").orElse("localhost");
        String port = this.config.getValue("server.port").orElse("8081");
        String protocol = Boolean.TRUE.toString().equalsIgnoreCase(this.config.getValue("jetty.use.ssl").orElse(Boolean.FALSE.toString())) ? "https" : "http";
        return String.format("%s://%s:%s", protocol, hostName, port);
    }

    public RootRun root() {
        return new RootRun("", this.taskRunUid(), this.rootRunUid(), this.taskRunAttemptUid());
    }

    public String runName() {
        return String.format("%s-%s-%s", this.projectName, this.flowId, this.executionId);
    }

    public String jobRunName() {
        return String.format("%s-%s-%s-%s", this.projectName, this.flowId, this.jobId, this.executionId);
    }

    public String rootRunUid() {
        return new Uuid5("RUN_UID", this.flowUuid).toString();
    }

    public String driverTaskUid() {
        return new Uuid5("DRIVER_TASK", this.flowUuid).toString();
    }

    public String driverTaskRunEnvUid() {
        return new Uuid5("TASK_RUN_ENV_UID", this.flowUuid).toString();
    }

    public String driverTaskDefinitionUid() {
        return new Uuid5("TASK_DEFINITION", this.flowUuid).toString();
    }

    public String driverTaskRunAttemptUid() {
        return new Uuid5("TASK_RUN_ATTEMPT", this.flowUuid).toString();
    }

    public String taskRunUid() {
        String taskRunId = this.jobId + this.flowUuid;
        return new Uuid5("TASK_RUN_UID", taskRunId).toString();
    }

    public String taskRunAttemptUid() {
        String taskRunId = this.jobId + this.flowUuid;
        return new Uuid5("TASK_RUN_ATTEMPT", taskRunId).toString();
    }

    public String taskDefinitionUid() {
        String taskRunId = this.jobId + this.flowUuid;
        return new Uuid5("TASK_DEFINITION", taskRunId).toString();
    }
}

