/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.config;

import ai.databand.RandomNames;
import ai.databand.config.Env;
import ai.databand.config.JavaOpts;
import ai.databand.config.PropertiesSource;
import ai.databand.config.SparkConf;
import ai.databand.schema.AirflowTaskContext;
import ai.databand.schema.AzkabanTaskContext;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.spark.SparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbndConfig
implements PropertiesSource {
    private static final Logger LOG = LoggerFactory.getLogger(DbndConfig.class);
    private final AirflowTaskContext afCtx;
    private final AzkabanTaskContext azkbnCtx;
    private final boolean previewEnabled;
    private final boolean trackingEnabled;
    private final boolean verbose;
    private final String databandUrl;
    private final String cmd;
    private final String runName;
    private final Map<String, String> props;
    private static final int PREVIEW_HEAD_TAIL_DEFAULT = 32768;

    public DbndConfig() {
        this(new SparkConf(new Env(new JavaOpts())));
    }

    public DbndConfig(PropertiesSource props) {
        this(props, System.getProperties().getProperty("sun.java.command"));
    }

    public DbndConfig(PropertiesSource props, String cmd) {
        this.cmd = cmd;
        this.props = props.values();
        this.afCtx = this.buildAirflowCtxFromEnv(this.props);
        this.azkbnCtx = this.buildAzkabanCtxFromEnv(this.props);
        this.previewEnabled = this.isTrue(this.props, "dbnd.tracking.data_preview") || this.isTrue(this.props, "dbnd.tracking.log_value_preview");
        this.verbose = this.isTrue(this.props, "dbnd.tracking.verbose");
        this.databandUrl = this.props.getOrDefault("dbnd.core.databand_url", "http://localhost:8080");
        this.trackingEnabled = this.afCtx != null ? !this.isFalse(this.props, "dbnd.tracking") || this.isMissing(this.props, "dbnd.tracking") : this.isTrue(this.props, "dbnd.tracking");
        this.runName = this.azkbnCtx == null ? this.props.getOrDefault("dbnd.run.name", RandomNames.next()) : this.azkbnCtx.jobRunName();
    }

    private AirflowTaskContext buildAirflowCtxFromEnv(Map<String, String> env) {
        if (env.containsKey("AIRFLOW_CTX_DAG_ID") && env.containsKey("AIRFLOW_CTX_EXECUTION_DATE") && env.containsKey("AIRFLOW_CTX_TASK_ID") && env.containsKey("AIRFLOW_CTX_TRY_NUMBER")) {
            return new AirflowTaskContext(env.get("AIRFLOW_CTX_UID"), env.get("AIRFLOW_CTX_UID"), env.get("AIRFLOW_CTX_DAG_ID"), env.get("AIRFLOW_CTX_EXECUTION_DATE"), env.get("AIRFLOW_CTX_TASK_ID"), env.get("AIRFLOW_CTX_TRY_NUMBER"));
        }
        return null;
    }

    private AzkabanTaskContext buildAzkabanCtxFromEnv(Map<String, String> env) {
        Optional<AzkabanTaskContext> fromFile = this.readFromProperties(env);
        return fromFile.orElseGet(() -> this.buildFromMap(env));
    }

    private AzkabanTaskContext buildFromMap(Map<String, String> env) {
        if (env.containsKey("azkaban.flow.flowid") && env.containsKey("azkaban.flow.flowid") && env.containsKey("azkaban.flow.uuid") && env.containsKey("azkaban.flow.execid") && env.containsKey("azkaban.job.id")) {
            return new AzkabanTaskContext(env.get("azkaban.flow.flowid"), env.get("azkaban.flow.flowid"), env.get("azkaban.flow.uuid"), env.get("azkaban.flow.execid"), env.get("azkaban.job.id"), this);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<AzkabanTaskContext> readFromProperties(Map<String, String> env) {
        if (!env.containsKey("JOB_PROP_FILE")) return Optional.empty();
        String fileName = env.get("JOB_PROP_FILE");
        try (FileInputStream input = new FileInputStream(fileName);){
            Properties props = new Properties();
            props.load(input);
            Optional<AzkabanTaskContext> optional = Optional.ofNullable(this.buildFromMap(props));
            return optional;
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public String databandUrl() {
        return this.databandUrl;
    }

    public boolean isPreviewEnabled() {
        return this.previewEnabled;
    }

    public boolean isTrackingEnabled() {
        return this.trackingEnabled;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Optional<AirflowTaskContext> airflowContext() {
        return Optional.ofNullable(this.afCtx);
    }

    public Optional<AzkabanTaskContext> azkabanContext() {
        return Optional.ofNullable(this.azkbnCtx);
    }

    public String cmd() {
        return this.cmd;
    }

    public String runName() {
        return this.runName;
    }

    public Optional<String> jobName() {
        return this.getValue("dbnd.run.job_name");
    }

    public Optional<String> personalAccessToken() {
        return this.getValue("dbnd.core.databand_access_token");
    }

    public int previewTotalBytes() {
        return this.previewHeadBytes() + this.previewTailBytes();
    }

    public int previewHeadBytes() {
        return this.getInteger("dbnd.log.preview_head_bytes", 32768);
    }

    public int previewTailBytes() {
        return this.getInteger("dbnd.log.preview_tail_bytes", 32768);
    }

    public boolean sparkListenerInjectEnabled() {
        return !this.isFalse("dbnd.spark.listener_inject_enabled");
    }

    public boolean sparkIoTrackingEnabled() {
        return this.isTrue("dbnd.spark.io_tracking_enabled");
    }

    protected Integer getInteger(String key, Integer defaultValue) {
        String value = this.props.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            LOG.error("Unable to read integer value from {}. Returning default value {}", (Object)value, (Object)defaultValue);
            return defaultValue;
        }
    }

    public String sparkAppName() {
        try {
            SparkContext ctx = SparkContext.getOrCreate();
            return ctx.getConf().get("spark.app.name");
        }
        catch (Exception e) {
            return "none";
        }
    }

    @Override
    public Map<String, String> values() {
        return Collections.unmodifiableMap(this.props);
    }

    protected final boolean isTrue(String key) {
        return Boolean.TRUE.toString().equalsIgnoreCase(this.props.get(key));
    }

    protected final boolean isFalse(String key) {
        return Boolean.FALSE.toString().equalsIgnoreCase(this.props.get(key));
    }

    protected final boolean isTrue(Map<String, String> env, String key) {
        return Boolean.TRUE.toString().equalsIgnoreCase(env.get(key));
    }

    protected final boolean isFalse(Map<String, String> env, String key) {
        return Boolean.FALSE.toString().equalsIgnoreCase(env.get(key));
    }

    protected final boolean isMissing(Map<String, String> env, String key) {
        return !env.containsKey(key);
    }

    @Override
    public Optional<String> getValue(String key) {
        String value = this.props.get(key);
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }
}

