/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.config;

import ai.databand.config.NormalizedProps;
import ai.databand.config.PropertiesSource;
import ai.databand.config.SimpleProps;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public class SparkConf
implements PropertiesSource {
    private final Map<String, String> props;

    public SparkConf(String command) {
        this(new SimpleProps(), command);
    }

    public SparkConf(PropertiesSource parent) {
        this(parent, System.getProperties().getProperty("sun.java.command"));
    }

    public SparkConf(PropertiesSource parent, String command) {
        this.props = new HashMap<String, String>(parent.values());
        HashMap<String, String> sparkProps = new HashMap<String, String>();
        boolean isNextPropsFilePath = false;
        for (String next : command.split(" ")) {
            String[] keyValue;
            if (isNextPropsFilePath) {
                for (Map.Entry<Object, Object> property : this.readPropertiesFile(next).entrySet()) {
                    String key = (String)property.getKey();
                    if (!key.startsWith("spark.env.")) continue;
                    sparkProps.put(key.replace("spark.env.", ""), (String)property.getValue());
                }
                isNextPropsFilePath = false;
            }
            if (next.startsWith("--properties-file")) {
                isNextPropsFilePath = true;
            }
            if (!next.startsWith("spark.env.") || !next.contains("=") || (keyValue = next.split("=")).length != 2) continue;
            sparkProps.put(keyValue[0].replace("spark.env.", ""), keyValue[1]);
        }
        this.props.putAll(new NormalizedProps(sparkProps).values());
    }

    private Properties readPropertiesFile(String propertiesPath) {
        Properties properties = new Properties();
        if (propertiesPath != null && Files.exists(Paths.get(propertiesPath, new String[0]), new LinkOption[0])) {
            try (FileInputStream input = new FileInputStream(propertiesPath);){
                properties.load(input);
            }
            catch (IOException e) {
                System.out.println("Unable to read Spark properties from file " + propertiesPath);
                e.printStackTrace();
            }
        }
        return properties;
    }

    @Override
    public Map<String, String> values() {
        return Collections.unmodifiableMap(this.props);
    }

    @Override
    public Optional<String> getValue(String key) {
        return Optional.ofNullable(this.props.get(key));
    }
}

