/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.log;

import ai.databand.DbndWrapper;
import ai.databand.log.HistogramRequest;
import ai.databand.log.LogDatasetRequest;
import ai.databand.schema.DatasetOperationStatus;
import ai.databand.schema.DatasetOperationType;
import org.apache.spark.sql.Dataset;

public class DbndLogger {
    public static void logMetric(String key, Object value) {
        try {
            DbndWrapper.instance().logMetric(key, value);
        }
        catch (Throwable e) {
            System.out.println("DbndLogger: Unable to log metric");
            e.printStackTrace();
        }
    }

    public static void logDataframe(String key, Object value, boolean withHistograms) {
        try {
            DbndWrapper.instance().logDataframe(key, (Dataset)value, withHistograms);
        }
        catch (Throwable e) {
            System.out.println("DbndLogger: Unable to log dataframe");
            e.printStackTrace();
        }
    }

    public static void logDataframe(String key, Object value, HistogramRequest histogramRequest) {
        try {
            DbndWrapper.instance().logDataframe(key, (Dataset)value, histogramRequest);
        }
        catch (Throwable e) {
            System.out.println("DbndLogger: Unable to log dataframe");
            e.printStackTrace();
        }
    }

    public static void logDatasetOperation(String path, DatasetOperationType type, Dataset<?> data) {
        DbndLogger.logDatasetOperation(path, type, DatasetOperationStatus.OK, data, new LogDatasetRequest());
    }

    public static void logDatasetOperation(String path, DatasetOperationType type, Dataset<?> data, LogDatasetRequest params) {
        DbndLogger.logDatasetOperation(path, type, DatasetOperationStatus.OK, data, params);
    }

    public static void logDatasetOperation(String path, DatasetOperationType type, DatasetOperationStatus status, Dataset<?> data) {
        DbndLogger.logDatasetOperation(path, type, status, data, new LogDatasetRequest());
    }

    public static void logDatasetOperation(String path, DatasetOperationType type, DatasetOperationStatus status, Dataset<?> data, LogDatasetRequest params) {
        DbndLogger.logDatasetOperation(path, type, status, data, null, params);
    }

    public static void logDatasetOperation(String path, DatasetOperationType type, DatasetOperationStatus status, Dataset<?> data, Throwable error) {
        DbndLogger.logDatasetOperation(path, type, status, data, error, new LogDatasetRequest());
    }

    public static void logDatasetOperation(String path, DatasetOperationType type, DatasetOperationStatus status, Dataset<?> data, Throwable error, LogDatasetRequest params) {
        try {
            DbndWrapper.instance().logDatasetOperation(path, type, status, data, error, params);
        }
        catch (Throwable e) {
            System.out.println("DbndLogger: Unable to log dataset operation");
            e.printStackTrace();
        }
    }
}

