/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.config;

import java.util.HashMap;
import java.util.Map;

public class DbndAgentConfig {
    private final Map<String, String> properties = new HashMap<String, String>(1);

    public DbndAgentConfig(String args) {
        if (args == null) {
            return;
        }
        if ((args = args.trim()).isEmpty()) {
            return;
        }
        for (String argPair : args.split(",")) {
            String[] keyValue = argPair.split("=");
            if (keyValue.length != 2) {
                throw new IllegalArgumentException("Arguments for the agent should be like: key1=value1,key2=value2");
            }
            String key = keyValue[0].trim();
            if (key.isEmpty()) {
                throw new IllegalArgumentException("Argument key should not be empty");
            }
            this.properties.put(key, keyValue[1].trim());
        }
    }

    protected final boolean isTrue(String key) {
        return Boolean.TRUE.toString().equalsIgnoreCase(this.properties.get(key));
    }

    public boolean isVerbose() {
        return this.isTrue("dbnd.tracking.verbose");
    }

    public boolean sparkQueryListenerInjectEnabled() {
        return this.isTrue("dbnd.spark.query_listener_inject_enabled");
    }

    public boolean sparkListenerInjectEnabled() {
        return this.isTrue("dbnd.spark.listener_inject_enabled");
    }

    public boolean sparkIoTrackingEnabled() {
        return this.isTrue("dbnd.spark.io_tracking_enabled");
    }
}

