/*
 * Decompiled with CFR 0.152.
 */
package ai.databand;

import ai.databand.DbndWrapper;
import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class DbndAppLog {
    private final Logger LOG;
    public static final String LOG_PREFIX = "<<DBND>> ";

    public DbndAppLog(Logger log4j) {
        this.LOG = log4j;
    }

    public static void printf(Level lvl, String msg, Object ... args) {
        LocalDateTime dt = LocalDateTime.now();
        String timeStamp = dt.format(DateTimeFormatter.ofPattern("YY/MM/dd HH:mm:ss"));
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        StackTraceElement ste = st[2];
        PrintStream outOrErr = lvl == Level.ERROR ? System.err : System.out;
        String logInfos = String.format("%s %s %s.%s: %sp ", timeStamp, lvl, ste.getClassName(), ste.getMethodName(), LOG_PREFIX);
        outOrErr.printf(logInfos + msg, args);
    }

    public static void printfln(Level lvl, String msg, Object ... args) {
        DbndAppLog.printf(lvl, msg + "%n", args);
    }

    public static void printfv(String msg, Object ... args) {
        if (DbndWrapper.instance().config().isVerbose()) {
            DbndAppLog.printf(Level.INFO, msg, args);
        }
    }

    public static void printfvln(String msg, Object ... args) {
        DbndAppLog.printfv(msg + "%n", args);
    }

    public void info(String msg, Object ... args) {
        this.LOG.info(LOG_PREFIX + msg + "%n", args);
    }

    public void warn(String msg, Object ... args) {
        this.LOG.warn(LOG_PREFIX + msg + "%n", args);
    }

    public void error(String msg, Object ... args) {
        this.LOG.error(LOG_PREFIX + msg + "%n", args);
    }

    public void verbose(String msg, Object ... args) {
        if (DbndWrapper.instance().config().isVerbose()) {
            this.LOG.info(LOG_PREFIX + msg, args);
        }
    }
}

