/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.spark;

import ai.databand.DbndAppLog;
import ai.databand.DbndWrapper;
import ai.databand.config.DbndConfig;
import ai.databand.spark.SparkIOSource;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.sql.execution.SparkPlanInfo;
import org.slf4j.LoggerFactory;
import scala.Tuple2;
import scala.collection.Iterator;

public class DbndSparkListener
extends SparkListener {
    private static final DbndAppLog LOG = new DbndAppLog(LoggerFactory.getLogger(DbndSparkListener.class));
    private final DbndWrapper dbnd;

    public DbndSparkListener(DbndWrapper dbnd) {
        this.dbnd = dbnd;
        LOG.jvmInfo("Succesfully constructed Databand Listener instance. Selected Spark properties and metrics will be submitted to the Databand service.", new Object[0]);
    }

    public DbndSparkListener() {
        this.dbnd = DbndWrapper.instance();
        LOG.jvmInfo("Succesfully constructed Databand Listener instance. Selected Spark properties and metrics will be submitted to the Databand service.", new Object[0]);
    }

    protected void extractIoInfo(SparkPlanInfo plan) {
        for (Tuple2 next : plan.metadata()) {
            if (!"Location".equalsIgnoreCase((String)next._1())) continue;
            SparkIOSource source = new SparkIOSource((String)next._2(), "spark_plan_info");
            this.dbnd.logMetric(source.metricKey(), source);
        }
        Iterator it = plan.children().iterator();
        while (it.hasNext()) {
            this.extractIoInfo((SparkPlanInfo)it.next());
        }
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        try {
            DbndConfig conf = this.dbnd.config();
            conf.setSparkProperties(jobStart.properties());
        }
        catch (Throwable e) {
            LOG.error("Failed to set Spark properties during onJobStart() handling:  {}", e);
        }
    }
}

