/*
 * Decompiled with CFR 0.152.
 */
package ai.databand;

import ai.databand.DbndWrapper;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class DbndAppLog {
    private final Logger LOG;
    public static final String LOG_PREFIX = "[[==DBND==]] ";

    public DbndAppLog(Logger log4j) {
        this.LOG = log4j;
    }

    private static String getClassName(StackTraceElement ste) {
        String stFullClassName = ste.getClassName();
        return stFullClassName.substring(stFullClassName.lastIndexOf(46) + 1);
    }

    private static void printf(Level lvl, String msg, Object ... args) {
        LocalDateTime dt = LocalDateTime.now();
        String timeStamp = dt.format(DateTimeFormatter.ofPattern("YY/MM/dd HH:mm:ss"));
        StackTraceElement[] st = Thread.currentThread().getStackTrace();
        StackTraceElement ste = st[3];
        String stClassName = DbndAppLog.getClassName(ste);
        if (stClassName.equals(DbndAppLog.class.getSimpleName())) {
            stClassName = DbndAppLog.getClassName(st[4]);
        }
        PrintStream outOrErr = lvl == Level.ERROR ? System.err : System.out;
        String logInfos = String.format("%s %s %s: %sstdout: ", timeStamp, lvl, stClassName, LOG_PREFIX);
        outOrErr.printf(logInfos + String.format(msg, args), new Object[0]);
    }

    public static void printfln(Level lvl, String msg, Object ... args) {
        DbndAppLog.printf(lvl, msg + "%n", args);
    }

    public void info(String msg, Object ... args) {
        this.LOG.info(LOG_PREFIX + msg, args);
    }

    public void jvmInfo(String msg, Object ... args) {
        this.LOG.info("[[==DBND==]] [" + ManagementFactory.getRuntimeMXBean().getName() + "] " + msg, args);
    }

    public void warn(String msg, Object ... args) {
        this.LOG.warn(LOG_PREFIX + msg, args);
    }

    public void error(String msg, Object ... args) {
        this.LOG.error(LOG_PREFIX + msg, args);
    }

    public void verbose(String msg, Object ... args) {
        if (DbndWrapper.instance().config().isVerbose()) {
            this.LOG.info("[[==DBND==]] v " + msg, args);
        }
    }
}

