/*
 * Decompiled with CFR 0.152.
 */
package ai.databand.mlflow;

import ai.databand.DbndApi;
import ai.databand.DbndApiBuilder;
import ai.databand.RandomNames;
import ai.databand.config.DbndConfig;
import ai.databand.id.Sha1Long;
import ai.databand.id.Sha1Short;
import ai.databand.id.Uuid5;
import ai.databand.schema.InitRun;
import ai.databand.schema.InitRunArgs;
import ai.databand.schema.LogMetric;
import ai.databand.schema.Metric;
import ai.databand.schema.NewRunInfo;
import ai.databand.schema.RootRun;
import ai.databand.schema.SetRunState;
import ai.databand.schema.TaskDefinition;
import ai.databand.schema.TaskParamDefinition;
import ai.databand.schema.TaskRun;
import ai.databand.schema.TaskRunAttemptUpdate;
import ai.databand.schema.TaskRunEnv;
import ai.databand.schema.TaskRunParam;
import ai.databand.schema.TaskRunsInfo;
import ai.databand.schema.UpdateTaskRunAttempts;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import org.mlflow.api.proto.Service;
import org.mlflow.tracking.MlflowClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public class DbndMlflowClient
extends MlflowClient {
    private static final Logger LOG = LoggerFactory.getLogger(DbndMlflowClient.class);
    private final DbndApi dbnd;
    private final MlflowClient mlflowClient;
    private final String dbndTrackingUri;

    public static MlflowClient newClient() {
        DbndConfig config = new DbndConfig();
        String trackerUrl = config.databandUrl();
        StubMlFlowClient mlflowClient = System.getenv("MLFLOW_TRACKING_URI") == null ? new StubMlFlowClient() : new MlflowClient();
        return new DbndMlflowClient(mlflowClient, trackerUrl);
    }

    public DbndMlflowClient(MlflowClient mlflowClient, String dbndTrackingUri) {
        this(mlflowClient, dbndTrackingUri, new DbndConfig());
    }

    public DbndMlflowClient(MlflowClient mlflowClient, String dbndTrackingUri, DbndConfig config) {
        super("http://127.0.0.1");
        this.dbndTrackingUri = dbndTrackingUri;
        this.mlflowClient = mlflowClient;
        this.dbnd = new DbndApiBuilder(config).build();
    }

    public DbndApi dbndApi() {
        return this.dbnd;
    }

    public Service.RunInfo createRun(Service.CreateRun request) {
        String runUid;
        Service.RunInfo mlFlowRunInfo = this.mlflowClient.createRun(request);
        String experimentId = request.getExperimentId();
        String userId = request.getUserId();
        String rootRunUid = runUid = this.uuid5("RUN_UID", experimentId);
        String driverTaskUid = this.uuid5("DRIVER_TASK", experimentId);
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        String jobName = "embed_mlflow";
        String rootRunUrl = String.format("%s/app/jobs/%s/%s", this.dbndTrackingUri, jobName, runUid);
        String taskRunEnvUid = this.uuid5("TASK_RUN_ENV_UID", experimentId);
        String taskRunUid = driverTaskUid;
        String userCodeVersion = this.uuid5("USER_CODE_VERSION", experimentId);
        String taskRunAttemptUid = this.uuid5("TASK_RUN_ATTEMPT", experimentId);
        String machine = "mlflow machine";
        String cmd = "mlflow run";
        String databandVersion = "0.24.0";
        String version = "mlflowVersion";
        String taskSignature = this.sha1short("TASK_SIGNATURE", experimentId);
        String taskDefinitionUid = this.uuid5("TASK_DEFINITION", experimentId);
        String taskAfId = "mlflow_driver__" + this.sha1short("TASK_AF", experimentId);
        String env = "mlflow";
        InitRun data = new InitRun(new InitRunArgs(runUid, rootRunUid, driverTaskUid, new NewRunInfo(null, env, null, "mlflow_inproces", now, now, false, "mlflow", false, runUid, "mlflow cloud", "unknown", runUid, jobName, userId, null, RandomNames.next(), "RUNNING", now, new RootRun(rootRunUrl, null, rootRunUid, null)), new TaskRunEnv("None", taskRunEnvUid, userId, userCodeVersion, machine, cmd, now, databandVersion, "/", true), new TaskRunsInfo(taskRunEnvUid, Collections.emptyList(), runUid, Collections.singletonList(new TaskRun(runUid, true, false, null, version, taskRunUid, taskSignature, jobName, Collections.singletonList(new TaskRunParam("True", "context", "_meta_input")), taskSignature, false, now.toLocalDate(), now, "/logs", "RUNNING", taskDefinitionUid, cmd, false, false, taskRunAttemptUid, taskAfId, false, false, cmd, taskAfId, "mlflow", Collections.emptyMap())), Collections.emptyList(), rootRunUid, Collections.emptyList(), false, Collections.singletonList(new TaskDefinition("mlflow_task", "...", this.sha1long("SOURCE", experimentId), "", taskDefinitionUid, this.sha1long("MODULE_SOURCE", experimentId), Collections.singletonList(new TaskParamDefinition("_meta_input", "task_input", "user", false, true, "bool", "", "NOTHING")), "mlflow_task", "java", "...")), null)));
        try {
            Response res = this.dbnd.initRun(data).execute();
            if (res.isSuccessful()) {
                LOG.info("[task_run: {}] Run created", (Object)experimentId);
            } else {
                LOG.error("[task_run: {}] Unable to create run", (Object)experimentId);
            }
        }
        catch (IOException e) {
            LOG.error(String.format("[task_run: %s] Unable to create run", data.getInitArgs()), (Throwable)e);
        }
        return mlFlowRunInfo;
    }

    public void setTerminated(String runId) {
        this.mlflowClient.setTerminated(runId);
        String runUid = this.uuid5("RUN_UID", runId);
        String taskRunAttemptUid = this.uuid5("TASK_RUN_ATTEMPT", runId);
        UpdateTaskRunAttempts taskRunAttempts = new UpdateTaskRunAttempts(Collections.singletonList(new TaskRunAttemptUpdate(runUid, taskRunAttemptUid, "SUCCESS", ZonedDateTime.now(ZoneOffset.UTC), ZonedDateTime.now(ZoneOffset.UTC), null)));
        try {
            Response res = this.dbnd.updateTaskRunAttempts(taskRunAttempts).execute();
            if (res.isSuccessful()) {
                LOG.info("[task_run: {}] Completed", (Object)runUid);
            } else {
                LOG.error("[task_run: {}] Unable to complete task run attempt", (Object)runUid);
            }
        }
        catch (IOException e) {
            LOG.error(String.format("[task_run: %s] Unable to complete task run attempt", runUid), (Throwable)e);
        }
        SetRunState data = new SetRunState(runUid, "SUCCESS", ZonedDateTime.now(ZoneOffset.UTC));
        try {
            Response res = this.dbnd.setRunState(data).execute();
            if (res.isSuccessful()) {
                LOG.info("[task_run: {}] Completed", (Object)runUid);
            } else {
                LOG.error("[task_run: {}] Unable to complete run", (Object)runUid);
            }
        }
        catch (IOException e) {
            LOG.error(String.format("[task_run: %s] Unable to complete run", runUid), (Throwable)e);
        }
    }

    public void logMetric(String runId, String key, double value, long timestamp, long step) {
        String taskRunAttemptUid = this.uuid5("TASK_RUN_ATTEMPT", runId);
        this.mlflowClient.logMetric(runId, key, value, timestamp, step);
        LogMetric data = new LogMetric(taskRunAttemptUid, new Metric(key, (Object)String.valueOf(value), ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC)));
        try {
            Response res = this.dbnd.logMetric(data).execute();
            if (res.isSuccessful()) {
                LOG.info("[task_run: {}] Sent metric [{}]:[{}]", new Object[]{taskRunAttemptUid, key, value});
            } else {
                LOG.error("[task_run: {}] Unable to send metric", (Object)taskRunAttemptUid);
            }
        }
        catch (IOException e) {
            LOG.error(String.format("[task_run: %s] Unable to send metric", taskRunAttemptUid), (Throwable)e);
        }
    }

    protected String sha1short(String namespace, String name) {
        return new Sha1Short(namespace, name).toString();
    }

    protected String sha1long(String namespace, String name) {
        return new Sha1Long(namespace, name).toString();
    }

    protected String uuid5(String namespace, String name) {
        return new Uuid5(namespace, name).toString();
    }

    private static class StubMlFlowClient
    extends MlflowClient {
        public StubMlFlowClient() {
            super("http://127.0.0.1");
        }

        public void logMetric(String runId, String key, double value, long timestamp, long step) {
        }

        public Service.RunInfo createRun(Service.CreateRun request) {
            Service.RunInfo.Builder builder = Service.RunInfo.newBuilder();
            builder.setExperimentId(request.getExperimentId());
            builder.setStartTime(request.getStartTime());
            builder.setUserId(request.getUserId());
            return builder.build();
        }

        public void setTerminated(String runId) {
        }
    }
}

