package ai.datatower.analytics.data.room.dao;

import ai.datatower.analytics.data.room.bean.Events;
import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.Generated;

@Generated("androidx.room.RoomProcessor")
@SuppressWarnings({"unchecked", "deprecation"})
public final class EventInfoDao_Impl implements EventInfoDao {
  private final RoomDatabase __db;

  private final EntityInsertionAdapter<Events> __insertionAdapterOfEvents;

  private final EntityDeletionOrUpdateAdapter<Events> __deletionAdapterOfEvents;

  private final SharedSQLiteStatement __preparedStmtOfDeleteTheOldestData;

  private final SharedSQLiteStatement __preparedStmtOfDeleteEventByEventSyn;

  private final SharedSQLiteStatement __preparedStmtOfClearTable;

  public EventInfoDao_Impl(RoomDatabase __db) {
    this.__db = __db;
    this.__insertionAdapterOfEvents = new EntityInsertionAdapter<Events>(__db) {
      @Override
      public String createQuery() {
        return "INSERT OR ABORT INTO `events` (`_id`,`event_syn`,`data`,`created_at`) VALUES (nullif(?, 0),?,?,?)";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Events value) {
        stmt.bindLong(1, value.getId());
        if (value.getEventSyn() == null) {
          stmt.bindNull(2);
        } else {
          stmt.bindString(2, value.getEventSyn());
        }
        if (value.getData() == null) {
          stmt.bindNull(3);
        } else {
          stmt.bindString(3, value.getData());
        }
        stmt.bindLong(4, value.getCreatedAt());
      }
    };
    this.__deletionAdapterOfEvents = new EntityDeletionOrUpdateAdapter<Events>(__db) {
      @Override
      public String createQuery() {
        return "DELETE FROM `events` WHERE `_id` = ?";
      }

      @Override
      public void bind(SupportSQLiteStatement stmt, Events value) {
        stmt.bindLong(1, value.getId());
      }
    };
    this.__preparedStmtOfDeleteTheOldestData = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM events WHERE _id IN ( SELECT t._id FROM ( SELECT _id FROM events ORDER BY _id ASC LIMIT ? ) AS t)";
        return _query;
      }
    };
    this.__preparedStmtOfDeleteEventByEventSyn = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "DELETE FROM events WHERE event_syn=?";
        return _query;
      }
    };
    this.__preparedStmtOfClearTable = new SharedSQLiteStatement(__db) {
      @Override
      public String createQuery() {
        final String _query = "delete  from events";
        return _query;
      }
    };
  }

  @Override
  public long insertEvent(final Events events) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      long _result = __insertionAdapterOfEvents.insertAndReturnId(events);
      __db.setTransactionSuccessful();
      return _result;
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void delete(final Events event) {
    __db.assertNotSuspendingTransaction();
    __db.beginTransaction();
    try {
      __deletionAdapterOfEvents.handle(event);
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  @Override
  public void deleteTheOldestData(final int num) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteTheOldestData.acquire();
    int _argIndex = 1;
    _stmt.bindLong(_argIndex, num);
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfDeleteTheOldestData.release(_stmt);
    }
  }

  @Override
  public void deleteEventByEventSyn(final String eventSyn) {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfDeleteEventByEventSyn.acquire();
    int _argIndex = 1;
    if (eventSyn == null) {
      _stmt.bindNull(_argIndex);
    } else {
      _stmt.bindString(_argIndex, eventSyn);
    }
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfDeleteEventByEventSyn.release(_stmt);
    }
  }

  @Override
  public void clearTable() {
    __db.assertNotSuspendingTransaction();
    final SupportSQLiteStatement _stmt = __preparedStmtOfClearTable.acquire();
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
      __preparedStmtOfClearTable.release(_stmt);
    }
  }

  @Override
  public String[] queryEventData(final int limit) {
    final String _sql = "SELECT data FROM events limit 0,? ";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 1);
    int _argIndex = 1;
    _statement.bindLong(_argIndex, limit);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final String[] _result = new String[_cursor.getCount()];
      int _index = 0;
      while(_cursor.moveToNext()) {
        final String _item;
        if (_cursor.isNull(0)) {
          _item = null;
        } else {
          _item = _cursor.getString(0);
        }
        _result[_index] = _item;
        _index ++;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public int dataCount() {
    final String _sql = "select count(*) as num from events";
    final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire(_sql, 0);
    __db.assertNotSuspendingTransaction();
    final Cursor _cursor = DBUtil.query(__db, _statement, false, null);
    try {
      final int _result;
      if(_cursor.moveToFirst()) {
        _result = _cursor.getInt(0);
      } else {
        _result = 0;
      }
      return _result;
    } finally {
      _cursor.close();
      _statement.release();
    }
  }

  @Override
  public void deleteBatchEventByEventSyn(final List<String> eventSyn) {
    __db.assertNotSuspendingTransaction();
    StringBuilder _stringBuilder = StringUtil.newStringBuilder();
    _stringBuilder.append("DELETE FROM events WHERE event_syn IN (");
    final int _inputSize = eventSyn.size();
    StringUtil.appendPlaceholders(_stringBuilder, _inputSize);
    _stringBuilder.append(" )");
    final String _sql = _stringBuilder.toString();
    final SupportSQLiteStatement _stmt = __db.compileStatement(_sql);
    int _argIndex = 1;
    for (String _item : eventSyn) {
      if (_item == null) {
        _stmt.bindNull(_argIndex);
      } else {
        _stmt.bindString(_argIndex, _item);
      }
      _argIndex ++;
    }
    __db.beginTransaction();
    try {
      _stmt.executeUpdateDelete();
      __db.setTransactionSuccessful();
    } finally {
      __db.endTransaction();
    }
  }

  public static List<Class<?>> getRequiredConverters() {
    return Collections.emptyList();
  }
}
