package ai.devtools.selenium;

import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

import java.util.List;

public abstract class By extends org.openqa.selenium.By {

        public static By ai(String elementName) {
            return new ByAI(elementName);
        }

        public static By ai(String elementName, Float customAIThreshold) {
            return new ByAI(elementName, customAIThreshold);
        }

        public static class ByAI extends By {
            public final String aiElementName;
            public Float customAIThreshold;

            public ByAI(String elementName) {
                this.aiElementName = elementName;
            }

            public ByAI(String elementName, Float customAIThreshold) {

                this.aiElementName = elementName;
                this.customAIThreshold = customAIThreshold;
            }


            @Override
            public List<WebElement> findElements(SearchContext searchContext) {
                return ((SmartDriver) searchContext).findElementsByAI(this.aiElementName, this.customAIThreshold );
            }

            @Override
            public WebElement findElement(SearchContext searchContext) {
                return ((SmartDriver) searchContext).findElementByAI(this.aiElementName, this.customAIThreshold);
            }

            @Override
            public String toString() {
                return "By.ai: " + aiElementName;
            }
        }
}
