package ai.devtools.utils;
import org.opencv.core.*;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;

import java.awt.image.BufferedImage;

import java.io.File;


import javax.imageio.ImageIO;
import java.awt.Graphics2D;
import java.io.IOException;

public class LocalClassifyUtils {

      public void match() throws IOException {
         // Load the image and the template
         String inputImageFilename = System.getenv("IMG_INP");
         String templateImageFilename = System.getenv("IMG_TPL");
         BufferedImage image = ImageIO.read(new File(inputImageFilename));
         BufferedImage template = ImageIO.read(new File(templateImageFilename));

         // Convert the images to grayscale
         BufferedImage grayImage = toGrayscale(image);
         BufferedImage grayTemplate = toGrayscale(template);

         // Find the best match
         int bestX = 0, bestY = 0;
         double bestValue = Double.NEGATIVE_INFINITY;
         for (int y = 0; y <= grayImage.getHeight() - grayTemplate.getHeight(); y++) {
            for (int x = 0; x <= grayImage.getWidth() - grayTemplate.getWidth(); x++) {
               double value = templateMatching(grayImage, grayTemplate, x, y);
               if (value > bestValue) {
                  bestX = x;
                  bestY = y;
                  bestValue = value;
               }
            }
         }


         System.out.println("Match found at " + bestX + ", " + bestY);
      }

      private static BufferedImage toGrayscale(BufferedImage image) {
         BufferedImage grayImage = new BufferedImage(image.getWidth(), image.getHeight(), BufferedImage.TYPE_BYTE_GRAY);
         Graphics2D g = grayImage.createGraphics();
         g.drawImage(image, 0, 0, null);
         g.dispose();
         return grayImage;
      }

      private static double templateMatching(BufferedImage image, BufferedImage template, int x, int y) {
         double sum = 0.0;
         for (int j = 0; j < template.getHeight(); j++) {
            for (int i = 0; i < template.getWidth(); i++) {
               int imagePixel = image.getRGB(x + i, y + j) & 0xFF;
               int templatePixel = template.getRGB(i, j) & 0xFF;
               sum += Math.pow(imagePixel - templatePixel, 2);
            }
         }
         return -sum / (template.getWidth() * template.getHeight());
      }


   public void testTemplateMatch() {
      nu.pattern.OpenCV.loadShared();
      System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
      String inputImageFilename = System.getenv("IMG_INP");
      String templateImageFilename = System.getenv("IMG_TPL");
      Mat inputImage = Imgcodecs.imread(inputImageFilename);
      Mat templateImage = Imgcodecs.imread(templateImageFilename);

      // Create the result matrix
      Mat result = new Mat();

      // Perform the template matching operation
      Imgproc.matchTemplate(inputImage, templateImage, result, Imgproc.TM_CCOEFF);

      // Find the maximum value in the result matrix
      Core.MinMaxLocResult mmr = Core.minMaxLoc(result);

      // Get the location of the maximum value
      Point matchLoc = mmr.maxLoc;
   }
}
