/*
 * Decompiled with CFR 0.152.
 */
package ai.devtools.appium;

import ai.devtools.appium.SmartDriverElement;
import ai.devtools.utils.CollectionUtils;
import ai.devtools.utils.JsonUtils;
import ai.devtools.utils.NetUtils;
import ai.devtools.utils.Utils;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.MobileElement;
import io.appium.java_client.ios.IOSDriver;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.DeviceRotation;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.ScreenOrientation;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.html5.Location;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.helpers.MessageFormatter;

public class SmartDriver<T extends MobileElement> {
    private static String SDK_VERSION = "appium-0.1.20";
    private boolean isMobileWeb = false;
    public boolean isIOS;
    public boolean isEspresso;
    private Logger log = Logger.getLogger(SmartDriver.class);
    private OkHttpClient client;
    public AppiumDriver<T> driver;
    private String apiKey;
    private HttpUrl serverURL;
    private String prodUrl = "https://smartdriver.dev-tools.ai";
    private String testCaseName;
    private String lastTestCaseScreenshotUUID;
    public double multiplier;
    private Dimension windowSize;
    private Dimension imSize;
    private Boolean useClassifierDuringCreation;
    private Boolean testCaseCreationMode;
    private String refScreenshotUUID;
    private float pageOffset;
    private float previousPageOffset;
    private String automationName;

    public SmartDriver(AppiumDriver<T> driver, String apiKey, Map<String, Object> initializationDict) throws IOException {
        String baseUrl;
        String automationName;
        this.driver = driver;
        this.apiKey = apiKey;
        this.log.setLevel(org.apache.log4j.Level.INFO);
        BasicConfigurator.configure();
        this.isIOS = driver instanceof IOSDriver;
        Object automationNameObject = driver.getCapabilities().getCapability("automationName");
        Object platformNameObject = driver.getCapabilities().getCapability("platformName");
        String platformName = platformNameObject == null ? "" : platformNameObject.toString();
        String string = automationName = automationNameObject == null ? "" : automationNameObject.toString();
        if (automationName == "" && platformName == "Android") {
            automationName = "UiAutomator2";
        }
        this.isEspresso = automationName.equals("Espresso");
        this.testCaseName = (String)initializationDict.get("testCaseName");
        this.useClassifierDuringCreation = true;
        if (initializationDict.get("useClassifierDuringCreation") != null) {
            this.useClassifierDuringCreation = (Boolean)initializationDict.get("useClassifierDuringCreation");
        }
        this.testCaseCreationMode = Utils.StrToBool(System.getenv("DEVTOOLSAI_INTERACTIVE"));
        if (this.testCaseName == null) {
            StackTraceElement[] sl = Thread.currentThread().getStackTrace();
            if (sl.length > 0) {
                StackTraceElement bottom = sl[sl.length - 1];
                this.testCaseName = String.format("%s.%s", bottom.getClassName(), bottom.getMethodName());
                this.log.info((Object)("No test case name was specified, defaulting to " + this.testCaseName));
            } else {
                this.testCaseName = "My first test case";
            }
        }
        this.serverURL = HttpUrl.parse((String)((baseUrl = (String)initializationDict.get("serverURL")) != null ? baseUrl : Objects.requireNonNullElse(System.getenv("DEVTOOLSAI_URL"), this.prodUrl)));
        this.client = this.serverURL.equals((Object)HttpUrl.parse((String)"https://smartdriver.dev-tools.ai")) ? NetUtils.unsafeClient() : NetUtils.basicClient().build();
        BufferedImage im = ImageIO.read((File)driver.getScreenshotAs(OutputType.FILE));
        this.imSize = new Dimension(im.getWidth(), im.getHeight());
        if (this.isMobileWeb) {
            float windowHeight = this.getWebWindowHeight();
            float windowWidth = this.getWebWindowWidth();
            this.windowSize = new Dimension((int)windowWidth, (int)windowHeight);
            this.multiplier = 2.0;
        } else {
            this.windowSize = driver.manage().window().getSize();
            this.multiplier = 1.0 * (double)this.imSize.width / (double)this.windowSize.width;
        }
        this.log.debug((Object)("The screen multiplier is " + this.multiplier));
        try {
            JsonObject payload = CollectionUtils.keyValuesToJO("api_key", apiKey, "os", String.format("%s-%s-%s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")), "sdk_version", SDK_VERSION, "language", String.format("java-%s", System.getProperty("java.version")), "test_case_name", this.testCaseName, "automation_name", automationName);
            this.log.debug((Object)MessageFormatter.format((String)"Checking in with: {}", (Object)payload.toString()).toString());
            JsonObject r = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "ping", payload));
            if (!JsonUtils.booleanFromJson(r, "success")) {
                this.log.debug((Object)MessageFormatter.format((String)"Error during checkin, server said: {}", (Object)r.toString()).getMessage());
            }
        }
        catch (Throwable e) {
            this.log.debug((Object)MessageFormatter.format((String)"Checkin failed catastrophically: {}", (Object)e.getMessage()).getMessage());
        }
    }

    private float getWebWindowHeight() {
        AppiumDriver<T> js = this.driver;
        Object res = js.executeScript("return window.innerHeight;", new Object[0]);
        if (res instanceof Number) {
            return ((Number)res).floatValue();
        }
        return 0.0f;
    }

    private float getWebWindowWidth() {
        AppiumDriver<T> js = this.driver;
        Object res = js.executeScript("return window.innerWidth;", new Object[0]);
        if (res instanceof Number) {
            return ((Number)res).floatValue();
        }
        return 0.0f;
    }

    public SmartDriver(AppiumDriver<T> driver, String apiKey) throws IOException {
        this(driver, apiKey, new HashMap<String, Object>());
    }

    public SmartDriver implicitlyWait(long waitTime) {
        this.driver.manage().timeouts().implicitlyWait(waitTime, TimeUnit.SECONDS);
        return this;
    }

    public Response execute(String command) {
        return this.driver.execute(command);
    }

    public Response execute(String command, Map<String, ?> parameters) {
        return this.driver.execute(command, parameters);
    }

    public String getContext() {
        return this.driver.getContext();
    }

    public Set<String> getContextHandles() {
        return this.driver.getContextHandles();
    }

    public ExecuteMethod getExecuteMethod() {
        return this.driver.getExecuteMethod();
    }

    public ScreenOrientation getOrientation() {
        return this.driver.getOrientation();
    }

    public URL getRemoteAddress() {
        return this.driver.getRemoteAddress();
    }

    public boolean isBrowser() {
        return this.driver.isBrowser();
    }

    public Location location() {
        return this.driver.location();
    }

    public void rotate(DeviceRotation rotation) {
        this.driver.rotate(rotation);
    }

    public void rotate(ScreenOrientation orientation) {
        this.driver.rotate(orientation);
    }

    public DeviceRotation rotation() {
        return this.driver.rotation();
    }

    public void setLocation(Location location) {
        this.driver.setLocation(location);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        return this.driver.executeAsyncScript(script, args);
    }

    public Object executeScript(String script, Object ... args) {
        return this.driver.executeScript(script, args);
    }

    public Keyboard getKeyboard() {
        return this.driver.getKeyboard();
    }

    public Mouse getMouse() {
        return this.driver.getMouse();
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    public WebDriver.Navigation navigate() {
        return this.driver.navigate();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.driver.switchTo();
    }

    public void get(String url) {
        this.driver.get(url);
    }

    public T findElement(By locator, String elementName) {
        if (elementName == null) {
            elementName = String.format("element_name_by_locator_%s", locator.toString().replace('.', '_').replace(' ', '_'));
        }
        try {
            String key;
            MobileElement driverElement = (MobileElement)this.driver.findElement(locator);
            if (driverElement != null && (key = this.uploadScreenshotIfNecessary(elementName, driverElement)) != null) {
                this.updateElement(driverElement, key, elementName, true);
            }
            return (T)driverElement;
        }
        catch (Throwable x) {
            this.log.info((Object)MessageFormatter.format((String)"Element '{}' was not found by Selenium, trying with Smartdriver...", (Object)elementName).getMessage());
            ClassifyResult<T> result = this.classify(elementName);
            if (result.e != null) {
                return result.e.realElement;
            }
            this.log.error((Object)result.msg);
            this.log.error((Object)MessageFormatter.format((String)"Smartdriver was also unable to find the element with name '{}'", (Object)elementName).getMessage());
            throw x;
        }
    }

    public MobileElement findElement(By locator) {
        return this.findElement(locator, null);
    }

    public List<T> findElements(By locator) {
        return this.driver.findElements(locator);
    }

    public Capabilities getCapabilities() {
        return this.driver.getCapabilities();
    }

    public CommandExecutor getCommandExecutor() {
        return this.driver.getCommandExecutor();
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public ErrorHandler getErrorHandler() {
        return this.driver.getErrorHandler();
    }

    public FileDetector getFileDetector() {
        return this.driver.getFileDetector();
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public <X> X getScreenshotAs(OutputType<X> outputType) {
        return (X)this.driver.getScreenshotAs(outputType);
    }

    public SessionId getSessionId() {
        return this.driver.getSessionId();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    public void perform(Collection<Sequence> actions) {
        this.driver.perform(actions);
    }

    public void quit() {
        this.driver.quit();
    }

    public void resetInputState() {
        this.driver.resetInputState();
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.driver.setErrorHandler(handler);
    }

    public void setFileDetector(FileDetector detector) {
        this.driver.setFileDetector(detector);
    }

    public void setLogLevel(Level level) {
        this.driver.setLogLevel(level);
    }

    public String toString() {
        return this.driver.toString();
    }

    public T findElementByClassName(String using, String elementName) {
        return this.findElement(By.className((String)using), elementName);
    }

    public T findElementByClassName(String using) {
        return this.findElementByClassName(using, null);
    }

    public List<T> findElementsByClassName(String using) {
        return this.driver.findElements(By.className((String)using));
    }

    public T findElementByCssSelector(String using, String elementName) {
        return this.findElement(By.cssSelector((String)using), elementName);
    }

    public T findElementByCssSelector(String using) {
        return this.findElementByCssSelector(using, null);
    }

    public List<T> findElementsByCssSelector(String using) {
        return this.driver.findElements(By.cssSelector((String)using));
    }

    public T findElementById(String using, String elementName) {
        return this.findElement(By.id((String)using), elementName);
    }

    public T findElementById(String using) {
        return this.findElementById(using, null);
    }

    public List<T> findElementsById(String using) {
        return this.driver.findElements(By.id((String)using));
    }

    public T findElementByLinkText(String using, String elementName) {
        return this.findElement(By.linkText((String)using), elementName);
    }

    public T findElementByLinkText(String using) {
        return this.findElementByLinkText(using, null);
    }

    public List<T> findElementsByLinkText(String using) {
        return this.driver.findElements(By.linkText((String)using));
    }

    public T findElementByName(String using, String elementName) {
        return this.findElement(By.name((String)using), elementName);
    }

    public T findElementByName(String using) {
        return this.findElementByName(using, null);
    }

    public List<T> findElementsByName(String using) {
        return this.driver.findElements(By.name((String)using));
    }

    public T findElementByPartialLinkText(String using, String elementName) {
        return this.findElement(By.partialLinkText((String)using), elementName);
    }

    public T findElementByPartialLinkText(String using) {
        return this.findElementByPartialLinkText(using, null);
    }

    public List<T> findElementsByPartialLinkText(String using) {
        return this.driver.findElements(By.partialLinkText((String)using));
    }

    public T findElementByTagName(String using, String elementName) {
        return this.findElement(By.tagName((String)using), elementName);
    }

    public T findElementByTagName(String using) {
        return this.findElementByTagName(using, null);
    }

    public List<T> findElementsByTagName(String using) {
        return this.driver.findElements(By.tagName((String)using));
    }

    public T findElementByXPath(String using, String elementName) {
        return this.findElement(By.xpath((String)using), elementName);
    }

    public T findElementByXPath(String using) {
        return this.findElementByXPath(using, null);
    }

    public List<T> findElementsByXPath(String using) {
        return this.driver.findElements(By.xpath((String)using));
    }

    public T findByElementName(String elementName) {
        return this.findElementByElementName(elementName);
    }

    public T findElementByElementName(String elementName) {
        ClassifyResult<T> r = this.classify(elementName);
        if (r.e == null) {
            throw new NoSuchElementException(r.msg);
        }
        return r.e.realElement;
    }

    public T findByAI(String elementName) {
        return this.findElementByElementName(elementName);
    }

    private String getScreenshotHash(String screenshotBase64) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] md5sum = md.digest(screenshotBase64.getBytes(StandardCharsets.UTF_8));
            String output = String.format("%032X", new BigInteger(1, md5sum));
            return output.toLowerCase();
        }
        catch (Throwable e) {
            return "";
        }
    }

    private JsonObject checkScreenshotExists(String screenshotUUID, String elementName) {
        JsonObject payload = new JsonObject();
        payload.addProperty("api_key", this.apiKey);
        payload.addProperty("label", elementName);
        payload.addProperty("screenshot_uuid", screenshotUUID);
        payload.add("stack_trace", (JsonElement)Utils.collectStackTrace());
        try {
            JsonObject res = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "exists_screenshot", payload));
            return res;
        }
        catch (Throwable e) {
            this.log.debug((Object)"Error checking if screenshot exists");
            e.printStackTrace();
            return null;
        }
    }

    private JsonObject uploadScreenshot(String screenshotBase64, String elementName) {
        JsonObject payload = new JsonObject();
        payload.addProperty("api_key", this.apiKey);
        payload.addProperty("label", elementName);
        payload.addProperty("screenshot", screenshotBase64);
        payload.addProperty("test_case_name", this.testCaseName);
        payload.addProperty("is_appium", Boolean.valueOf(true));
        try {
            JsonObject res = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "upload_screenshot", payload));
            return res;
        }
        catch (Throwable e) {
            this.log.debug((Object)"Error uploading screenshot");
            e.printStackTrace();
            return null;
        }
    }

    private JsonObject uploadTCScreenshot(String screenshotBase64, String elementName) {
        JsonObject payload = new JsonObject();
        payload.addProperty("api_key", this.apiKey);
        payload.addProperty("label", elementName);
        payload.addProperty("screenshot", screenshotBase64);
        payload.addProperty("test_case_name", this.testCaseName);
        payload.addProperty("is_interactive", Boolean.valueOf(true));
        payload.addProperty("is_appium", Boolean.valueOf(true));
        try {
            JsonObject res = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "upload_screenshot", payload));
            return res;
        }
        catch (Throwable e) {
            this.log.debug((Object)"Error uploading test case screenshot");
            e.printStackTrace();
            return null;
        }
    }

    public void scrollToElement(T element, Boolean scrollUp) {
    }

    public void scrollPage(int amount) {
    }

    private String uploadScreenshotIfNecessary(String elementName, T element) {
        JsonObject screenshotExistsResponse;
        Boolean isElementFrozen = this.checkIfFrozen(elementName);
        if (isElementFrozen.booleanValue()) {
            return null;
        }
        String screenshotBase64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
        String screenshotUUID = this.getScreenshotHash(screenshotBase64);
        this.refScreenshotUUID = null;
        this.pageOffset = 0.0f;
        if (element != null) {
            this.pageOffset = this.getPageOffset();
            Boolean needsToScroll = (float)element.getRect().getY() > (float)this.windowSize.getHeight() + this.pageOffset || (float)element.getRect().getY() < this.pageOffset;
            if (needsToScroll.booleanValue()) {
                this.previousPageOffset = this.pageOffset;
                this.refScreenshotUUID = screenshotUUID;
                this.scrollToElement(element, (float)element.getRect().getY() < this.pageOffset);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                screenshotBase64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
                screenshotUUID = this.getScreenshotHash(screenshotBase64);
                this.pageOffset = this.getPageOffset();
                this.scrollPage((int)(this.previousPageOffset - this.pageOffset));
            }
        }
        if ((screenshotExistsResponse = this.checkScreenshotExists(screenshotUUID, elementName)) != null && screenshotExistsResponse.get("exists_screenshot").getAsBoolean()) {
            return screenshotUUID;
        }
        JsonObject uploadScreenshotResponse = this.uploadScreenshot(screenshotBase64, elementName);
        if (uploadScreenshotResponse != null) {
            if (uploadScreenshotResponse.get("success").getAsBoolean()) {
                return uploadScreenshotResponse.get("screenshot_uuid").getAsString();
            }
            this.log.info((Object)"Error uploading screenshot");
            return screenshotUUID;
        }
        this.log.info((Object)"Error uploading screenshot");
        return screenshotUUID;
    }

    private Boolean checkIfFrozen(String elementName) {
        JsonObject payload = new JsonObject();
        payload.addProperty("api_key", this.apiKey);
        payload.addProperty("label", elementName);
        try {
            JsonObject res = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "check_frozen", payload));
            return res.get("is_frozen").getAsBoolean();
        }
        catch (Throwable e) {
            this.log.debug((Object)"Error checking if element is frozen");
            e.printStackTrace();
            return true;
        }
    }

    private T findElementByGeneric(String using, String elementName, String shortcode, Function<String, T> fn) {
        if (elementName == null) {
            elementName = String.format("element_name_by_%s_%s", shortcode, using.replace('.', '_'));
        }
        try {
            String key;
            MobileElement driverElement = (MobileElement)fn.apply(using);
            if (driverElement != null && (key = this.uploadScreenshotIfNecessary(elementName, driverElement)) != null) {
                this.updateElement(driverElement, key, elementName, true);
            }
            return (T)driverElement;
        }
        catch (Throwable x) {
            this.log.info((Object)MessageFormatter.format((String)"Element '{}' was not found by Selenium, trying with Smartdriver...", (Object)elementName).getMessage());
            ClassifyResult<T> result = this.classify(elementName);
            if (result.e != null) {
                return result.e.realElement;
            }
            this.log.error((Object)result.msg);
            this.log.error((Object)MessageFormatter.format((String)"Smartdriver was also unable to find the element with name '{}'", (Object)elementName).getMessage());
            throw x;
        }
    }

    protected void updateElement(T elem, String screenshotUUID, String elementName, boolean trainIfNecessary) {
        Rectangle rect = elem.getRect();
        JsonObject payload = new JsonObject();
        payload.addProperty("screenshot_uuid", screenshotUUID);
        payload.addProperty("retrain", Boolean.valueOf(trainIfNecessary));
        payload.addProperty("api_key", this.apiKey);
        payload.addProperty("label", elementName);
        payload.addProperty("x", (Number)((double)rect.x * this.multiplier));
        payload.addProperty("y", (Number)((double)rect.y * this.multiplier));
        payload.addProperty("width", (Number)((double)rect.width * this.multiplier));
        payload.addProperty("height", (Number)((double)rect.height * this.multiplier));
        payload.addProperty("multiplier", (Number)this.multiplier);
        payload.addProperty("test_case_name", this.testCaseName);
        payload.addProperty("page_offset", (Number)((double)this.pageOffset * this.multiplier));
        payload.addProperty("ref_screenshot_uuid", this.refScreenshotUUID);
        try {
            JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "add_action_info", payload));
        }
        catch (Throwable e) {
            this.log.debug((Object)"Error updating element");
            e.printStackTrace();
        }
    }

    private CollectionUtils.Tuple<JsonObject, Boolean> getTCBox(String elementName, String eventUUID) {
        JsonObject payload = new JsonObject();
        payload.addProperty("api_key", this.apiKey);
        payload.addProperty("label", elementName);
        payload.addProperty("screenshot_uuid", this.lastTestCaseScreenshotUUID);
        payload.addProperty("run_classifier", this.useClassifierDuringCreation);
        payload.addProperty("event_id", eventUUID);
        payload.add("stack_trace", (JsonElement)Utils.collectStackTrace());
        Boolean needsReload = false;
        try {
            JsonObject res = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "testcase/get_action_info", payload));
            needsReload = res.get("needs_reload").getAsBoolean();
            return new CollectionUtils.Tuple<JsonObject, Boolean>(res, needsReload);
        }
        catch (Throwable e) {
            this.log.debug((Object)"Error getting TC box");
            e.printStackTrace();
            return new CollectionUtils.Tuple<Object, Boolean>(null, needsReload);
        }
    }

    private void openBrowser(String url) {
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("mac")) {
                Runtime.getRuntime().exec("open " + url);
            } else if (os.contains("windows")) {
                Runtime.getRuntime().exec("run " + url);
            } else {
                this.log.info((Object)MessageFormatter.format((String)"Please open the following URL in your browser: {}", (Object)url).getMessage());
            }
        }
        catch (Throwable e) {
            this.log.info((Object)MessageFormatter.format((String)"Please open the following URL in your browser: {}", (Object)url).getMessage());
        }
    }

    protected ClassifyResult<T> classify(String elementName) {
        if (this.testCaseCreationMode.booleanValue()) {
            String screenshotBase64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            JsonObject res = this.uploadTCScreenshot(screenshotBase64, elementName);
            if (res.get("success").getAsBoolean()) {
                this.lastTestCaseScreenshotUUID = res.get("screenshot_uuid").getAsString();
                CollectionUtils.Tuple<JsonObject, Boolean> boxResponseTp = this.getTCBox(elementName, null);
                JsonObject boxResponse = (JsonObject)boxResponseTp.k;
                Boolean needsReload = (Boolean)boxResponseTp.v;
                if (boxResponse != null && boxResponse.get("success").getAsBoolean() && boxResponse.get("predicted_element") != JsonNull.INSTANCE) {
                    return new ClassifyResult(new SmartDriverElement(boxResponse.get("predicted_element").getAsJsonObject(), this, this.getPageOffset()), this.lastTestCaseScreenshotUUID);
                }
                String eventUUID = UUID.randomUUID().toString();
                String labelUrl = this.serverURL + "/testcase/label?test_case_name=" + URLEncoder.encode(this.testCaseName) + "&event_id=" + eventUUID + "&api_key=" + this.apiKey;
                this.openBrowser(labelUrl);
                while (true) {
                    boxResponseTp = this.getTCBox(elementName, eventUUID);
                    boxResponse = (JsonObject)boxResponseTp.k;
                    needsReload = (Boolean)boxResponseTp.v;
                    if (boxResponse != null && boxResponse.get("success").getAsBoolean() && boxResponse.get("predicted_element") != JsonNull.INSTANCE) {
                        return new ClassifyResult(new SmartDriverElement(boxResponse.get("predicted_element").getAsJsonObject(), this, this.getPageOffset()), this.lastTestCaseScreenshotUUID);
                    }
                    if (needsReload.booleanValue()) {
                        screenshotBase64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
                        this.uploadTCScreenshot(screenshotBase64, elementName);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.log.info((Object)"Failed to upload test case screenshot");
            this.log.info((Object)res.get("message").getAsString());
            return new ClassifyResult(null, this.lastTestCaseScreenshotUUID, res.get("message").getAsString());
        }
        String pageSource = "";
        String msg = "Smartdriver driver exception";
        String key = null;
        try {
            String screenshotBase64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            String screenshotUUID = this.getScreenshotHash(screenshotBase64);
            JsonObject screenshotExistsResponse = this.checkScreenshotExists(screenshotUUID, elementName);
            if (screenshotExistsResponse != null && screenshotExistsResponse.get("success").getAsBoolean() && screenshotExistsResponse.get("predicted_element") != JsonNull.INSTANCE) {
                msg = screenshotExistsResponse.get("message").getAsString();
                this.log.info((Object)msg);
                float currentOffset = this.getPageOffset();
                float bottomOffset = currentOffset + (float)this.windowSize.height;
                float realOffset = (float)((double)screenshotExistsResponse.get("page_offset").getAsFloat() / this.multiplier);
                if (realOffset > bottomOffset || realOffset < currentOffset) {
                    int scrollOffset = (int)(realOffset - currentOffset);
                    this.scrollPage(scrollOffset);
                    Thread.sleep(1000L);
                    screenshotBase64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
                    screenshotUUID = this.getScreenshotHash(screenshotBase64);
                    screenshotExistsResponse = this.checkScreenshotExists(screenshotUUID, elementName);
                }
                if (screenshotExistsResponse != null && screenshotExistsResponse.get("success").getAsBoolean() && screenshotExistsResponse.get("predicted_element") != JsonNull.INSTANCE) {
                    return new ClassifyResult(new SmartDriverElement(screenshotExistsResponse.get("predicted_element").getAsJsonObject(), this, this.getPageOffset()), null);
                }
            }
            JsonObject payload = new JsonObject();
            payload.addProperty("api_key", this.apiKey);
            payload.addProperty("label", elementName);
            payload.addProperty("screenshot", screenshotBase64);
            payload.addProperty("test_case_name", this.testCaseName);
            payload.add("stack_trace", (JsonElement)Utils.collectStackTrace());
            JsonObject classifyResponse = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "detect", payload));
            if (!classifyResponse.get("success").getAsBoolean() && !(classifyResponse = this.classifyFullScreen(elementName, screenshotBase64)).get("success").getAsBoolean()) {
                this.log.info((Object)classifyResponse.get("message").getAsString());
                return new ClassifyResult(null, null, classifyResponse.get("message").getAsString());
            }
            msg = classifyResponse.get("message").getAsString().replace(this.prodUrl, this.serverURL.toString());
            this.log.info((Object)msg);
            try {
                return new ClassifyResult(new SmartDriverElement(classifyResponse.get("predicted_element").getAsJsonObject(), this, this.getPageOffset()), classifyResponse.get("screenshot_uuid").getAsString());
            }
            catch (Throwable e) {
                this.log.error((Object)"Error creating SmartDriverElement from response");
                e.printStackTrace();
                return new ClassifyResult(null, key, msg);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.log.warn((Object)msg);
            return new ClassifyResult(null, key, msg);
        }
    }

    private float getPageOffset() {
        return 0.0f;
    }

    JsonObject classifyFullScreen(String elementName, String screenshotBase64) {
        int lastOffset = -1;
        int offset = 1;
        int windowHeight = this.windowSize.height;
        this.scrollPage(-100000);
        JsonObject r = new JsonObject();
        r.addProperty("success", Boolean.valueOf(false));
        while (offset > lastOffset) {
            lastOffset = offset;
            screenshotBase64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
            JsonObject payload = new JsonObject();
            payload.addProperty("api_key", this.apiKey);
            payload.addProperty("label", elementName);
            payload.addProperty("screenshot", screenshotBase64);
            payload.addProperty("test_case_name", this.testCaseName);
            payload.add("stack_trace", (JsonElement)Utils.collectStackTrace());
            try {
                r = JsonUtils.responseAsJson(NetUtils.basicPOST(this.client, this.serverURL, "detect", payload));
                if (r.get("success").getAsBoolean() || !this.isMobileWeb) {
                    return r;
                }
            }
            catch (Throwable e) {
                this.log.error((Object)"Error creating SmartDriverElement from response");
                e.printStackTrace();
                return r;
            }
            this.scrollPage(windowHeight);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            offset = (int)this.getPageOffset();
        }
        return r;
    }

    public void close() {
        this.driver.close();
    }

    private static class ClassifyResult<T extends MobileElement> {
        public SmartDriverElement<T> e;
        public String key;
        public String msg;

        ClassifyResult(SmartDriverElement<T> e, String key, String msg) {
            this.e = e;
            this.key = key;
            this.msg = msg;
        }

        ClassifyResult(SmartDriverElement<T> e, String key) {
            this(e, key, "");
        }
    }
}

