/*
 * Decompiled with CFR 0.152.
 */
package ai.devtools.appium;

import ai.devtools.appium.SmartDriver;
import ai.devtools.utils.JsonUtils;
import ai.devtools.utils.MatchUtilsAppium;
import com.google.gson.JsonObject;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.MobileElement;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartDriverElement<T extends MobileElement>
extends MobileElement {
    private static Logger log = LoggerFactory.getLogger(SmartDriverElement.class);
    private AppiumDriver<T> driver;
    public T realElement;
    private String text;
    private Dimension size;
    private Point location;
    private Rectangle rectangle;
    private String tagName;

    SmartDriverElement(JsonObject elem, SmartDriver<T> driver) {
        this(elem, driver, 0.0f);
    }

    SmartDriverElement(JsonObject elem, SmartDriver<T> driver, float page_offset) {
        log.debug("Creating new SmartDriverElement w/ {}", (Object)elem);
        this.driver = driver.driver;
        int pageY = elem.get("y").getAsInt();
        elem.remove("y");
        elem.addProperty("y", (Number)((double)pageY + (double)page_offset * driver.multiplier));
        this.realElement = new MatchUtilsAppium<T>().matchBoundingBoxToAppiumElement(elem, driver);
        this.text = JsonUtils.stringFromJson(elem, "text");
        this.size = new Dimension(JsonUtils.intFromJson(elem, "width") / Math.max((int)driver.multiplier, 1), JsonUtils.intFromJson(elem, "height") / Math.max((int)driver.multiplier, 1));
        this.location = new Point(JsonUtils.intFromJson(elem, "x") / Math.max((int)driver.multiplier, 1), JsonUtils.intFromJson(elem, "y") / Math.max((int)driver.multiplier, 1));
        this.rectangle = new Rectangle(this.location, this.size);
        this.tagName = JsonUtils.stringFromJson(elem, "class");
    }

    public String toString() {
        return "SmartDriverElement: " + this.text;
    }

    public String getText() {
        return this.text;
    }

    public Dimension getSize() {
        return this.size;
    }

    public Point getLocation() {
        return this.location;
    }

    public Rectangle getRect() {
        return this.rectangle;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void clear() {
        this.realElement.clear();
    }

    public T findElement(By by) {
        return (T)((MobileElement)this.driver.findElement(by));
    }

    public String getAttribute(String name) {
        return this.realElement.getAttribute(name);
    }

    public String getCssValue(String propertyName) {
        return this.realElement.getCssValue(propertyName);
    }

    public boolean isDisplayed() {
        return this.realElement.isDisplayed();
    }

    public boolean isEnabled() {
        return this.realElement.isEnabled();
    }

    public boolean isSelected() {
        return this.realElement.isSelected();
    }

    public void click() {
        this.realElement.click();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.realElement.sendKeys(keysToSend);
    }

    public void submit() {
        this.realElement.submit();
    }
}

