/*
 * Decompiled with CFR 0.152.
 */
package ai.devtools.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static Logger log = LoggerFactory.getLogger(JsonUtils.class);

    public static JsonObject responseAsJson(Response r) {
        try {
            String body = r.body().string();
            log.debug("Status: {} ----- Body: {}", (Object)r.code(), (Object)body);
            return JsonParser.parseString((String)body).getAsJsonObject();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String stringFromJson(JsonObject jo, String key) {
        return jo.has(key) ? jo.get(key).getAsString() : "";
    }

    public static double doubleFromJson(JsonObject jo, String key) {
        return jo.has(key) ? jo.get(key).getAsDouble() : 0.0;
    }

    public static int intFromJson(JsonObject jo, String key) {
        return jo.has(key) ? jo.get(key).getAsInt() : 0;
    }

    public static boolean booleanFromJson(JsonObject jo, String key) {
        return jo.has(key) ? jo.get(key).getAsBoolean() : false;
    }
}

