/*
 * Decompiled with CFR 0.152.
 */
package ai.devtools.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import nu.pattern.OpenCV;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;

public class LocalClassifyUtils {
    public void match() throws IOException {
        String inputImageFilename = System.getenv("IMG_INP");
        String templateImageFilename = System.getenv("IMG_TPL");
        BufferedImage image = ImageIO.read(new File(inputImageFilename));
        BufferedImage template = ImageIO.read(new File(templateImageFilename));
        BufferedImage grayImage = LocalClassifyUtils.toGrayscale(image);
        BufferedImage grayTemplate = LocalClassifyUtils.toGrayscale(template);
        int bestX = 0;
        int bestY = 0;
        double bestValue = Double.NEGATIVE_INFINITY;
        for (int y = 0; y <= grayImage.getHeight() - grayTemplate.getHeight(); ++y) {
            for (int x = 0; x <= grayImage.getWidth() - grayTemplate.getWidth(); ++x) {
                double value = LocalClassifyUtils.templateMatching(grayImage, grayTemplate, x, y);
                if (!(value > bestValue)) continue;
                bestX = x;
                bestY = y;
                bestValue = value;
            }
        }
        System.out.println("Match found at " + bestX + ", " + bestY);
    }

    private static BufferedImage toGrayscale(BufferedImage image) {
        BufferedImage grayImage = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        Graphics2D g = grayImage.createGraphics();
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return grayImage;
    }

    private static double templateMatching(BufferedImage image, BufferedImage template, int x, int y) {
        double sum = 0.0;
        for (int j = 0; j < template.getHeight(); ++j) {
            for (int i = 0; i < template.getWidth(); ++i) {
                int imagePixel = image.getRGB(x + i, y + j) & 0xFF;
                int templatePixel = template.getRGB(i, j) & 0xFF;
                sum += Math.pow(imagePixel - templatePixel, 2.0);
            }
        }
        return -sum / (double)(template.getWidth() * template.getHeight());
    }

    public void testTemplateMatch() {
        OpenCV.loadShared();
        System.loadLibrary(Core.NATIVE_LIBRARY_NAME);
        String inputImageFilename = System.getenv("IMG_INP");
        String templateImageFilename = System.getenv("IMG_TPL");
        Mat inputImage = Imgcodecs.imread((String)inputImageFilename);
        Mat templateImage = Imgcodecs.imread((String)templateImageFilename);
        Mat result = new Mat();
        Imgproc.matchTemplate((Mat)inputImage, (Mat)templateImage, (Mat)result, (int)4);
        Core.MinMaxLocResult mmr = Core.minMaxLoc((Mat)result);
        Point matchLoc = mmr.maxLoc;
    }
}

