/*
 * Decompiled with CFR 0.152.
 */
package ai.devtools.utils;

import ai.devtools.appium.SmartDriver;
import ai.devtools.utils.CollectionUtils;
import ai.devtools.utils.MatchUtils;
import com.google.gson.JsonObject;
import io.appium.java_client.MobileElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.StaleElementReferenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatchUtilsAppium<T extends MobileElement> {
    private static Logger log = LoggerFactory.getLogger(MatchUtils.class);

    public T matchBoundingBoxToAppiumElement(JsonObject boundingBox, SmartDriver<T> driver) {
        HashMap<String, Double> newBox = new HashMap<String, Double>();
        newBox.put("x", boundingBox.get("x").getAsDouble() / driver.multiplier);
        newBox.put("y", boundingBox.get("y").getAsDouble() / driver.multiplier);
        newBox.put("width", boundingBox.get("width").getAsDouble() / driver.multiplier);
        newBox.put("height", boundingBox.get("height").getAsDouble() / driver.multiplier);
        List elements = driver.driver.findElements(By.xpath((String)"//*"));
        ArrayList<Double> iouScores = new ArrayList<Double>();
        for (MobileElement e : elements) {
            try {
                iouScores.add(MatchUtilsAppium.iouBoxes(newBox, e.getRect()));
            }
            catch (StaleElementReferenceException x2) {
                log.debug("Stale reference to element '{}', setting score of 0", (Object)e);
                iouScores.add(0.0);
            }
        }
        List<Object> composite = new ArrayList<CollectionUtils.Tuple<Double, MobileElement>>();
        for (int i = 0; i < iouScores.size(); ++i) {
            composite.add(new CollectionUtils.Tuple<Double, MobileElement>((Double)iouScores.get(i), (MobileElement)elements.get(i)));
        }
        Collections.sort(composite, (o1, o2) -> ((Double)o2.k).compareTo((Double)o1.k));
        composite = composite.stream().filter(x -> (Double)x.k > 0.0).filter(x -> MatchUtilsAppium.centerHit(newBox, ((MobileElement)x.v).getRect())).collect(Collectors.toList());
        String attributeForClasses = "className";
        if (driver.isEspresso) {
            attributeForClasses = "class";
        } else if (driver.isIOS) {
            attributeForClasses = "type";
        }
        ArrayList<String> interactableElements = new ArrayList<String>();
        interactableElements.add("input");
        interactableElements.add("edittext");
        interactableElements.add("edit");
        interactableElements.add("select");
        interactableElements.add("dropdown");
        interactableElements.add("button");
        interactableElements.add("textfield");
        interactableElements.add("textarea");
        interactableElements.add("picker");
        ArrayList<String> nonInteractableElements = new ArrayList<String>();
        nonInteractableElements.add("layout");
        for (CollectionUtils.Tuple tuple : composite) {
            for (String s : interactableElements) {
                if (!((MobileElement)tuple.v).getAttribute(attributeForClasses).toLowerCase().contains(s) || !((Double)tuple.k > (Double)((CollectionUtils.Tuple)composite.get((int)0)).k * 0.6)) continue;
                boolean containsNonInteractable = false;
                for (String s2 : nonInteractableElements) {
                    if (!((MobileElement)tuple.v).getAttribute(attributeForClasses).toLowerCase().contains(s2)) continue;
                    containsNonInteractable = true;
                    break;
                }
                if (containsNonInteractable) continue;
                return (T)((MobileElement)tuple.v);
            }
        }
        if (composite.size() == 0) {
            throw new NoSuchElementException("Could not find any web element under the center of the bounding box");
        }
        return (T)((MobileElement)((CollectionUtils.Tuple)composite.get((int)0)).v);
    }

    private static double iouBoxes(Map<String, Double> box1, Rectangle box2) {
        return MatchUtilsAppium.iou(box1.get("x"), box1.get("y"), box1.get("width"), box1.get("height"), box2.x, box2.y, box2.width, box2.height);
    }

    private static double iou(double x, double y, double w, double h, double xx, double yy, double ww, double hh) {
        double overlap = MatchUtilsAppium.areaOverlap(x, y, w, h, xx, yy, ww, hh);
        return overlap / (MatchUtilsAppium.area(w, h) + MatchUtilsAppium.area(ww, hh) - overlap);
    }

    private static double areaOverlap(double x, double y, double w, double h, double xx, double yy, double ww, double hh) {
        double dx = Math.min(x + w, xx + ww) - Math.max(x, xx);
        double dy = Math.min(y + h, yy + hh) - Math.max(y, yy);
        return dx >= 0.0 && dy >= 0.0 ? dx * dy : 0.0;
    }

    private static double area(double w, double h) {
        return w * h;
    }

    private static boolean centerHit(Map<String, Double> box1, Rectangle box2) {
        double centerX = box1.get("x") + box1.get("width") / 2.0;
        double centerY = box1.get("y") + box1.get("height") / 2.0;
        return centerX > (double)box2.x && centerX < (double)(box2.x + box2.width) && centerY > (double)box2.y && centerY < (double)(box2.y + box2.height);
    }
}

