/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.inference;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.metric.Metrics;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.nn.Block;
import ai.djl.training.ParameterStore;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePredictor<I, O>
implements Predictor<I, O> {
    private static final Logger logger = LoggerFactory.getLogger(BasePredictor.class);
    private Translator<I, O> translator;
    private long timestamp;
    protected Model model;
    protected NDManager manager;
    Metrics metrics;
    private Block block;
    private ParameterStore parameterStore;

    public BasePredictor(Model model, Translator<I, O> translator, boolean copy) {
        this.model = model;
        this.manager = model.getNDManager().newSubManager();
        this.translator = translator;
        this.block = model.getBlock();
        this.parameterStore = new ParameterStore(this.manager, copy);
    }

    @Override
    public O predict(I input) throws TranslateException {
        return this.batchPredict(Collections.singletonList(input)).get(0);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<O> batchPredict(List<I> inputs) throws TranslateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    protected void waitToRead(NDList list) {
    }

    protected NDList forward(NDList ndList) {
        logger.trace("Predictor input data: {}", (Object)ndList);
        return this.block.forward(this.parameterStore, ndList);
    }

    private NDList processInputs(TranslatorContext ctx, List<I> inputs) throws Exception {
        int batchSize = inputs.size();
        NDList[] preprocessed = new NDList[batchSize];
        for (int i = 0; i < batchSize; ++i) {
            preprocessed[i] = this.translator.processInput(ctx, inputs.get(i));
        }
        return this.translator.getBatchifier().batchify(preprocessed);
    }

    private List<O> processOutputs(TranslatorContext ctx, NDList list) throws Exception {
        NDList[] unbatched = this.translator.getBatchifier().unbatchify(list);
        ArrayList outputs = new ArrayList(unbatched.length);
        for (NDList output : unbatched) {
            outputs.add(this.translator.processOutput(ctx, output));
        }
        return outputs;
    }

    private void preprocessEnd(NDList list) {
        if (this.metrics != null) {
            this.waitToRead(list);
            long tmp = System.nanoTime();
            long duration = tmp - this.timestamp;
            this.timestamp = tmp;
            this.metrics.addMetric("Preprocess", duration, "nano");
        }
    }

    private void forwardEnd(NDList list) {
        if (this.metrics != null) {
            this.waitToRead(list);
            long tmp = System.nanoTime();
            long duration = tmp - this.timestamp;
            this.timestamp = tmp;
            this.metrics.addMetric("Inference", duration, "nano");
        }
    }

    private void postProcessEnd() {
        if (this.metrics != null) {
            long tmp = System.nanoTime();
            long duration = tmp - this.timestamp;
            this.timestamp = tmp;
            this.metrics.addMetric("Postprocess", duration, "nano");
        }
    }

    @Override
    public void close() {
        this.manager.close();
    }

    private class PredictorContext
    implements TranslatorContext {
        private NDManager ctxManager;
        private Map<String, Object> attachments;

        PredictorContext() {
            this.ctxManager = BasePredictor.this.manager.newSubManager();
            this.attachments = new ConcurrentHashMap<String, Object>();
        }

        @Override
        public Model getModel() {
            return BasePredictor.this.model;
        }

        @Override
        public NDManager getNDManager() {
            return this.ctxManager;
        }

        @Override
        public Metrics getMetrics() {
            return BasePredictor.this.metrics;
        }

        @Override
        public void close() {
            this.ctxManager.close();
        }

        @Override
        public Object getAttachment(String key) {
            return this.attachments.get(key);
        }

        @Override
        public void setAttachment(String key, Object value) {
            this.attachments.put(key, value);
        }
    }
}

