/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv;

import ai.djl.Model;
import ai.djl.modality.cv.BoundingBox;
import ai.djl.modality.cv.DetectedObjects;
import ai.djl.modality.cv.ImageTranslator;
import ai.djl.modality.cv.Mask;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.Utils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class InstanceSegmentationTranslator
extends ImageTranslator<DetectedObjects>
implements Transform {
    private String synsetArtifactName;
    private float threshold;
    private int shortEdge;
    private int maxEdge;
    private int rescaledWidth;
    private int rescaledHeight;

    public InstanceSegmentationTranslator(Builder builder) {
        super(builder);
        this.synsetArtifactName = builder.synsetArtifactName;
        this.threshold = builder.threshold;
        this.shortEdge = builder.shortEdge;
        this.maxEdge = builder.maxEdge;
    }

    @Override
    public NDArray transform(NDArray array) {
        return this.resizeShort(array);
    }

    @Override
    public NDList processInput(TranslatorContext ctx, BufferedImage image) {
        Pipeline pipeline = this.getPipeline();
        pipeline.insert(0, null, (Transform)this);
        ctx.setAttachment("originalHeight", image.getHeight());
        ctx.setAttachment("originalWidth", image.getWidth());
        return super.processInput(ctx, image);
    }

    @Override
    public DetectedObjects processOutput(TranslatorContext ctx, NDList list) throws IOException {
        Model model = ctx.getModel();
        List classes = model.getArtifact(this.synsetArtifactName, Utils::readLines);
        float[] ids = ((NDArray)list.get(0)).toFloatArray();
        float[] scores = ((NDArray)list.get(1)).toFloatArray();
        NDArray boundingBoxes = (NDArray)list.get(2);
        NDArray masks = (NDArray)list.get(3);
        ArrayList<String> retNames = new ArrayList<String>();
        ArrayList<Double> retProbs = new ArrayList<Double>();
        ArrayList<BoundingBox> retBB = new ArrayList<BoundingBox>();
        for (int i = 0; i < ids.length; ++i) {
            int classId = (int)ids[i];
            double probability = scores[i];
            if (classId < 0 || !(probability > (double)this.threshold)) continue;
            if (classId >= classes.size()) {
                throw new AssertionError((Object)("Unexpected index: " + classId));
            }
            String className = (String)classes.get(classId);
            float[] box = boundingBoxes.get(i).toFloatArray();
            double x = box[0] / (float)this.rescaledWidth;
            double y = box[1] / (float)this.rescaledHeight;
            double w = (double)(box[2] / (float)this.rescaledWidth) - x;
            double h = (double)(box[3] / (float)this.rescaledHeight) - y;
            int maskW = (int)(w * (double)((Integer)ctx.getAttachment("originalWidth")).intValue());
            int maskH = (int)(h * (double)((Integer)ctx.getAttachment("originalHeight")).intValue());
            NDArray array = masks.get(i);
            Shape maskShape = array.getShape();
            array = array.reshape(maskShape.addAll(new Shape(1L)));
            NDArray maskArray = NDImageUtils.resize(array, maskW, maskH).transpose();
            float[] flattened = maskArray.toFloatArray();
            float[][] maskFloat = new float[maskW][maskH];
            for (int j = 0; j < maskW; ++j) {
                System.arraycopy(flattened, j * maskH, maskFloat[j], 0, maskH);
            }
            Mask mask = new Mask(x, y, w, h, maskFloat);
            retNames.add(className);
            retProbs.add(probability);
            retBB.add(mask);
        }
        return new DetectedObjects(retNames, retProbs, retBB);
    }

    private NDArray resizeShort(NDArray image) {
        int max;
        int height;
        Shape shape = image.getShape();
        int width = (int)shape.get(1);
        int min = Math.min(width, height = (int)shape.get(0));
        float scale = (float)this.shortEdge / (float)min;
        if (Math.round(scale * (float)(max = Math.max(width, height))) > this.maxEdge) {
            scale = (float)this.maxEdge / (float)max;
        }
        this.rescaledHeight = Math.round((float)height * scale);
        this.rescaledWidth = Math.round((float)width * scale);
        return NDImageUtils.resize(image, this.rescaledWidth, this.rescaledHeight);
    }

    public static class Builder
    extends ImageTranslator.BaseBuilder<Builder> {
        private String synsetArtifactName;
        private float threshold = 0.3f;
        private int shortEdge = 600;
        private int maxEdge = 1000;

        public Builder setSynsetArtifactName(String synsetArtifactName) {
            this.synsetArtifactName = synsetArtifactName;
            return this;
        }

        public Builder optThreshold(float threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder optShortEdge(int shortEdge) {
            this.shortEdge = shortEdge;
            return this;
        }

        public Builder optMaxEdge(int maxEdge) {
            this.maxEdge = maxEdge;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public InstanceSegmentationTranslator build() {
            if (this.synsetArtifactName == null) {
                throw new IllegalArgumentException("You must specify a synset artifact name");
            }
            return new InstanceSegmentationTranslator(this);
        }
    }
}

