/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.translator;

import ai.djl.modality.cv.util.BufferedImageUtils;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.awt.image.BufferedImage;

public abstract class ImageTranslator<T>
implements Translator<BufferedImage, T> {
    private NDImageUtils.Flag flag;
    private Pipeline pipeline;

    public ImageTranslator(BaseBuilder<?> builder) {
        this.flag = builder.flag;
        this.pipeline = builder.pipeline;
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public NDList processInput(TranslatorContext ctx, BufferedImage input) {
        NDArray array = BufferedImageUtils.toNDArray(ctx.getNDManager(), input, this.flag);
        return this.pipeline.transform(new NDList(array));
    }

    public static abstract class BaseBuilder<T extends BaseBuilder> {
        protected NDImageUtils.Flag flag = NDImageUtils.Flag.COLOR;
        protected Pipeline pipeline;

        public T optFlag(NDImageUtils.Flag flag) {
            this.flag = flag;
            return this.self();
        }

        public T setPipeline(Pipeline pipeline) {
            this.pipeline = pipeline;
            return this.self();
        }

        protected abstract T self();
    }
}

