/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.repository.AbstractRepository;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.util.Progress;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleRepository
extends AbstractRepository {
    private String name;
    private Path path;

    protected SimpleRepository(String name, Path path) {
        this.name = name;
        this.path = path;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getBaseUri() {
        return this.path.toUri();
    }

    @Override
    public Metadata locate(MRL mrl) throws IOException {
        Path file = this.path.resolve("metadata.json");
        if (Files.isRegularFile(file, new LinkOption[0])) {
            return this.metadataWithFile(file);
        }
        return this.metadataWithoutFile();
    }

    private Metadata metadataWithFile(Path file) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(file);){
            Metadata metadata = (Metadata)GSON.fromJson((Reader)reader, Metadata.class);
            metadata.setRepositoryUri(URI.create(""));
            Metadata metadata2 = metadata;
            return metadata2;
        }
    }

    private Metadata metadataWithoutFile() {
        File[] fileList;
        Metadata.MatchAllMetadata metadata = new Metadata.MatchAllMetadata();
        metadata.setRepositoryUri(URI.create(""));
        File file = this.path.toFile();
        if (Files.isRegularFile(this.path, new LinkOption[0])) {
            metadata.setArtifactId(file.getParentFile().getName());
        } else {
            metadata.setArtifactId(file.getName());
        }
        if (!Files.exists(this.path, new LinkOption[0])) {
            return metadata;
        }
        Artifact artifact = new Artifact();
        artifact.setName(file.getName());
        ConcurrentHashMap<String, Artifact.Item> files = new ConcurrentHashMap<String, Artifact.Item>();
        if (file.isDirectory() && (fileList = file.listFiles()) != null) {
            for (File f : fileList) {
                Artifact.Item item = new Artifact.Item();
                item.setName(f.getName());
                item.setSize(f.length());
                item.setArtifact(artifact);
                files.put(f.getName(), item);
            }
        }
        artifact.setFiles(files);
        metadata.setArtifacts(Collections.singletonList(artifact));
        return metadata;
    }

    @Override
    public Artifact resolve(MRL mrl, String version, Map<String, String> filter) throws IOException {
        List<Artifact> artifacts = this.locate(mrl).getArtifacts();
        if (artifacts.isEmpty()) {
            return null;
        }
        return artifacts.get(0);
    }

    @Override
    public Path getResourceDirectory(Artifact artifact) {
        return this.path;
    }

    @Override
    public void prepare(Artifact artifact, Progress progress) {
    }

    @Override
    public Path getCacheDirectory() {
        return this.path;
    }

    @Override
    protected URI resolvePath(Artifact.Item item, String path) {
        return this.path.resolve(item.getName()).toUri();
    }

    @Override
    public List<MRL> getResources() {
        if (!Files.exists(this.path, new LinkOption[0])) {
            return Collections.emptyList();
        }
        MRL mrl = MRL.undefined("ai.djl.localmodelzoo", this.path.toFile().getName());
        return Collections.singletonList(mrl);
    }
}

