/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.zoo;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.translator.ImageClassificationTranslator;
import ai.djl.modality.cv.translator.wrapper.FileTranslatorFactory;
import ai.djl.modality.cv.translator.wrapper.InputStreamTranslatorFactory;
import ai.djl.modality.cv.translator.wrapper.UrlTranslatorFactory;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Pair;
import ai.djl.util.Progress;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;

public class ImageClassificationModelLoader
extends BaseModelLoader {
    private static final Application APPLICATION = Application.CV.IMAGE_CLASSIFICATION;

    public ImageClassificationModelLoader(Repository repository, String groupId, String artifactId, String version, ModelZoo modelZoo) {
        super(repository, MRL.model(APPLICATION, groupId, artifactId), version, modelZoo);
        FactoryImpl factory = new FactoryImpl();
        this.factories.put(new Pair<Class<Image>, Class<Classifications>>(Image.class, Classifications.class), factory);
        this.factories.put(new Pair<Class<Path>, Class<Classifications>>(Path.class, Classifications.class), new FileTranslatorFactory<Classifications>(factory));
        this.factories.put(new Pair<Class<URL>, Class<Classifications>>(URL.class, Classifications.class), new UrlTranslatorFactory<Classifications>(factory));
        this.factories.put(new Pair<Class<InputStream>, Class<Classifications>>(InputStream.class, Classifications.class), new InputStreamTranslatorFactory<Classifications>(factory));
    }

    public ZooModel<Image, Classifications> loadModel() throws MalformedModelException, ModelNotFoundException, IOException {
        return this.loadModel(null, null, null);
    }

    public ZooModel<Image, Classifications> loadModel(Progress progress) throws MalformedModelException, ModelNotFoundException, IOException {
        return this.loadModel(null, null, progress);
    }

    public ZooModel<Image, Classifications> loadModel(Map<String, String> filters, Device device, Progress progress) throws IOException, ModelNotFoundException, MalformedModelException {
        Criteria<Image, Classifications> criteria = Criteria.builder().setTypes(Image.class, Classifications.class).optModelZoo(this.modelZoo).optGroupId(this.resource.getMrl().getGroupId()).optArtifactId(this.resource.getMrl().getArtifactId()).optFilters(filters).optDevice(device).optProgress(progress).build();
        return this.loadModel(criteria);
    }

    private static final class FactoryImpl
    implements TranslatorFactory<Image, Classifications> {
        private FactoryImpl() {
        }

        @Override
        public Translator<Image, Classifications> newInstance(Model model, Map<String, Object> arguments) {
            return ImageClassificationTranslator.builder(arguments).build();
        }
    }
}

