/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.repository;

import ai.djl.Application;
import ai.djl.repository.AbstractRepository;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Metadata;
import ai.djl.repository.VersionRange;
import ai.djl.util.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalRepository
extends AbstractRepository {
    private static final Logger logger = LoggerFactory.getLogger(LocalRepository.class);
    private String name;
    private Path path;

    protected LocalRepository(String name, Path path) {
        this.name = name;
        this.path = path;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getBaseUri() {
        return this.path.toUri();
    }

    @Override
    public Metadata locate(MRL mrl) throws IOException {
        URI uri = mrl.toURI();
        Path base = this.path.resolve(uri.getPath());
        Path file = base.resolve("metadata.json");
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(file);){
            Metadata metadata = (Metadata)JsonUtils.GSON_PRETTY.fromJson((Reader)reader, Metadata.class);
            metadata.init();
            metadata.setRepositoryUri(uri);
            Metadata metadata2 = metadata;
            return metadata2;
        }
    }

    @Override
    public Artifact resolve(MRL mrl, String version, Map<String, String> filter) throws IOException {
        VersionRange range;
        Metadata metadata = this.locate(mrl);
        List<Artifact> artifacts = metadata.search(range = VersionRange.parse(version), filter);
        if (artifacts.isEmpty()) {
            return null;
        }
        return artifacts.get(0);
    }

    @Override
    public List<MRL> getResources() {
        ArrayList<MRL> list = new ArrayList<MRL>();
        try {
            Files.walk(this.path, new FileVisitOption[0]).forEach(f -> {
                if (f.endsWith("metadata.json") && Files.isRegularFile(f, new LinkOption[0])) {
                    Path relative = this.path.relativize((Path)f);
                    String type = relative.getName(0).toString();
                    try (BufferedReader reader = Files.newBufferedReader(f);){
                        Metadata metadata = (Metadata)JsonUtils.GSON.fromJson((Reader)reader, Metadata.class);
                        Application application = metadata.getApplication();
                        String groupId = metadata.getGroupId();
                        String artifactId = metadata.getArtifactId();
                        if ("dataset".equals(type)) {
                            list.add(MRL.dataset(application, groupId, artifactId));
                        } else if ("model".equals(type)) {
                            list.add(MRL.model(application, groupId, artifactId));
                        }
                    }
                    catch (IOException e) {
                        logger.warn("Failed to read metadata.json", (Throwable)e);
                    }
                }
            });
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
        }
        return list;
    }
}

