/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.cv.util;

import ai.djl.modality.cv.Image;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.types.Shape;
import ai.djl.util.RandomUtils;

public final class NDImageUtils {
    private NDImageUtils() {
    }

    public static NDArray resize(NDArray image, int size) {
        return NDImageUtils.resize(image, size, size, Image.Interpolation.BILINEAR);
    }

    public static NDArray resize(NDArray image, int width, int height) {
        return NDImageUtils.resize(image, width, height, Image.Interpolation.BILINEAR);
    }

    public static NDArray resize(NDArray image, int width, int height, Image.Interpolation interpolation) {
        return image.getNDArrayInternal().resize(width, height, interpolation.ordinal());
    }

    public static NDArray normalize(NDArray input, float mean, float std) {
        return NDImageUtils.normalize(input, new float[]{mean, mean, mean}, new float[]{std, std, std});
    }

    public static NDArray normalize(NDArray input, float[] mean, float[] std) {
        return input.getNDArrayInternal().normalize(mean, std);
    }

    public static NDArray toTensor(NDArray image) {
        return image.getNDArrayInternal().toTensor();
    }

    public static NDArray centerCrop(NDArray image) {
        int h;
        Shape shape = image.getShape();
        int w = (int)shape.get(1);
        if (w == (h = (int)shape.get(0))) {
            return image;
        }
        if (w > h) {
            return NDImageUtils.centerCrop(image, h, h);
        }
        return NDImageUtils.centerCrop(image, w, w);
    }

    public static NDArray centerCrop(NDArray image, int width, int height) {
        int y;
        int x;
        Shape shape = image.getShape();
        int w = (int)shape.get(1);
        int h = (int)shape.get(0);
        int dw = (w - width) / 2;
        int dh = (h - height) / 2;
        if (dw > 0) {
            x = dw;
            w = width;
        } else {
            x = 0;
        }
        if (dh > 0) {
            y = dh;
            h = height;
        } else {
            y = 0;
        }
        return NDImageUtils.crop(image, x, y, w, h);
    }

    public static NDArray crop(NDArray image, int x, int y, int width, int height) {
        return image.getNDArrayInternal().crop(x, y, width, height);
    }

    public static NDArray randomFlipLeftRight(NDArray image) {
        return image.getNDArrayInternal().randomFlipLeftRight();
    }

    public static NDArray randomFlipTopBottom(NDArray image) {
        return image.getNDArrayInternal().randomFlipTopBottom();
    }

    public static NDArray randomResizedCrop(NDArray image, int width, int height, double minAreaScale, double maxAreaScale, double minAspectRatio, double maxAspectRatio) {
        Shape shape = image.getShape();
        int h = (int)shape.get(0);
        int w = (int)shape.get(1);
        int srcArea = h * w;
        double targetArea = minAreaScale * (double)srcArea + (maxAreaScale - minAreaScale) * (double)srcArea * (double)RandomUtils.nextFloat();
        double minRatio = targetArea / (double)h / (double)h;
        double maxRatio = (double)w / (targetArea / (double)w);
        double[] dArray = new double[]{Math.max(minRatio, minAspectRatio), Math.min(maxRatio, maxAspectRatio)};
        double[] intersectRatio = dArray;
        if (intersectRatio[1] < intersectRatio[0]) {
            return NDImageUtils.centerCrop(image, width, height);
        }
        float finalRatio = RandomUtils.nextFloat((float)intersectRatio[0], (float)intersectRatio[1]);
        int newWidth = (int)Math.round(Math.sqrt(targetArea * (double)finalRatio));
        int newHeight = (int)((float)newWidth / finalRatio);
        int x = w == newWidth ? 0 : RandomUtils.nextInt(w - newWidth);
        int y = h == newHeight ? 0 : RandomUtils.nextInt(h - newHeight);
        try (NDArray cropped = NDImageUtils.crop(image, x, y, newWidth, newHeight);){
            NDArray nDArray = NDImageUtils.resize(cropped, width, height);
            return nDArray;
        }
    }

    public static NDArray randomBrightness(NDArray image, float brightness) {
        return image.getNDArrayInternal().randomBrightness(brightness);
    }

    public static NDArray randomHue(NDArray image, float hue) {
        return image.getNDArrayInternal().randomHue(hue);
    }

    public static NDArray randomColorJitter(NDArray image, float brightness, float contrast, float saturation, float hue) {
        return image.getNDArrayInternal().randomColorJitter(brightness, contrast, saturation, hue);
    }
}

