/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicdataset.tabular;

import ai.djl.Application;
import ai.djl.basicdataset.BasicDatasets;
import ai.djl.basicdataset.tabular.CsvDataset;
import ai.djl.basicdataset.tabular.utils.Feature;
import ai.djl.repository.Artifact;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.training.dataset.Dataset;
import ai.djl.util.Progress;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.csv.CSVFormat;

public final class AirfoilRandomAccess
extends CsvDataset {
    private static final String ARTIFACT_ID = "airfoil";
    private static final String VERSION = "1.0";
    private static final String[] COLUMNS = new String[]{"freq", "aoa", "chordlen", "freestreamvel", "ssdt", "ssoundpres"};
    private MRL mrl;
    private Dataset.Usage usage;
    private boolean prepared;

    AirfoilRandomAccess(Builder builder) {
        super(builder);
        this.usage = builder.usage;
        this.mrl = builder.getMrl();
    }

    @Override
    public void prepare(Progress progress) throws IOException {
        Path csvFile;
        if (this.prepared) {
            return;
        }
        Artifact artifact = this.mrl.getDefaultArtifact();
        this.mrl.prepare(artifact);
        Path root = this.mrl.getRepository().getResourceDirectory(artifact);
        switch (this.usage) {
            case TRAIN: {
                csvFile = root.resolve("airfoil_self_noise.dat");
                break;
            }
            case TEST: {
                throw new UnsupportedOperationException("Test data not available.");
            }
            default: {
                throw new UnsupportedOperationException("Validation data not available.");
            }
        }
        this.csvUrl = csvFile.toUri().toURL();
        super.prepare(progress);
        this.prepared = true;
    }

    @Override
    public List<String> getColumnNames() {
        return Arrays.asList(COLUMNS).subList(0, 5);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends CsvDataset.CsvBuilder<Builder> {
        Repository repository = BasicDatasets.REPOSITORY;
        String groupId = "ai.djl.basicdataset";
        String artifactId = "airfoil";
        Dataset.Usage usage = Dataset.Usage.TRAIN;
        boolean normalize;

        Builder() {
            this.csvFormat = CSVFormat.TDF.builder().setHeader(COLUMNS).setIgnoreHeaderCase(true).setTrim(true).build();
        }

        @Override
        public Builder self() {
            return this;
        }

        public Builder optUsage(Dataset.Usage usage) {
            this.usage = usage;
            return this;
        }

        public Builder optRepository(Repository repository) {
            this.repository = repository;
            return this;
        }

        public Builder optGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder optArtifactId(String artifactId) {
            if (artifactId.contains(":")) {
                String[] tokens = artifactId.split(":");
                this.groupId = tokens[0];
                this.artifactId = tokens[1];
            } else {
                this.artifactId = artifactId;
            }
            return this;
        }

        public Builder optNormalize(boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        public List<String> getAvailableFeatures() {
            return Arrays.asList(COLUMNS);
        }

        public Builder addFeature(String name) {
            return (Builder)((Object)this.addFeature(new Feature(name, true)));
        }

        @Override
        public AirfoilRandomAccess build() {
            if (this.features.isEmpty()) {
                for (int i = 0; i < 5; ++i) {
                    this.addNumericFeature(COLUMNS[i], this.normalize);
                }
            }
            if (this.labels.isEmpty()) {
                this.addNumericLabel("ssoundpres", this.normalize);
            }
            return new AirfoilRandomAccess(this);
        }

        MRL getMrl() {
            return this.repository.dataset(Application.Tabular.ANY, this.groupId, this.artifactId, AirfoilRandomAccess.VERSION);
        }
    }
}

