/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.examples.inference;

import ai.djl.ModelException;
import ai.djl.examples.inference.util.AbstractBenchmark;
import ai.djl.examples.inference.util.Arguments;
import ai.djl.examples.util.MemoryUtils;
import ai.djl.inference.Predictor;
import ai.djl.metric.Metrics;
import ai.djl.modality.Classifications;
import ai.djl.modality.cv.util.BufferedImageUtils;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.TranslateException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;

public final class Benchmark
extends AbstractBenchmark<Classifications> {
    public static void main(String[] args) {
        if (new Benchmark().runBenchmark(args)) {
            System.exit(0);
        }
        System.exit(-1);
    }

    @Override
    public Classifications predict(Arguments arguments, Metrics metrics, int iteration) throws IOException, ModelException, TranslateException {
        Path imageFile = arguments.getImageFile();
        BufferedImage img = BufferedImageUtils.fromFile((Path)imageFile);
        try (ZooModel<BufferedImage, Classifications> model = this.loadModel(arguments, metrics);){
            Classifications predictResult = null;
            try (Predictor predictor = model.newPredictor();){
                predictor.setMetrics(metrics);
                for (int i = 0; i < iteration; ++i) {
                    predictResult = (Classifications)predictor.predict((Object)img);
                    this.progressBar.update((long)i);
                    MemoryUtils.collectMemoryInfo(metrics);
                }
            }
            Classifications classifications = predictResult;
            return classifications;
        }
    }
}

