/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.examples.training.util;

import ai.djl.engine.Engine;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class Arguments {
    private int epoch;
    private int batchSize;
    private int maxGpus;
    private boolean isSymbolic;
    private boolean preTrained;
    private String outputDir;
    private long maxIterations;
    private String modelDir;
    private Map<String, String> criteria;

    public Arguments(CommandLine cmd) {
        this.epoch = cmd.hasOption("epoch") ? Integer.parseInt(cmd.getOptionValue("epoch")) : 2;
        this.maxGpus = Engine.getInstance().getGpuCount();
        if (cmd.hasOption("max-gpus")) {
            this.maxGpus = Math.min(Integer.parseInt(cmd.getOptionValue("max-gpus")), this.maxGpus);
        }
        this.batchSize = cmd.hasOption("batch-size") ? Integer.parseInt(cmd.getOptionValue("batch-size")) : (this.maxGpus > 0 ? 32 * this.maxGpus : 32);
        this.isSymbolic = cmd.hasOption("symbolic-model");
        this.preTrained = cmd.hasOption("pre-trained");
        this.outputDir = cmd.hasOption("output-dir") ? cmd.getOptionValue("output-dir") : "build/model";
        this.maxIterations = cmd.hasOption("max-iterations") ? Long.parseLong(cmd.getOptionValue("max-iterations")) : Long.MAX_VALUE;
        this.modelDir = cmd.hasOption("model-dir") ? cmd.getOptionValue("model-dir") : null;
        if (cmd.hasOption("criteria")) {
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            this.criteria = (Map)new Gson().fromJson(cmd.getOptionValue("criteria"), type);
        }
    }

    public static Options getOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"e").longOpt("epoch").hasArg().argName("EPOCH").desc("Numbers of epochs user would like to run").build());
        options.addOption(Option.builder((String)"b").longOpt("batch-size").hasArg().argName("BATCH-SIZE").desc("The batch size of the training data.").build());
        options.addOption(Option.builder((String)"g").longOpt("max-gpus").hasArg().argName("MAXGPUS").desc("Max number of GPUs to use for training").build());
        options.addOption(Option.builder((String)"s").longOpt("symbolic-model").argName("SYMBOLIC").desc("Use symbolic model, use imperative model if false").build());
        options.addOption(Option.builder((String)"p").longOpt("pre-trained").argName("PRE-TRAINED").desc("Use pre-trained weights").build());
        options.addOption(Option.builder((String)"o").longOpt("output-dir").hasArg().argName("OUTPUT-DIR").desc("Use output to determine directory to save your model parameters").build());
        options.addOption(Option.builder((String)"m").longOpt("max-iterations").hasArg().argName("max-iterations").desc("Limit each epoch to a fixed number of iterations").build());
        options.addOption(Option.builder((String)"d").longOpt("model-dir").hasArg().argName("MODEL-DIR").desc("pre-trained model file directory").build());
        options.addOption(Option.builder((String)"r").longOpt("criteria").hasArg().argName("CRITERIA").desc("The criteria used for the model.").build());
        return options;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getEpoch() {
        return this.epoch;
    }

    public int getMaxGpus() {
        return this.maxGpus;
    }

    public boolean isSymbolic() {
        return this.isSymbolic;
    }

    public boolean isPreTrained() {
        return this.preTrained;
    }

    public String getModelDir() {
        return this.modelDir;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public long getMaxIterations() {
        return this.maxIterations;
    }

    public Map<String, String> getCriteria() {
        return this.criteria;
    }
}

