package ai.djl.mxnet.jna;

import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.List;

public class NDArrayOpInfo extends Structure {

    public ForwardCallback forward;
    public BackwardCallback backward;
    public InferShapeCallback infer_shape;
    public ListOutputsCallback list_outputs;
    public ListArgumentsCallback list_arguments;
    public DeclareBackwardDependencyCallback declare_backward_dependency;
    public Pointer p_forward;
    public Pointer p_backward;
    public Pointer p_infer_shape;
    public Pointer p_list_outputs;
    public Pointer p_list_arguments;
    public Pointer p_declare_backward_dependency;

    public NDArrayOpInfo() {
    }

    public NDArrayOpInfo(Pointer peer) {
        super(peer);
    }

    @Override
    protected List<String> getFieldOrder() {
        return Arrays.asList("forward", "backward", "infer_shape", "list_outputs", "list_arguments", "declare_backward_dependency", "p_forward", "p_backward", "p_infer_shape", "p_list_outputs", "p_list_arguments", "p_declare_backward_dependency");
    }

    public void setForwardCallback(ForwardCallback forward) {
        this.forward = forward;
    }

    public ForwardCallback getForwardCallback() {
        return forward;
    }

    public void setBackwardCallback(BackwardCallback backward) {
        this.backward = backward;
    }

    public BackwardCallback getBackwardCallback() {
        return backward;
    }

    public void setInferShapeCallback(InferShapeCallback infer_shape) {
        this.infer_shape = infer_shape;
    }

    public InferShapeCallback getInferShapeCallback() {
        return infer_shape;
    }

    public void setListOutputsCallback(ListOutputsCallback list_outputs) {
        this.list_outputs = list_outputs;
    }

    public ListOutputsCallback getListOutputsCallback() {
        return list_outputs;
    }

    public void setListArgumentsCallback(ListArgumentsCallback list_arguments) {
        this.list_arguments = list_arguments;
    }

    public ListArgumentsCallback getListArgumentsCallback() {
        return list_arguments;
    }

    public void setDeclareBackwardDependencyCallback(DeclareBackwardDependencyCallback declare_backward_dependency) {
        this.declare_backward_dependency = declare_backward_dependency;
    }

    public DeclareBackwardDependencyCallback getDeclareBackwardDependencyCallback() {
        return declare_backward_dependency;
    }

    public void setPForward(Pointer p_forward) {
        this.p_forward = p_forward;
    }

    public Pointer getPForward() {
        return p_forward;
    }

    public void setPBackward(Pointer p_backward) {
        this.p_backward = p_backward;
    }

    public Pointer getPBackward() {
        return p_backward;
    }

    public void setPInferShape(Pointer p_infer_shape) {
        this.p_infer_shape = p_infer_shape;
    }

    public Pointer getPInferShape() {
        return p_infer_shape;
    }

    public void setPListOutputs(Pointer p_list_outputs) {
        this.p_list_outputs = p_list_outputs;
    }

    public Pointer getPListOutputs() {
        return p_list_outputs;
    }

    public void setPListArguments(Pointer p_list_arguments) {
        this.p_list_arguments = p_list_arguments;
    }

    public Pointer getPListArguments() {
        return p_list_arguments;
    }

    public void setPDeclareBackwardDependency(Pointer p_declare_backward_dependency) {
        this.p_declare_backward_dependency = p_declare_backward_dependency;
    }

    public Pointer getPDeclareBackwardDependency() {
        return p_declare_backward_dependency;
    }

    public static final class ByReference extends NDArrayOpInfo implements Structure.ByReference {}

    public static final class ByValue extends NDArrayOpInfo implements Structure.ByValue {}

    public interface ForwardCallback extends Callback {
        byte apply(int arg1, PointerByReference arg2, IntBuffer arg3, Pointer arg4);
    }

    public interface BackwardCallback extends Callback {
        byte apply(int arg1, PointerByReference arg2, IntBuffer arg3, Pointer arg4);
    }

    public interface InferShapeCallback extends Callback {
        byte apply(int arg1, IntBuffer arg2, PointerByReference arg3, Pointer arg4);
    }

    public interface ListOutputsCallback extends Callback {
        byte apply(PointerByReference arg1, Pointer arg2);
    }

    public interface ListArgumentsCallback extends Callback {
        byte apply(PointerByReference arg1, Pointer arg2);
    }

    public interface DeclareBackwardDependencyCallback extends Callback {
        byte apply(int[] arg1, int[] arg2, int[] arg3, IntBuffer arg4, PointerByReference arg5, Pointer arg6);
    }
}
