package ai.djl.mxnet.jna;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public class LibFeature extends Structure {

    private String name;
    private byte enabled;

    public LibFeature() {
    }

    public LibFeature(Pointer peer) {
        super(peer);
    }

    @Override
    protected List<String> getFieldOrder() {
        return Arrays.asList("name", "enabled");
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setEnabled(byte enabled) {
        this.enabled = enabled;
    }

    public byte getEnabled() {
        return enabled;
    }

    public static final class ByReference extends LibFeature implements Structure.ByReference {}

    public static final class ByValue extends LibFeature implements Structure.ByValue {}
}
