package ai.djl.mxnet.jna;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;

public interface MxnetLibrary extends Library {


    enum CustomOpCallbacks {
        kCustomOpDelete,
        kCustomOpForward,
        kCustomOpBackward
    }

    enum CustomOpPropCallbacks {
        kCustomOpPropDelete,
        kCustomOpPropListArguments,
        kCustomOpPropListOutputs,
        kCustomOpPropListAuxiliaryStates,
        kCustomOpPropInferShape,
        kCustomOpPropDeclareBackwardDependency,
        kCustomOpPropCreateOperator,
        kCustomOpPropInferType,
        kCustomOpPropInferStorageType,
        kCustomOpPropBackwardInferStorageType
    }

    enum CustomFunctionCallbacks {
        kCustomFunctionBackward,
        kCustomFunctionDelete
    }

    interface EngineAsyncFunc extends Callback {
        void apply(Pointer arg1, Pointer arg2, Pointer arg3);
    }

    interface EngineSyncFunc extends Callback {
        void apply(Pointer arg1, Pointer arg2);
    }

    interface EngineFuncParamDeleter extends Callback {
        void apply(Pointer arg1);
    }

    interface ExecutorMonitorCallback extends Callback {
        void apply(String arg1, Pointer arg2, Pointer arg3);
    }

    interface CachedOpMonitorCallback extends Callback {
        void apply(String arg1, String arg2, Pointer arg3);
    }

    interface MXGenericCallback extends Callback {
        int apply();
    }

    interface CustomOpFBFunc extends Callback {
        int apply(int arg1, PointerByReference arg2, IntBuffer arg3, int[] arg4, int arg5, Pointer arg6);
    }

    interface CustomOpDelFunc extends Callback {
        int apply(Pointer arg1);
    }

    interface CustomOpListFunc extends Callback {
        int apply(PointerByReference arg1, Pointer arg2);
    }

    interface CustomOpInferShapeFunc extends Callback {
        int apply(int arg1, IntBuffer arg2, PointerByReference arg3, Pointer arg4);
    }

    interface CustomOpInferStorageTypeFunc extends Callback {
        int apply(int arg1, IntBuffer arg2, Pointer arg3);
    }

    interface CustomOpBackwardInferStorageTypeFunc extends Callback {
        int apply(int arg1, IntBuffer arg2, IntBuffer arg3, Pointer arg4);
    }

    interface CustomOpInferTypeFunc extends Callback {
        int apply(int arg1, IntBuffer arg2, Pointer arg3);
    }

    interface CustomOpBwdDepFunc extends Callback {
        int apply(int[] arg1, int[] arg2, int[] arg3, IntBuffer arg4, PointerByReference arg5, Pointer arg6);
    }

    interface CustomOpCreateFunc extends Callback {
        int apply(String arg1, int arg2, PointerByReference arg3, int[] arg4, int[] arg5, MXCallbackList.ByReference arg6, Pointer arg7);
    }

    interface CustomOpPropCreator extends Callback {
        int apply(String arg1, int arg2, String[] arg3, String[] arg4, MXCallbackList.ByReference arg5);
    }

    interface CustomFunctionBwdFunc extends Callback {
        int apply(int arg1, int arg2, PointerByReference arg3, int[] arg4, int arg5, Pointer arg6);
    }

    interface CustomFunctionDelFunc extends Callback {
        int apply(Pointer arg1);
    }

    interface MXKVStoreUpdater extends Callback {
        void apply(int key, Pointer recv, Pointer local, Pointer handle);
    }

    interface MXKVStoreStrUpdater extends Callback {
        void apply(String key, Pointer recv, Pointer local, Pointer handle);
    }

    interface MXKVStoreServerController extends Callback {
        void apply(int head, String body, Pointer controller_handle);
    }

    String MXGetLastError();

    int MXLoadLib(String path);

    int MXLibInfoFeatures(PointerByReference libFeature, NativeSizeByReference size);

    int MXRandomSeed(int seed);

    int MXRandomSeedContext(int seed, int dev_type, int dev_id);

    int MXNotifyShutdown();

    int MXSetProcessProfilerConfig(int num_params, String[] keys, String[] vals, Pointer kvstoreHandle);

    int MXSetProfilerConfig(int num_params, String[] keys, String[] vals);

    int MXSetProcessProfilerState(int state, int profile_process, Pointer kvStoreHandle);

    int MXSetProfilerState(int state);

    int MXDumpProcessProfile(int finished, int profile_process, Pointer kvStoreHandle);

    int MXDumpProfile(int finished);

    int MXAggregateProfileStatsPrint(String[] out_str, int reset);

    int MXAggregateProfileStatsPrintEx(String[] out_str, int reset, int format, int sort_by, int ascending);

    int MXProcessProfilePause(int paused, int profile_process, Pointer kvStoreHandle);

    int MXProfilePause(int paused);

    int MXProfileCreateDomain(String domain, PointerByReference out);

    int MXProfileCreateTask(Pointer domain, String task_name, PointerByReference out);

    int MXProfileCreateFrame(Pointer domain, String frame_name, PointerByReference out);

    int MXProfileCreateEvent(String event_name, PointerByReference out);

    int MXProfileCreateCounter(Pointer domain, String counter_name, PointerByReference out);

    int MXProfileDestroyHandle(Pointer frame_handle);

    int MXProfileDurationStart(Pointer duration_handle);

    int MXProfileDurationStop(Pointer duration_handle);

    int MXProfileSetCounter(Pointer counter_handle, long value);

    int MXProfileAdjustCounter(Pointer counter_handle, long value);

    int MXProfileSetMarker(Pointer domain, String instant_marker_name, String scope);

    int MXSetNumOMPThreads(int thread_num);

    int MXEngineSetBulkSize(int bulk_size, IntBuffer prev_bulk_size);

    int MXGetGPUCount(IntBuffer out);

    int MXGetGPUMemoryInformation(int dev, IntBuffer free_mem, IntBuffer total_mem);

    int MXGetGPUMemoryInformation64(int dev, LongBuffer free_mem, LongBuffer total_mem);

    int MXGetVersion(IntBuffer out);

    int MXLoadTVMOp(String libpath);

    int MXLoadTVMConfig(PointerByReference config);

    int MXNDArrayCreateNone(PointerByReference out);

    int MXNDArrayCreate(int[] shape, int ndim, int dev_type, int dev_id, int delay_alloc, PointerByReference out);

    int MXNDArrayCreateEx(int[] shape, int ndim, int dev_type, int dev_id, int delay_alloc, int dtype, PointerByReference out);

    int MXNDArrayCreateEx64(long[] shape, int ndim, int dev_type, int dev_id, int delay_alloc, int dtype, PointerByReference out);

    int MXNDArrayCreateSparseEx(int storage_type, int[] shape, int ndim, int dev_type, int dev_id, int delay_alloc, int dtype, int num_aux, IntBuffer aux_type, IntBuffer aux_ndims, int[] aux_shape, PointerByReference out);

    int MXNDArrayCreateSparseEx64(int storage_type, long[] shape, int ndim, int dev_type, int dev_id, int delay_alloc, int dtype, int num_aux, IntBuffer aux_type, IntBuffer aux_ndims, long[] aux_shape, PointerByReference out);

    int MXNDArrayLoadFromRawBytes(Pointer buf, NativeSize size, PointerByReference out);

    int MXNDArraySaveRawBytes(Pointer handle, NativeSizeByReference out_size, PointerByReference out_buf);

    int MXNDArraySave(String fname, int num_args, PointerArray args, String[] keys);

    int MXNDArrayLoad(String fname, IntBuffer out_size, PointerByReference out_arr, IntBuffer out_name_size, PointerByReference out_names);

    int MXNDArrayLoadFromBuffer(Pointer ndarray_buffer, NativeSize size, IntBuffer out_size, PointerByReference out_arr, IntBuffer out_name_size, PointerByReference out_names);

    int MXNDArraySyncCopyFromCPU(Pointer handle, Pointer data, NativeSize size);

    int MXNDArraySyncCopyToCPU(Pointer handle, Pointer data, NativeSize size);

    int MXNDArraySyncCopyFromNDArray(Pointer handle_dst, Pointer handle_src, int i);

    int MXNDArraySyncCheckFormat(Pointer handle, byte full_check);

    int MXNDArrayWaitToRead(Pointer handle);

    int MXNDArrayWaitToWrite(Pointer handle);

    int MXNDArrayWaitAll();

    int MXNDArrayFree(Pointer handle);

    int MXNDArraySlice(Pointer handle, int slice_begin, int slice_end, PointerByReference out);

    int MXNDArraySlice64(Pointer handle, long slice_begin, long slice_end, PointerByReference out);

    int MXNDArrayAt(Pointer handle, int idx, PointerByReference out);

    int MXNDArrayAt64(Pointer handle, long idx, PointerByReference out);

    int MXNDArrayGetStorageType(Pointer handle, IntBuffer out_storage_type);

    int MXNDArrayReshape(Pointer handle, int ndim, IntBuffer dims, PointerByReference out);

    int MXNDArrayReshape64(Pointer handle, int ndim, LongBuffer dims, byte reverse, PointerByReference out);

    int MXNDArrayGetShape(Pointer handle, IntBuffer out_dim, PointerByReference out_pdata);

    int MXNDArrayGetShapeEx(Pointer handle, IntBuffer out_dim, PointerByReference out_pdata);

    int MXNDArrayGetShapeEx64(Pointer handle, IntBuffer out_dim, PointerByReference out_pdata);

    int MXNDArrayGetData(Pointer handle, PointerByReference out_pdata);

    int MXNDArrayToDLPack(Pointer handle, PointerByReference out_dlpack);

    int MXNDArrayFromDLPack(Pointer dlpack, PointerByReference out_handle);

    int MXNDArrayFromDLPackEx(Pointer dlpack, byte transient_handle, PointerByReference out_handle);

    int MXNDArrayCallDLPackDeleter(Pointer dlpack);

    int MXNDArrayGetDType(Pointer handle, IntBuffer out_dtype);

    int MXNDArrayGetAuxType(Pointer handle, int i, IntBuffer out_type);

    int MXNDArrayGetAuxType64(Pointer handle, long i, IntBuffer out_type);

    int MXNDArrayGetAuxNDArray(Pointer handle, int i, PointerByReference out);

    int MXNDArrayGetAuxNDArray64(Pointer handle, long i, PointerByReference out);

    int MXNDArrayGetDataNDArray(Pointer handle, PointerByReference out);

    int MXNDArrayGetContext(Pointer handle, IntBuffer out_dev_type, IntBuffer out_dev_id);

    int MXNDArrayGetGrad(Pointer handle, PointerByReference out);

    int MXNDArrayDetach(Pointer handle, PointerByReference out);

    int MXNDArraySetGradState(Pointer handle, int state);

    int MXNDArrayGetGradState(Pointer handle, IntBuffer out);

    int MXListFunctions(IntBuffer out_size, PointerByReference out_array);

    int MXGetFunction(String name, PointerByReference out);

    int MXFuncGetInfo(Pointer fun, String[] name, String[] description, IntBuffer num_args, PointerByReference arg_names, PointerByReference arg_type_infos, PointerByReference arg_descriptions, String[] return_type);

    int MXFuncDescribe(Pointer fun, IntBuffer num_use_vars, IntBuffer num_scalars, IntBuffer num_mutate_vars, IntBuffer type_mask);

    int MXFuncInvoke(Pointer fun, PointerByReference use_vars, FloatBuffer scalar_args, PointerByReference mutate_vars);

    int MXFuncInvokeEx(Pointer fun, PointerByReference use_vars, FloatBuffer scalar_args, PointerByReference mutate_vars, int num_params, PointerByReference param_keys, PointerByReference param_vals);

    int MXImperativeInvoke(Pointer creator, int num_inputs, PointerArray inputs, IntBuffer num_outputs, PointerByReference outputs, int num_params, String[] param_keys, String[] param_vals);

    int MXImperativeInvokeEx(Pointer creator, int num_inputs, PointerArray inputs, IntBuffer num_outputs, PointerByReference outputs, int num_params, String[] param_keys, String[] param_vals, PointerByReference out_stypes);

    int MXAutogradSetIsRecording(int is_recording, IntBuffer prev);

    int MXAutogradSetIsTraining(int is_training, IntBuffer prev);

    int MXAutogradIsRecording(ByteBuffer curr);

    int MXAutogradIsTraining(ByteBuffer curr);

    int MXIsNumpyShape(IntBuffer curr);

    int MXSetIsNumpyShape(int is_np_shape, IntBuffer prev);

    int MXAutogradMarkVariables(int num_var, PointerByReference var_handles, IntBuffer reqs_array, PointerByReference grad_handles);

    int MXAutogradComputeGradient(int num_output, PointerByReference output_handles);

    int MXAutogradBackward(int num_output, PointerArray output_handles, PointerByReference ograd_handles, int retain_graph);

    int MXAutogradBackwardEx(int num_output, PointerArray output_handles, PointerArray ograd_handles, int num_variables, PointerByReference var_handles, int retain_graph, int create_graph, int is_train, PointerByReference grad_handles, PointerByReference grad_stypes);

    int MXAutogradGetSymbol(Pointer handle, PointerByReference out);

    int MXCreateCachedOp(Pointer handle, PointerByReference out);

    int MXCreateCachedOpEx(Pointer handle, int num_flags, String[] keys, String[] vals, PointerByReference out);

    int MXCreateCachedOpEX(Pointer handle, int num_flags, String[] keys, String[] vals, PointerByReference out, byte thread_safe);

    int MXFreeCachedOp(Pointer handle);

    int MXInvokeCachedOp(Pointer handle, int num_inputs, Pointer inputs, IntBuffer num_outputs, PointerByReference outputs);

    int MXInvokeCachedOpEx(Pointer handle, int num_inputs, Pointer inputs, IntBuffer num_outputs, PointerByReference outputs, PointerByReference out_stypes);

    int MXCachedOpRegisterOpHook(Pointer handle, CachedOpMonitorCallback callback, byte monitor_all);

    int MXListAllOpNames(IntBuffer out_size, PointerByReference out_array);

    int MXSymbolListAtomicSymbolCreators(IntBuffer out_size, PointerByReference out_array);

    int MXSymbolGetAtomicSymbolName(Pointer creator, String[] name);

    int MXSymbolGetInputSymbols(Pointer sym, PointerByReference inputs, IntBuffer input_size);

    int MXSymbolCutSubgraph(Pointer sym, PointerByReference inputs, IntBuffer input_size);

    int MXSymbolGetAtomicSymbolInfo(Pointer creator, String[] name, String[] description, IntBuffer num_args, PointerByReference arg_names, PointerByReference arg_type_infos, PointerByReference arg_descriptions, String[] key_var_num_args, String[] return_type);

    int MXSymbolCreateAtomicSymbol(Pointer creator, int num_param, String[] keys, String[] vals, PointerByReference out);

    int MXSymbolCreateVariable(String name, PointerByReference out);

    int MXSymbolCreateGroup(int num_symbols, PointerByReference symbols, PointerByReference out);

    int MXSymbolCreateFromFile(String fname, PointerByReference out);

    int MXSymbolCreateFromJSON(String json, PointerByReference out);

    int MXSymbolRemoveAmpCast(Pointer sym_handle, PointerByReference ret_sym_handle);

    int MXSymbolSaveToFile(Pointer symbol, String fname);

    int MXSymbolSaveToJSON(Pointer symbol, String[] out_json);

    int MXSymbolFree(Pointer symbol);

    int MXSymbolCopy(Pointer symbol, PointerByReference out);

    int MXSymbolPrint(Pointer symbol, String[] out_str);

    int MXSymbolGetName(Pointer symbol, String[] out, IntBuffer success);

    int MXSymbolGetAttr(Pointer symbol, String key, String[] out, IntBuffer success);

    int MXSymbolSetAttr(Pointer symbol, String key, String value);

    int MXSymbolListAttr(Pointer symbol, IntBuffer out_size, PointerByReference out);

    int MXSymbolListAttrShallow(Pointer symbol, IntBuffer out_size, PointerByReference out);

    int MXSymbolListArguments(Pointer symbol, IntBuffer out_size, PointerByReference out_str_array);

    int MXSymbolListOutputs(Pointer symbol, IntBuffer out_size, PointerByReference out_str_array);

    int MXSymbolGetNumOutputs(Pointer symbol, IntBuffer output_count);

    int MXSymbolGetInternals(Pointer symbol, PointerByReference out);

    int MXSymbolGetChildren(Pointer symbol, PointerByReference out);

    int MXSymbolGetOutput(Pointer symbol, int index, PointerByReference out);

    int MXSymbolListAuxiliaryStates(Pointer symbol, IntBuffer out_size, PointerByReference out_str_array);

    int MXSymbolCompose(Pointer sym, String name, int num_args, String[] keys, PointerByReference args);

    int MXSymbolGrad(Pointer sym, int num_wrt, String[] wrt, PointerByReference out);

    int MXSymbolInferShape(Pointer sym, int num_args, String[] keys, int[] arg_ind_ptr, int[] arg_shape_data, IntBuffer in_shape_size, PointerByReference in_shape_ndim, PointerByReference in_shape_data, IntBuffer out_shape_size, PointerByReference out_shape_ndim, PointerByReference out_shape_data, IntBuffer aux_shape_size, PointerByReference aux_shape_ndim, PointerByReference aux_shape_data, IntBuffer complete);

    int MXSymbolInferShapeEx(Pointer sym, int num_args, String[] keys, int[] arg_ind_ptr, int[] arg_shape_data, IntBuffer in_shape_size, PointerByReference in_shape_ndim, PointerByReference in_shape_data, IntBuffer out_shape_size, PointerByReference out_shape_ndim, PointerByReference out_shape_data, IntBuffer aux_shape_size, PointerByReference aux_shape_ndim, PointerByReference aux_shape_data, IntBuffer complete);

    int MXSymbolInferShapeEx64(Pointer sym, int num_args, String[] keys, long[] arg_ind_ptr, long[] arg_shape_data, NativeSizeByReference in_shape_size, PointerByReference in_shape_ndim, PointerByReference in_shape_data, NativeSizeByReference out_shape_size, PointerByReference out_shape_ndim, PointerByReference out_shape_data, NativeSizeByReference aux_shape_size, PointerByReference aux_shape_ndim, PointerByReference aux_shape_data, IntBuffer complete);

    int MXSymbolInferShapePartial(Pointer sym, int num_args, String[] keys, int[] arg_ind_ptr, int[] arg_shape_data, IntBuffer in_shape_size, PointerByReference in_shape_ndim, PointerByReference in_shape_data, IntBuffer out_shape_size, PointerByReference out_shape_ndim, PointerByReference out_shape_data, IntBuffer aux_shape_size, PointerByReference aux_shape_ndim, PointerByReference aux_shape_data, IntBuffer complete);

    int MXSymbolInferShapePartialEx(Pointer sym, int num_args, String[] keys, int[] arg_ind_ptr, int[] arg_shape_data, IntBuffer in_shape_size, PointerByReference in_shape_ndim, PointerByReference in_shape_data, IntBuffer out_shape_size, PointerByReference out_shape_ndim, PointerByReference out_shape_data, IntBuffer aux_shape_size, PointerByReference aux_shape_ndim, PointerByReference aux_shape_data, IntBuffer complete);

    int MXSymbolInferShapePartialEx64(Pointer sym, int num_args, String[] keys, long[] arg_ind_ptr, long[] arg_shape_data, NativeSizeByReference in_shape_size, PointerByReference in_shape_ndim, PointerByReference in_shape_data, NativeSizeByReference out_shape_size, PointerByReference out_shape_ndim, PointerByReference out_shape_data, NativeSizeByReference aux_shape_size, PointerByReference aux_shape_ndim, PointerByReference aux_shape_data, IntBuffer complete);

    int MXSymbolInferType(Pointer sym, int num_args, String[] keys, int[] arg_type_data, IntBuffer in_type_size, PointerByReference in_type_data, IntBuffer out_type_size, PointerByReference out_type_data, IntBuffer aux_type_size, PointerByReference aux_type_data, IntBuffer complete);

    int MXSymbolInferTypePartial(Pointer sym, int num_args, String[] keys, int[] arg_type_data, IntBuffer in_type_size, PointerByReference in_type_data, IntBuffer out_type_size, PointerByReference out_type_data, IntBuffer aux_type_size, PointerByReference aux_type_data, IntBuffer complete);

    int MXQuantizeSymbol(Pointer sym_handle, PointerByReference ret_sym_handle, int[] dev_type, int num_excluded_sym_names, String[] excluded_sym_names, int num_excluded_op_names, String[] excluded_op_names, int num_offline, String[] offline_params, String quantized_dtype, byte calib_quantize, String quantize_mode, String quantize_granularity, IntBuffer out_num_calib_names, PointerByReference out_calib_names);

    int MXReducePrecisionSymbol(Pointer sym_handle, PointerByReference ret_sym_handle, int num_args, int[] arg_type_data, int num_ind_ptr, int[] ind_ptr, int[] target_dtype, int cast_optional_params, int num_target_dtype_op_names, int num_fp32_op_names, int num_widest_dtype_op_names, int num_conditional_fp32_op_names, int num_excluded_symbols, int num_model_params, String[] target_dtype_op_names, String[] fp32_op_names, String[] widest_dtype_op_names, String[] conditional_fp32_op_names, String[] excluded_symbols, String[] conditional_param_names, String[] conditional_param_vals, String[] model_param_names, String[] arg_names);

    int MXSetCalibTableToQuantizedSymbol(Pointer qsym_handle, int num_layers, String[] layer_names, FloatBuffer low_quantiles, FloatBuffer high_quantiles, PointerByReference ret_sym_handle);

    int MXGenBackendSubgraph(Pointer sym_handle, String backend, PointerByReference ret_sym_handle);

    int MXGenAtomicSymbolFromSymbol(Pointer sym_handle, PointerByReference ret_sym_handle);

    int MXOptimizeForBackend(Pointer sym_handle, String backend_name, int dev_type, PointerByReference ret_sym_handle, int len, PointerByReference in_args_handle, int num_options, String[] keys, String[] vals);

    int MXExecutorFree(Pointer handle);

    int MXExecutorPrint(Pointer handle, String[] out_str);

    int MXExecutorForward(Pointer handle, int is_train);

    int MXExecutorBackward(Pointer handle, int len, PointerByReference head_grads);

    int MXExecutorBackwardEx(Pointer handle, int len, PointerByReference head_grads, int is_train);

    int MXExecutorOutputs(Pointer handle, IntBuffer out_size, PointerByReference out);

    int MXExecutorBind(Pointer symbol_handle, int dev_type, int dev_id, int len, PointerByReference in_args, PointerByReference arg_grad_store, IntBuffer grad_req_type, int aux_states_len, PointerByReference aux_states, PointerByReference out);

    int MXExecutorBindX(Pointer symbol_handle, int dev_type, int dev_id, int num_map_keys, String[] map_keys, int[] map_dev_types, int[] map_dev_ids, int len, PointerByReference in_args, PointerByReference arg_grad_store, IntBuffer grad_req_type, int aux_states_len, PointerByReference aux_states, PointerByReference out);

    int MXExecutorBindEX(Pointer symbol_handle, int dev_type, int dev_id, int num_map_keys, String[] map_keys, int[] map_dev_types, int[] map_dev_ids, int len, PointerByReference in_args, PointerByReference arg_grad_store, IntBuffer grad_req_type, int aux_states_len, PointerByReference aux_states, Pointer shared_exec, PointerByReference out);

    int MXExecutorSimpleBind(Pointer symbol_handle, int dev_type, int dev_id, int num_g2c_keys, String[] g2c_keys, int[] g2c_dev_types, int[] g2c_dev_ids, int provided_grad_req_list_len, String[] provided_grad_req_names, String[] provided_grad_req_types, int num_provided_arg_shapes, String[] provided_arg_shape_names, int[] provided_arg_shape_data, int[] provided_arg_shape_idx, int num_provided_arg_dtypes, String[] provided_arg_dtype_names, int[] provided_arg_dtypes, int num_provided_arg_stypes, String[] provided_arg_stype_names, int[] provided_arg_stypes, int num_shared_arg_names, String[] shared_arg_name_list, IntBuffer shared_buffer_len, String[] shared_buffer_name_list, PointerByReference shared_buffer_handle_list, PointerByReference updated_shared_buffer_name_list, PointerByReference updated_shared_buffer_handle_list, IntBuffer num_in_args, PointerByReference in_args, PointerByReference arg_grads, IntBuffer num_aux_states, PointerByReference aux_states, Pointer shared_exec_handle, PointerByReference out);

    int MXExecutorSimpleBindEx(Pointer symbol_handle, int dev_type, int dev_id, int num_g2c_keys, String[] g2c_keys, int[] g2c_dev_types, int[] g2c_dev_ids, int provided_grad_req_list_len, String[] provided_grad_req_names, String[] provided_grad_req_types, int num_provided_arg_shapes, String[] provided_arg_shape_names, int[] provided_arg_shape_data, int[] provided_arg_shape_idx, int num_provided_arg_dtypes, String[] provided_arg_dtype_names, int[] provided_arg_dtypes, int num_provided_arg_stypes, String[] provided_arg_stype_names, int[] provided_arg_stypes, int num_shared_arg_names, String[] shared_arg_name_list, IntBuffer shared_buffer_len, String[] shared_buffer_name_list, PointerByReference shared_buffer_handle_list, PointerByReference updated_shared_buffer_name_list, PointerByReference updated_shared_buffer_handle_list, IntBuffer num_in_args, PointerByReference in_args, PointerByReference arg_grads, IntBuffer num_aux_states, PointerByReference aux_states, Pointer shared_exec_handle, PointerByReference out);

    int MXExecutorSimpleBindEx64(Pointer symbol_handle, int dev_type, int dev_id, int num_g2c_keys, String[] g2c_keys, int[] g2c_dev_types, int[] g2c_dev_ids, int provided_grad_req_list_len, String[] provided_grad_req_names, String[] provided_grad_req_types, int num_provided_arg_shapes, String[] provided_arg_shape_names, long[] provided_arg_shape_data, int[] provided_arg_shape_idx, int num_provided_arg_dtypes, String[] provided_arg_dtype_names, int[] provided_arg_dtypes, int num_provided_arg_stypes, String[] provided_arg_stype_names, int[] provided_arg_stypes, int num_shared_arg_names, String[] shared_arg_name_list, IntBuffer shared_buffer_len, String[] shared_buffer_name_list, PointerByReference shared_buffer_handle_list, PointerByReference updated_shared_buffer_name_list, PointerByReference updated_shared_buffer_handle_list, IntBuffer num_in_args, PointerByReference in_args, PointerByReference arg_grads, IntBuffer num_aux_states, PointerByReference aux_states, Pointer shared_exec_handle, PointerByReference out);

    int MXExecutorReshape(int partial_shaping, int allow_up_sizing, int dev_type, int dev_id, int num_map_keys, String[] map_keys, int[] map_dev_types, int[] map_dev_ids, int num_provided_arg_shapes, String[] provided_arg_shape_names, int[] provided_arg_shape_data, int[] provided_arg_shape_idx, IntBuffer num_in_args, PointerByReference in_args, PointerByReference arg_grads, IntBuffer num_aux_states, PointerByReference aux_states, Pointer shared_exec, PointerByReference out);

    int MXExecutorReshapeEx(int partial_shaping, int allow_up_sizing, int dev_type, int dev_id, int num_map_keys, String[] map_keys, int[] map_dev_types, int[] map_dev_ids, int num_provided_arg_shapes, String[] provided_arg_shape_names, int[] provided_arg_shape_data, int[] provided_arg_shape_idx, IntBuffer num_in_args, PointerByReference in_args, PointerByReference arg_grads, IntBuffer num_aux_states, PointerByReference aux_states, Pointer shared_exec, PointerByReference out);

    int MXExecutorGetOptimizedSymbol(Pointer handle, PointerByReference out);

    int MXExecutorSetMonitorCallback(Pointer handle, ExecutorMonitorCallback callback, Pointer callback_handle);

    int MXExecutorSetMonitorCallbackEX(Pointer handle, ExecutorMonitorCallback callback, Pointer callback_handle, byte monitor_all);

    int MXListDataIters(IntBuffer out_size, PointerByReference out_array);

    int MXDataIterCreateIter(Pointer handle, int num_param, String[] keys, String[] vals, PointerByReference out);

    int MXDataIterGetIterInfo(Pointer creator, String[] name, String[] description, IntBuffer num_args, PointerByReference arg_names, PointerByReference arg_type_infos, PointerByReference arg_descriptions);

    int MXDataIterFree(Pointer handle);

    int MXDataIterNext(Pointer handle, IntBuffer out);

    int MXDataIterBeforeFirst(Pointer handle);

    int MXDataIterGetData(Pointer handle, PointerByReference out);

    int MXDataIterGetIndex(Pointer handle, PointerByReference out_index, LongBuffer out_size);

    int MXDataIterGetPadNum(Pointer handle, IntBuffer pad);

    int MXDataIterGetLabel(Pointer handle, PointerByReference out);

    int MXInitPSEnv(int num_vars, String[] keys, String[] vals);

    int MXKVStoreCreate(String type, PointerByReference out);

    int MXKVStoreSetGradientCompression(Pointer handle, int num_params, String[] keys, String[] vals);

    int MXKVStoreFree(Pointer handle);

    int MXKVStoreInit(Pointer handle, int num, int[] keys, PointerArray vals);

    int MXKVStoreInitEx(Pointer handle, int num, String[] keys, PointerArray vals);

    int MXKVStorePush(Pointer handle, int num, int[] keys, PointerArray vals, int priority);

    int MXKVStorePushEx(Pointer handle, int num, String[] keys, PointerArray vals, int priority);

    int MXKVStorePullWithSparse(Pointer handle, int num, int[] keys, PointerByReference vals, int priority, byte ignore_sparse);

    int MXKVStorePullWithSparseEx(Pointer handle, int num, String[] keys, PointerByReference vals, int priority, byte ignore_sparse);

    int MXKVStorePull(Pointer handle, int num, int[] keys, PointerArray vals, int priority);

    int MXKVStorePullEx(Pointer handle, int num, String[] keys, PointerArray vals, int priority);

    int MXKVStorePullRowSparse(Pointer handle, int num, int[] keys, PointerByReference vals, PointerByReference row_ids, int priority);

    int MXKVStorePullRowSparseEx(Pointer handle, int num, String[] keys, PointerByReference vals, PointerByReference row_ids, int priority);

    int MXKVStoreBroadcast(Pointer handle, int vnum, int[] vkeys, int onum, int[] okeys, PointerByReference vals, PointerByReference outs, int priority);

    int MXKVStoreBroadcastEx(Pointer handle, int vnum, String[] vkeys, int onum, String[] okeys, PointerByReference vals, PointerByReference outs, int priority);

    int MXKVStorePushPull(Pointer handle, int vnum, int[] vkeys, int onum, int[] okeys, PointerByReference vals, PointerByReference outs, int priority);

    int MXKVStorePushPullEx(Pointer handle, int vnum, String[] vkeys, int onum, String[] okeys, PointerByReference vals, PointerByReference outs, int priority);

    int MXKVStoreSetUpdater(Pointer handle, MXKVStoreUpdater updater, Pointer updater_handle);

    int MXKVStoreSetUpdaterEx(Pointer handle, MXKVStoreUpdater updater, MXKVStoreStrUpdater str_updater, Pointer updater_handle);

    int MXKVStoreGetType(Pointer handle, String[] type);

    int MXKVStoreGetRank(Pointer handle, IntBuffer ret);

    int MXKVStoreGetGroupSize(Pointer handle, IntBuffer ret);

    int MXKVStoreIsWorkerNode(IntBuffer ret);

    int MXKVStoreIsServerNode(IntBuffer ret);

    int MXKVStoreIsSchedulerNode(IntBuffer ret);

    int MXKVStoreBarrier(Pointer handle);

    int MXKVStoreSetBarrierBeforeExit(Pointer handle, int barrier_before_exit);

    int MXKVStoreRunServer(Pointer handle, MXKVStoreServerController controller, Pointer controller_handle);

    int MXKVStoreSendCommmandToServers(Pointer handle, int cmd_id, String cmd_body);

    int MXKVStoreGetNumDeadNode(Pointer handle, int node_id, IntBuffer number, int timeout_sec);

    int MXRecordIOWriterCreate(String uri, PointerByReference out);

    int MXRecordIOWriterFree(Pointer handle);

    int MXRecordIOWriterWriteRecord(Pointer handle, String buf, NativeSize size);

    int MXRecordIOWriterTell(Pointer handle, NativeSizeByReference pos);

    int MXRecordIOReaderCreate(String uri, PointerByReference out);

    int MXRecordIOReaderFree(Pointer handle);

    int MXRecordIOReaderReadRecord(Pointer handle, String buf, NativeSizeByReference size);

    int MXRecordIOReaderSeek(Pointer handle, NativeSize pos);

    int MXRecordIOReaderTell(Pointer handle, NativeSizeByReference pos);

    int MXRtcCreate(ByteBuffer name, int num_input, int num_output, PointerByReference input_names, PointerByReference output_names, PointerByReference inputs, PointerByReference outputs, ByteBuffer kernel, PointerByReference out);

    int MXRtcPush(Pointer handle, int num_input, int num_output, PointerByReference inputs, PointerByReference outputs, int gridDimX, int gridDimY, int gridDimZ, int blockDimX, int blockDimY, int blockDimZ);

    int MXRtcFree(Pointer handle);

    int MXCustomOpRegister(String op_type, CustomOpPropCreator creator);

    int MXCustomFunctionRecord(int num_inputs, PointerByReference inputs, int num_outputs, PointerByReference outputs, MXCallbackList.ByReference callbacks);

    int MXRtcCudaModuleCreate(String source, int num_options, String[] options, int num_exports, String[] exports, PointerByReference out);

    int MXRtcCudaModuleFree(Pointer handle);

    int MXRtcCudaKernelCreate(Pointer handle, String name, int num_args, IntBuffer is_ndarray, IntBuffer is_const, IntBuffer arg_types, PointerByReference out);

    int MXRtcCudaKernelFree(Pointer handle);

    int MXRtcCudaKernelCall(Pointer handle, int dev_id, PointerByReference args, int grid_dim_x, int grid_dim_y, int grid_dim_z, int block_dim_x, int block_dim_y, int block_dim_z, int shared_mem);

    int MXNDArrayGetSharedMemHandle(Pointer handle, IntBuffer shared_pid, IntBuffer shared_id);

    int MXNDArrayCreateFromSharedMem(int shared_pid, int shared_id, int[] shape, int ndim, int dtype, PointerByReference out);

    int MXStorageEmptyCache(int dev_type, int dev_id);

    int MXNDArrayCreateFromSharedMemEx(int shared_pid, int shared_id, int[] shape, int ndim, int dtype, PointerByReference out);

    int MXEnginePushAsync(EngineAsyncFunc async_func, Pointer func_param, EngineFuncParamDeleter deleter, Pointer ctx_handle, Pointer const_vars_handle, int num_const_vars, Pointer mutable_vars_handle, int num_mutable_vars, Pointer prop_handle, int priority, String opr_name, byte wait);

    int MXEnginePushSync(EngineSyncFunc sync_func, Pointer func_param, EngineFuncParamDeleter deleter, Pointer ctx_handle, Pointer const_vars_handle, int num_const_vars, Pointer mutable_vars_handle, int num_mutable_vars, Pointer prop_handle, int priority, String opr_name);

    int MXShallowCopyNDArray(Pointer src, PointerByReference out);

    int MXShallowCopySymbol(Pointer src, PointerByReference out);

    int MXEnginePushAsyncND(EngineAsyncFunc async_func, Pointer func_param, EngineFuncParamDeleter deleter, Pointer ctx_handle, PointerByReference const_nds_handle, int num_const_nds, PointerByReference mutable_nds_handle, int num_mutable_nds, Pointer prop_handle, int priority, String opr_name, byte wait);

    int MXEnginePushSyncND(EngineSyncFunc sync_func, Pointer func_param, EngineFuncParamDeleter deleter, Pointer ctx_handle, PointerByReference const_nds_handle, int num_const_nds, PointerByReference mutable_nds_handle, int num_mutable_nds, Pointer prop_handle, int priority, String opr_name);

    void NNAPISetLastError(String msg);

    String NNGetLastError();

    int NNListAllOpNames(IntBuffer out_size, PointerByReference out_array);

    int NNGetOpHandle(String op_name, PointerByReference op_out);

    int NNListUniqueOps(IntBuffer out_size, PointerByReference out_array);

    int NNGetOpInfo(Pointer op, String[] real_name, String[] description, IntBuffer num_doc_args, PointerByReference arg_names, PointerByReference arg_type_infos, PointerByReference arg_descriptions, String[] return_type);

    int NNSymbolCreateAtomicSymbol(Pointer op, int num_param, String[] keys, String[] vals, PointerByReference out);

    int NNSymbolCreateVariable(String name, PointerByReference out);

    int NNSymbolCreateGroup(int num_symbols, PointerByReference symbols, PointerByReference out);

    int NNAddControlDeps(Pointer handle, Pointer src_dep);

    int NNSymbolFree(Pointer symbol);

    int NNSymbolCopy(Pointer symbol, PointerByReference out);

    int NNSymbolPrint(Pointer symbol, String[] out_str);

    int NNSymbolGetAttr(Pointer symbol, String key, String[] out, IntBuffer success);

    int NNSymbolSetAttrs(Pointer symbol, int num_param, String[] keys, String[] values);

    int NNSymbolListAttrs(Pointer symbol, int recursive_option, IntBuffer out_size, PointerByReference out);

    int NNSymbolListInputVariables(Pointer symbol, int option, IntBuffer out_size, PointerByReference out_sym_array);

    int NNSymbolListInputNames(Pointer symbol, int option, IntBuffer out_size, PointerByReference out_str_array);

    int NNSymbolListOutputNames(Pointer symbol, IntBuffer out_size, PointerByReference out_str_array);

    int NNSymbolGetNumOutputs(Pointer symbol, IntBuffer output_count);

    int NNSymbolGetInternals(Pointer symbol, PointerByReference out);

    int NNSymbolGetChildren(Pointer symbol, PointerByReference out);

    int NNSymbolGetOutput(Pointer symbol, int index, PointerByReference out);

    int NNSymbolCompose(Pointer sym, String name, int num_args, String[] keys, PointerByReference args);

    int NNGraphCreate(Pointer symbol, PointerByReference graph);

    int NNGraphFree(Pointer handle);

    int NNGraphGetSymbol(Pointer graph, PointerByReference symbol);

    int NNGraphSetJSONAttr(Pointer handle, String key, String json_value);

    int NNGraphGetJSONAttr(Pointer handle, String key, String[] json_out, IntBuffer success);

    int NNGraphSetNodeEntryListAttr_(Pointer handle, String key, Pointer list);

    int NNGraphApplyPasses(Pointer src, int num_pass, String[] pass_names, PointerByReference dst);
}
