/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.zoo.nlp.qa;

import ai.djl.Model;
import ai.djl.modality.nlp.DefaultVocabulary;
import ai.djl.modality.nlp.Vocabulary;
import ai.djl.modality.nlp.bert.BertToken;
import ai.djl.modality.nlp.bert.BertTokenizer;
import ai.djl.modality.nlp.qa.QAInput;
import ai.djl.modality.nlp.translator.QATranslator;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.JsonUtils;
import ai.djl.util.Utils;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MxBertQATranslator
extends QATranslator {
    private List<String> tokens;
    private Vocabulary vocabulary;
    private BertTokenizer tokenizer;
    private int seqLength;

    MxBertQATranslator(Builder builder) {
        super((QATranslator.BaseBuilder)builder);
        this.seqLength = builder.seqLength;
    }

    public void prepare(TranslatorContext ctx) throws IOException {
        Model model = ctx.getModel();
        this.vocabulary = DefaultVocabulary.builder().addFromCustomizedFile(model.getArtifact("vocab.json"), VocabParser::parseToken).optUnknownToken("[UNK]").build();
        this.tokenizer = new BertTokenizer();
    }

    public Batchifier getBatchifier() {
        return null;
    }

    public NDList processInput(TranslatorContext ctx, QAInput input) {
        BertToken token = this.tokenizer.encode(input.getQuestion().toLowerCase(), input.getParagraph().toLowerCase(), this.seqLength);
        this.tokens = token.getTokens();
        List indices = token.getTokens().stream().map(arg_0 -> ((Vocabulary)this.vocabulary).getIndex(arg_0)).collect(Collectors.toList());
        float[] indexesFloat = Utils.toFloatArray(indices);
        float[] types = Utils.toFloatArray((List)token.getTokenTypes());
        int validLength = token.getValidLength();
        NDManager manager = ctx.getNDManager();
        NDArray data0 = manager.create(indexesFloat);
        data0.setName("data0");
        NDArray data1 = manager.create(types);
        data1.setName("data1");
        NDArray data2 = manager.create(new float[]{validLength});
        data2.setName("data2");
        return new NDList(new NDArray[]{data0, data1, data2});
    }

    public String processOutput(TranslatorContext ctx, NDList list) {
        NDArray array = list.singletonOrThrow();
        NDList output = array.split(2L, 2);
        NDArray startLogits = ((NDArray)output.get(0)).reshape(new Shape(new long[]{1L, -1L}));
        NDArray endLogits = ((NDArray)output.get(1)).reshape(new Shape(new long[]{1L, -1L}));
        int startIdx = (int)startLogits.argMax(1).getLong(new long[0]);
        int endIdx = (int)endLogits.argMax(1).getLong(new long[0]);
        return this.tokenizer.buildSentence(this.tokens.subList(startIdx, endIdx + 1));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Map<String, ?> arguments) {
        Builder builder = new Builder();
        builder.configure(arguments);
        builder.setSeqLength(ArgumentsUtil.intValue(arguments, (String)"seqLength", (int)384));
        return builder;
    }

    private static final class VocabParser {
        @SerializedName(value="idx_to_token")
        List<String> idx2token;

        private VocabParser() {
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public static List<String> parseToken(URL url) {
            try (BufferedInputStream is = new BufferedInputStream(url.openStream());){
                List<String> list;
                try (InputStreamReader reader = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);){
                    list = ((VocabParser)JsonUtils.GSON.fromJson((Reader)reader, VocabParser.class)).idx2token;
                }
                return list;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Invalid url: " + url, e);
            }
        }
    }

    public static class Builder
    extends QATranslator.BaseBuilder<Builder> {
        private int seqLength;

        public Builder setSeqLength(int seqLength) {
            this.seqLength = seqLength;
            return this.self();
        }

        protected Builder self() {
            return this;
        }

        protected MxBertQATranslator build() {
            if (this.seqLength == 0) {
                throw new IllegalArgumentException("You must specify a seqLength with value > 0");
            }
            return new MxBertQATranslator(this);
        }
    }
}

