/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.zoo.cv.objectdetection;

import ai.djl.Application;
import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.modality.cv.DetectedObjects;
import ai.djl.modality.cv.SingleShotDetectionTranslator;
import ai.djl.modality.cv.transform.Resize;
import ai.djl.modality.cv.transform.ToTensor;
import ai.djl.repository.MRL;
import ai.djl.repository.Repository;
import ai.djl.repository.zoo.BaseModelLoader;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.Pipeline;
import ai.djl.translate.Transform;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Progress;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SingleShotDetectionModelLoader
extends BaseModelLoader<BufferedImage, DetectedObjects> {
    private static final Application APPLICATION = Application.CV.OBJECT_DETECTION;
    private static final String GROUP_ID = "ai.djl.mxnet";
    private static final String ARTIFACT_ID = "ssd";
    private static final String VERSION = "0.0.1";

    public SingleShotDetectionModelLoader(Repository repository) {
        super(repository, MRL.model((Application)APPLICATION, (String)GROUP_ID, (String)ARTIFACT_ID), VERSION);
        ConcurrentHashMap<Class<DetectedObjects>, FactoryImpl> map = new ConcurrentHashMap<Class<DetectedObjects>, FactoryImpl>();
        map.put(DetectedObjects.class, new FactoryImpl());
        this.factories.put(BufferedImage.class, map);
    }

    public Application getApplication() {
        return APPLICATION;
    }

    public ZooModel<BufferedImage, DetectedObjects> loadModel(Map<String, String> filters, Device device, Progress progress) throws IOException, ModelNotFoundException, MalformedModelException {
        Criteria criteria = Criteria.builder().setTypes(BufferedImage.class, DetectedObjects.class).optFilters(filters).optDevice(device).optProgress(progress).build();
        return this.loadModel(criteria);
    }

    private static final class FactoryImpl
    implements TranslatorFactory<BufferedImage, DetectedObjects> {
        private FactoryImpl() {
        }

        public Translator<BufferedImage, DetectedObjects> newInstance(Map<String, Object> arguments) {
            int width = ((Double)arguments.getOrDefault("width", 512.0)).intValue();
            int height = ((Double)arguments.getOrDefault("height", 512.0)).intValue();
            double threshold = (Double)arguments.getOrDefault("threshold", 0.2);
            Pipeline pipeline = new Pipeline();
            pipeline.add((Transform)new Resize(width, height)).add((Transform)new ToTensor());
            return ((SingleShotDetectionTranslator.Builder)SingleShotDetectionTranslator.builder().setPipeline(pipeline)).setSynsetArtifactName("classes.txt").optThreshold((float)threshold).optRescaleSize((double)width, (double)height).build();
        }
    }
}

