/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.mxnet.zoo.nlp.qa;

import ai.djl.modality.nlp.Vocabulary;
import ai.djl.util.JsonUtils;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public class MxBertVocabulary
implements Vocabulary {
    @SerializedName(value="token_to_idx")
    private Map<String, Long> token2idx;
    @SerializedName(value="idx_to_token")
    private List<String> idx2token;

    public static MxBertVocabulary parse(Path path) {
        try {
            return MxBertVocabulary.parse(Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static MxBertVocabulary parse(String url) {
        try {
            return MxBertVocabulary.parse(new URL(url).openStream());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MxBertVocabulary parse(InputStream is) {
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            MxBertVocabulary mxBertVocabulary = (MxBertVocabulary)JsonUtils.GSON.fromJson((Reader)reader, MxBertVocabulary.class);
            return mxBertVocabulary;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public long getIndex(String token) {
        return this.token2idx.containsKey(token) ? this.token2idx.get(token).longValue() : this.token2idx.get("[UNK]").longValue();
    }

    public boolean contains(String token) {
        return this.token2idx.containsKey(token);
    }

    public long size() {
        return this.idx2token.size();
    }

    public String getToken(long index) {
        return this.idx2token.get((int)index);
    }
}

