/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.zoo.cv.imageclassification;

import ai.djl.modality.Classifications;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.util.Arrays;
import java.util.List;

public class PpWordRotateTranslator
implements Translator<Image, Classifications> {
    List<String> classes = Arrays.asList("No Rotate", "Rotate");

    public Classifications processOutput(TranslatorContext ctx, NDList list) {
        NDArray prob = list.singletonOrThrow();
        return new Classifications(this.classes, prob);
    }

    public NDList processInput(TranslatorContext ctx, Image input) {
        NDArray img = input.toNDArray(ctx.getNDManager());
        int[] hw = this.resize32(input.getHeight(), input.getWidth());
        img = NDImageUtils.resize((NDArray)img, (int)hw[1], (int)hw[0]);
        img = NDImageUtils.toTensor((NDArray)img).sub((Number)Float.valueOf(0.5f)).div((Number)Float.valueOf(0.5f));
        img = img.expandDims(0);
        return new NDList(new NDArray[]{img});
    }

    public Batchifier getBatchifier() {
        return null;
    }

    private int[] resize32(double h, double w) {
        double min = Math.min(h, w);
        if (min < 32.0) {
            h = 32.0 / min * h;
            w = 32.0 / min * w;
        }
        int h32 = (int)h / 32;
        int w32 = (int)w / 32;
        return new int[]{h32 * 32, w32 * 32};
    }
}

