/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.zoo.nlp.textgeneration;

import ai.djl.modality.nlp.generate.CausalLMOutput;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.NoBatchifyTranslator;
import ai.djl.translate.TranslatorContext;
import java.util.Collection;
import java.util.stream.Collectors;

public class PtGptTranslator
implements NoBatchifyTranslator<NDList, CausalLMOutput> {
    private long kvDim;
    private int numAttentionHeads;
    private int numLayers;
    private String tupleName;

    public PtGptTranslator(long kvDim, int numAttentionHeads, int numLayers) {
        this.kvDim = kvDim;
        this.numAttentionHeads = numAttentionHeads;
        this.numLayers = numLayers;
        this.tupleName = "past_key_values(" + numLayers + ',' + 2 + ')';
    }

    public NDList processInput(TranslatorContext ctx, NDList input) throws Exception {
        NDManager manager = ctx.getNDManager();
        if (input.size() == 3) {
            ctx.setAttachment("initialCall", (Object)Boolean.TRUE);
            long batchSize = ((NDArray)input.get(0)).getShape().get(0);
            NDArray attentionMask = (NDArray)input.get(2);
            attentionMask = manager.zeros(new Shape(new long[]{batchSize, 1L}), DataType.INT64).concat(attentionMask, -1);
            input.set(2, (Object)attentionMask);
            this.addInitialDummyPastKeyValues(input, (NDArray)input.get(0), manager);
        }
        return input;
    }

    public CausalLMOutput processOutput(TranslatorContext ctx, NDList output) throws Exception {
        NDArray logitsOutput = (NDArray)output.get(0);
        NDManager manager = output.getManager();
        NDList pastKeyValuesOutput = output.subNDList(1, this.numLayers * 2 + 1);
        NDArray hiddenStatesOutput = output.size() > this.numLayers * 2 + 1 ? (NDArray)output.get(this.numLayers * 2 + 1) : manager.zeros(new Shape(new long[]{1L}));
        if (ctx.getAttachment("initialCall") != null) {
            NDIndex index2 = new NDIndex(":, :, 1:, ...", new Object[0]);
            pastKeyValuesOutput = new NDList((Collection)pastKeyValuesOutput.stream().map(object -> object.get(index2)).collect(Collectors.toList()));
        }
        for (NDArray array : pastKeyValuesOutput) {
            array.setName(this.tupleName);
        }
        return new CausalLMOutput(logitsOutput, hiddenStatesOutput, pastKeyValuesOutput);
    }

    private void addInitialDummyPastKeyValues(NDList list, NDArray inputIds, NDManager manager) {
        long numBatch = inputIds.getShape().get(0);
        for (int i = 0; i < this.numLayers * 2; ++i) {
            NDArray array = manager.zeros(new Shape(new long[]{numBatch, this.numAttentionHeads, 1L, this.kvDim}));
            array.setName(this.tupleName);
            list.add((Object)array);
        }
    }
}

