/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.serving;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public final class Arguments {
    private String configFile;
    private String modelStore;
    private String[] models;
    private boolean help;

    public Arguments(CommandLine cmd) {
        this.configFile = cmd.getOptionValue("config-file");
        this.modelStore = cmd.getOptionValue("model-store");
        this.models = cmd.getOptionValues("models");
        this.help = cmd.hasOption("help");
    }

    public static Options getOptions() {
        Options options = new Options();
        options.addOption(Option.builder((String)"h").longOpt("help").hasArg(false).desc("Print this help.").build());
        options.addOption(Option.builder((String)"f").longOpt("config-file").hasArg().argName("CONFIG-FILE").desc("Path to the configuration properties file.").build());
        options.addOption(Option.builder((String)"m").longOpt("models").hasArgs().argName("MODELS").desc("Models to be loaded at startup.").build());
        options.addOption(Option.builder((String)"s").longOpt("model-store").hasArg().argName("MODELS-STORE").desc("Model store location where models can be loaded.").build());
        return options;
    }

    public Path getConfigFile() {
        if (this.configFile == null) {
            this.configFile = System.getProperty("ai.djl.conf", null);
        }
        if (this.configFile != null) {
            Path file = Paths.get(this.configFile, new String[0]);
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                throw new IllegalArgumentException("Configuration file not found: " + this.configFile);
            }
            return file;
        }
        Path file = Paths.get("config.properties", new String[0]);
        if (Files.isRegularFile(file, new LinkOption[0])) {
            return file;
        }
        return null;
    }

    public String getModelStore() {
        return this.modelStore;
    }

    public String[] getModels() {
        return this.models;
    }

    public boolean hasHelp() {
        return this.help;
    }
}

