/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.serving;

import ai.djl.repository.FilenameUtils;
import ai.djl.serving.Arguments;
import ai.djl.serving.ServerInitializer;
import ai.djl.serving.util.ConfigManager;
import ai.djl.serving.util.Connector;
import ai.djl.serving.util.ServerGroups;
import ai.djl.serving.wlm.ModelInfo;
import ai.djl.serving.wlm.ModelManager;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelServer {
    private static final Logger logger = LoggerFactory.getLogger(ModelServer.class);
    private ServerGroups serverGroups;
    private List<ChannelFuture> futures = new ArrayList<ChannelFuture>(2);
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private ConfigManager configManager;

    public ModelServer(ConfigManager configManager) {
        this.configManager = configManager;
        this.serverGroups = new ServerGroups(configManager);
    }

    public static void main(String[] args) {
        Options options = Arguments.getOptions();
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine cmd = parser.parse(options, args, null, false);
            Arguments arguments = new Arguments(cmd);
            if (arguments.hasHelp()) {
                ModelServer.printHelp("model-server [OPTIONS]", options);
                return;
            }
            ConfigManager.init(arguments);
            ConfigManager configManager = ConfigManager.getInstance();
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
            new ModelServer(configManager).startAndWait();
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid configuration: " + e.getMessage());
            System.exit(1);
        }
        catch (ParseException e) {
            ModelServer.printHelp(e.getMessage(), options);
            System.exit(1);
        }
        catch (Throwable t) {
            logger.error("Unexpected error", t);
            System.exit(1);
        }
    }

    public void startAndWait() throws InterruptedException, IOException, GeneralSecurityException {
        try {
            List<ChannelFuture> channelFutures = this.start();
            logger.info("Model server started.");
            channelFutures.get(0).sync();
        }
        finally {
            this.serverGroups.shutdown(true);
            logger.info("Model server stopped.");
        }
    }

    public List<ChannelFuture> start() throws InterruptedException, IOException, GeneralSecurityException {
        this.stopped.set(false);
        logger.info(this.configManager.dumpConfigurations());
        this.initModelStore();
        Connector inferenceConnector = this.configManager.getConnector(Connector.ConnectorType.INFERENCE);
        Connector managementConnector = this.configManager.getConnector(Connector.ConnectorType.MANAGEMENT);
        inferenceConnector.clean();
        managementConnector.clean();
        EventLoopGroup serverGroup = this.serverGroups.getServerGroup();
        EventLoopGroup workerGroup = this.serverGroups.getChildGroup();
        this.futures.clear();
        if (inferenceConnector.equals(managementConnector)) {
            Connector both = this.configManager.getConnector(Connector.ConnectorType.BOTH);
            this.futures.add(this.initializeServer(both, serverGroup, workerGroup, "Both"));
        } else {
            this.futures.add(this.initializeServer(inferenceConnector, serverGroup, workerGroup, "Inference"));
            this.futures.add(this.initializeServer(managementConnector, serverGroup, workerGroup, "Management"));
        }
        return this.futures;
    }

    public boolean isRunning() {
        return !this.stopped.get();
    }

    public void stop() {
        if (this.stopped.get()) {
            return;
        }
        this.stopped.set(true);
        for (ChannelFuture future : this.futures) {
            future.channel().close();
        }
        this.serverGroups.shutdown(true);
        this.serverGroups.reset();
    }

    private ChannelFuture initializeServer(Connector connector, EventLoopGroup serverGroup, EventLoopGroup workerGroup, String purpose) throws InterruptedException, IOException, GeneralSecurityException {
        ChannelFuture future;
        Class<? extends ServerChannel> channelClass = connector.getServerChannel();
        logger.info("Initialize {} server with: {}.", (Object)purpose, (Object)channelClass.getSimpleName());
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.option(ChannelOption.SO_BACKLOG, (Object)1024)).channel(channelClass)).childOption(ChannelOption.SO_LINGER, (Object)0).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.group(serverGroup, workerGroup);
        SslContext sslCtx = null;
        if (connector.isSsl()) {
            sslCtx = this.configManager.getSslContext();
        }
        b.childHandler((ChannelHandler)new ServerInitializer(sslCtx, connector.getType()));
        try {
            future = b.bind(connector.getSocketAddress()).sync();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw new IOException("Failed to bind to address: " + connector, e);
            }
            throw e;
        }
        future.addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (!f.isSuccess()) {
                try {
                    f.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("", (Throwable)e);
                }
                System.exit(2);
            }
            this.serverGroups.registerChannel(f.channel());
        }));
        future.sync();
        ChannelFuture f2 = future.channel().closeFuture();
        f2.addListener((GenericFutureListener)((ChannelFutureListener)listener -> logger.info("{} model server stopped.", (Object)connector.getType())));
        logger.info("{} API bind to: {}", (Object)purpose, (Object)connector);
        return f2;
    }

    private void initModelStore() throws IOException {
        List<String> urls;
        ModelManager.init(this.configManager);
        Set<String> startupModels = ModelManager.getInstance().getStartupModels();
        String loadModels = this.configManager.getLoadModels();
        if (loadModels == null || loadModels.isEmpty()) {
            return;
        }
        ModelManager modelManager = ModelManager.getInstance();
        if ("ALL".equalsIgnoreCase(loadModels)) {
            String modelStore = this.configManager.getModelStore();
            if (modelStore == null) {
                logger.warn("Model store is not configured.");
                return;
            }
            Path modelStoreDir = Paths.get(modelStore, new String[0]);
            if (!Files.isDirectory(modelStoreDir, new LinkOption[0])) {
                logger.warn("Model store path is not found: {}", (Object)modelStore);
                return;
            }
            urls = Files.list(modelStoreDir).filter(p -> {
                logger.info("Found file in model_store: {}", p);
                try {
                    return !Files.isHidden(p) && Files.isDirectory(p, new LinkOption[0]) || FilenameUtils.isArchiveFile((String)p.toString());
                }
                catch (IOException e) {
                    logger.warn("Failed to access file: " + p, (Throwable)e);
                    return false;
                }
            }).map(p -> {
                try {
                    return p.toUri().toURL().toString();
                }
                catch (MalformedURLException e) {
                    throw new AssertionError("Invalid path: " + p, e);
                }
            }).collect(Collectors.toList());
        } else {
            String[] modelsUrls = loadModels.split("[, ]+");
            urls = Arrays.asList(modelsUrls);
        }
        for (String url : urls) {
            logger.info("Initializing model: {}", (Object)url);
            int workers = this.configManager.getDefaultWorkers();
            CompletableFuture<ModelInfo> future = modelManager.registerModel(null, url, 1, 100);
            ModelInfo info = future.join();
            String modelName = info.getModelName();
            modelManager.updateModel(modelName, workers, workers);
            startupModels.add(modelName);
        }
    }

    private static void printHelp(String msg, Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setLeftPadding(1);
        formatter.setWidth(120);
        formatter.printHelp(msg, options);
    }
}

