/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.serving;

import ai.djl.serving.http.InferenceRequestHandler;
import ai.djl.serving.http.InvalidRequestHandler;
import ai.djl.serving.http.ManagementRequestHandler;
import ai.djl.serving.util.ConfigManager;
import ai.djl.serving.util.Connector;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslContext;

public class ServerInitializer
extends ChannelInitializer<Channel> {
    private Connector.ConnectorType connectorType;
    private SslContext sslCtx;

    public ServerInitializer(SslContext sslCtx, Connector.ConnectorType connectorType) {
        this.sslCtx = sslCtx;
        this.connectorType = connectorType;
    }

    public void initChannel(Channel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        int maxRequestSize = ConfigManager.getInstance().getMaxRequestSize();
        if (this.sslCtx != null) {
            pipeline.addLast("ssl", (ChannelHandler)this.sslCtx.newHandler(ch.alloc()));
        }
        pipeline.addLast("http", (ChannelHandler)new HttpServerCodec());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(maxRequestSize, true));
        switch (this.connectorType) {
            case MANAGEMENT: {
                pipeline.addLast("management", (ChannelHandler)new ManagementRequestHandler());
                break;
            }
            case INFERENCE: {
                pipeline.addLast("inference", (ChannelHandler)new InferenceRequestHandler());
                break;
            }
            default: {
                pipeline.addLast("inference", (ChannelHandler)new InferenceRequestHandler());
                pipeline.addLast("management", (ChannelHandler)new ManagementRequestHandler());
            }
        }
        pipeline.addLast("badRequest", (ChannelHandler)new InvalidRequestHandler());
    }
}

