/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.serving.http;

import ai.djl.ModelException;
import ai.djl.serving.http.BadRequestException;
import ai.djl.serving.http.MethodNotAllowedException;
import ai.djl.serving.util.NettyUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestHandler.class);

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) {
        try {
            NettyUtils.requestReceived(ctx.channel(), (HttpRequest)req);
            if (!req.decoderResult().isSuccess()) {
                throw new BadRequestException("Invalid HTTP message.");
            }
            QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
            String path = decoder.path();
            if ("/".equals(path)) {
                if (HttpMethod.OPTIONS.equals((Object)req.method())) {
                    this.handleApiDescription(ctx);
                    return;
                }
                throw new MethodNotAllowedException();
            }
            String[] segments = path.split("/");
            this.handleRequest(ctx, req, decoder, segments);
        }
        catch (Throwable t) {
            NettyUtils.sendError(ctx, t);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("", cause);
        ctx.close();
    }

    protected abstract void handleRequest(ChannelHandlerContext var1, FullHttpRequest var2, QueryStringDecoder var3, String[] var4) throws ModelException;

    private void handleApiDescription(ChannelHandlerContext ctx) {
        NettyUtils.sendJsonResponse(ctx, "{}");
    }
}

