/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.serving.http;

import io.netty.handler.codec.http.HttpRequest;
import java.util.UUID;

public class Session {
    private String requestId;
    private String remoteIp;
    private String method;
    private String uri;
    private String protocol;
    private int code;
    private long startTime;

    public Session(String remoteIp, HttpRequest request) {
        this.remoteIp = remoteIp;
        this.uri = request.uri();
        if (request.decoderResult().isSuccess()) {
            this.method = request.method().name();
            this.protocol = request.protocolVersion().text();
        } else {
            this.method = "GET";
            this.protocol = "HTTP/1.1";
        }
        this.requestId = UUID.randomUUID().toString();
        this.startTime = System.currentTimeMillis();
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String toString() {
        long duration = System.currentTimeMillis() - this.startTime;
        return this.remoteIp + " \"" + this.method + " " + this.uri + ' ' + this.protocol + "\" " + this.code + ' ' + duration;
    }
}

