/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.serving.util;

import ai.djl.serving.Arguments;
import ai.djl.serving.util.Connector;
import ai.djl.serving.util.OpenSslKey;
import ai.djl.util.Utils;
import ai.djl.util.cuda.CudaUtils;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public final class ConfigManager {
    private static final String DEBUG = "debug";
    private static final String INFERENCE_ADDRESS = "inference_address";
    private static final String MANAGEMENT_ADDRESS = "management_address";
    private static final String LOAD_MODELS = "load_models";
    private static final String DEFAULT_WORKERS_PER_MODEL = "default_workers_per_model";
    private static final String NUMBER_OF_NETTY_THREADS = "number_of_netty_threads";
    private static final String NETTY_CLIENT_THREADS = "netty_client_threads";
    private static final String JOB_QUEUE_SIZE = "job_queue_size";
    private static final String NUMBER_OF_GPU = "number_of_gpu";
    private static final String CORS_ALLOWED_ORIGIN = "cors_allowed_origin";
    private static final String CORS_ALLOWED_METHODS = "cors_allowed_methods";
    private static final String CORS_ALLOWED_HEADERS = "cors_allowed_headers";
    private static final String KEYSTORE = "keystore";
    private static final String KEYSTORE_PASS = "keystore_pass";
    private static final String KEYSTORE_TYPE = "keystore_type";
    private static final String CERTIFICATE_FILE = "certificate_file";
    private static final String PRIVATE_KEY_FILE = "private_key_file";
    private static final String MAX_REQUEST_SIZE = "max_request_size";
    private static final String MODEL_SERVER_HOME = "model_server_home";
    private static final String MODEL_STORE = "model_store";
    private static final String MODEL_URL_PATTERN = "model_url_pattern";
    private static final String USE_NATIVE_IO = "use_native_io";
    private static final String IO_RATIO = "io_ratio";
    private static ConfigManager instance;
    private Properties prop = new Properties();

    private ConfigManager(Arguments args) {
        CharSequence[] models;
        String modelStore;
        Path file = args.getConfigFile();
        if (file != null) {
            try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
                this.prop.load(stream);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to read configuration file", e);
            }
            this.prop.put("configFile", file.toString());
        }
        if ((modelStore = args.getModelStore()) != null) {
            this.prop.setProperty(MODEL_STORE, modelStore);
        }
        if ((models = args.getModels()) != null) {
            this.prop.setProperty(LOAD_MODELS, String.join((CharSequence)",", models));
        }
        int gpus = this.getIntProperty(NUMBER_OF_GPU, Integer.MAX_VALUE);
        gpus = Integer.min(gpus, CudaUtils.getGpuCount());
        this.prop.setProperty(NUMBER_OF_GPU, String.valueOf(gpus));
    }

    public static void init(Arguments args) {
        instance = new ConfigManager(args);
    }

    public static ConfigManager getInstance() {
        return instance;
    }

    public boolean isDebug() {
        return Boolean.getBoolean("ai.djl.debug") || Boolean.parseBoolean(this.prop.getProperty(DEBUG, "false"));
    }

    public Connector getConnector(Connector.ConnectorType type) {
        String binding = type == Connector.ConnectorType.MANAGEMENT ? this.prop.getProperty(MANAGEMENT_ADDRESS, "http://127.0.0.1:8080") : this.prop.getProperty(INFERENCE_ADDRESS, "http://127.0.0.1:8080");
        return Connector.parse(binding, type);
    }

    public int getNettyThreads() {
        return this.getIntProperty(NUMBER_OF_NETTY_THREADS, 0);
    }

    public int getNettyClientThreads() {
        return this.getIntProperty(NETTY_CLIENT_THREADS, 0);
    }

    public int getJobQueueSize() {
        return this.getIntProperty(JOB_QUEUE_SIZE, 100);
    }

    public int getNumberOfGpu() {
        return this.getIntProperty(NUMBER_OF_GPU, 0);
    }

    public int getDefaultWorkers() {
        if (this.isDebug()) {
            return 1;
        }
        int workers = this.getIntProperty(DEFAULT_WORKERS_PER_MODEL, 0);
        if (workers == 0) {
            workers = this.getNumberOfGpu();
        }
        if (workers == 0) {
            workers = Runtime.getRuntime().availableProcessors();
        }
        return workers;
    }

    public String getModelServerHome() {
        String home = System.getenv("MODEL_SERVER_HOME");
        if (home == null && (home = System.getProperty(MODEL_SERVER_HOME)) == null && (home = this.getProperty(MODEL_SERVER_HOME, null)) == null) {
            home = ConfigManager.getCanonicalPath(".");
            return home;
        }
        Path dir = Paths.get(home, new String[0]);
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IllegalArgumentException("Model server home not exist: " + home);
        }
        home = ConfigManager.getCanonicalPath(dir);
        return home;
    }

    public String getModelStore() {
        return ConfigManager.getCanonicalPath(this.prop.getProperty(MODEL_STORE));
    }

    public String getModelUrlPattern() {
        return this.prop.getProperty(MODEL_URL_PATTERN);
    }

    public String getLoadModels() {
        return this.prop.getProperty(LOAD_MODELS);
    }

    public String getCorsAllowedOrigin() {
        return this.prop.getProperty(CORS_ALLOWED_ORIGIN);
    }

    public String getCorsAllowedMethods() {
        return this.prop.getProperty(CORS_ALLOWED_METHODS);
    }

    public String getCorsAllowedHeaders() {
        return this.prop.getProperty(CORS_ALLOWED_HEADERS);
    }

    public SslContext getSslContext() throws IOException, GeneralSecurityException {
        X509Certificate[] chain;
        PrivateKey privateKey;
        List<String> supportedCiphers = Arrays.asList("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        String keyStoreFile = this.prop.getProperty(KEYSTORE);
        String privateKeyFile = this.prop.getProperty(PRIVATE_KEY_FILE);
        String certificateFile = this.prop.getProperty(CERTIFICATE_FILE);
        if (keyStoreFile != null) {
            char[] keystorePass = this.getProperty(KEYSTORE_PASS, "changeit").toCharArray();
            String keystoreType = this.getProperty(KEYSTORE_TYPE, "PKCS12");
            KeyStore keyStore = KeyStore.getInstance(keystoreType);
            try (InputStream is = Files.newInputStream(Paths.get(keyStoreFile, new String[0]), new OpenOption[0]);){
                keyStore.load(is, keystorePass);
            }
            Enumeration<String> en = keyStore.aliases();
            String keyAlias = null;
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                keyAlias = alias;
                break;
            }
            if (keyAlias == null) {
                throw new KeyException("No key entry found in keystore.");
            }
            privateKey = (PrivateKey)keyStore.getKey(keyAlias, keystorePass);
            Certificate[] certs = keyStore.getCertificateChain(keyAlias);
            chain = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                chain[i] = (X509Certificate)certs[i];
            }
        } else if (privateKeyFile != null && certificateFile != null) {
            privateKey = this.loadPrivateKey(privateKeyFile);
            chain = this.loadCertificateChain(certificateFile);
        } else {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            privateKey = ssc.key();
            chain = new X509Certificate[]{ssc.cert()};
        }
        return SslContextBuilder.forServer((PrivateKey)privateKey, (X509Certificate[])chain).protocols(new String[]{"TLSv1.2"}).ciphers(supportedCiphers).build();
    }

    public String getProperty(String key, String def) {
        return this.prop.getProperty(key, def);
    }

    public String dumpConfigurations() {
        Runtime runtime = Runtime.getRuntime();
        return "\nModel server home: " + this.getModelServerHome() + "\nCurrent directory: " + ConfigManager.getCanonicalPath(".") + "\nTemp directory: " + System.getProperty("java.io.tmpdir") + "\nNumber of GPUs: " + this.getNumberOfGpu() + "\nNumber of CPUs: " + runtime.availableProcessors() + "\nMax heap size: " + runtime.maxMemory() / 1024L / 1024L + "\nConfig file: " + this.prop.getProperty("configFile", "N/A") + "\nInference address: " + this.getConnector(Connector.ConnectorType.INFERENCE) + "\nManagement address: " + this.getConnector(Connector.ConnectorType.MANAGEMENT) + "\nModel Store: " + (this.getModelStore() == null ? "N/A" : this.getModelStore()) + "\nInitial Models: " + (this.getLoadModels() == null ? "N/A" : this.getLoadModels()) + "\nNetty threads: " + this.getNettyThreads() + "\nNetty client threads: " + this.getNettyClientThreads() + "\nDefault workers per model: " + this.getDefaultWorkers() + "\nMaximum Request Size: " + this.prop.getProperty(MAX_REQUEST_SIZE, "6553500");
    }

    public boolean useNativeIo() {
        return Boolean.parseBoolean(this.prop.getProperty(USE_NATIVE_IO, "true"));
    }

    public int getIoRatio() {
        return this.getIntProperty(IO_RATIO, 50);
    }

    public int getMaxRequestSize() {
        return this.getIntProperty(MAX_REQUEST_SIZE, 6553500);
    }

    private int getIntProperty(String key, int def) {
        String value = this.prop.getProperty(key);
        if (value == null) {
            return def;
        }
        return Integer.parseInt(value);
    }

    private static String getCanonicalPath(Path file) {
        try {
            return file.toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            return file.toAbsolutePath().toString();
        }
    }

    private static String getCanonicalPath(String path) {
        if (path == null) {
            return null;
        }
        return ConfigManager.getCanonicalPath(Paths.get(path, new String[0]));
    }

    /*
     * Loose catch block
     */
    private PrivateKey loadPrivateKey(String keyFile) throws IOException, GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        Throwable throwable = null;
        try (InputStream is = Files.newInputStream(Paths.get(keyFile, new String[0]), new OpenOption[0]);){
            String content = Utils.toString((InputStream)is);
            content = content.replaceAll("-----(BEGIN|END)( RSA)? PRIVATE KEY-----\\s*", "");
            byte[] buf = Base64.getMimeDecoder().decode(content);
            try {
                PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(buf);
                PrivateKey privateKey = keyFactory.generatePrivate(privKeySpec);
                return privateKey;
            }
            catch (InvalidKeySpecException e) {
                PrivateKey privateKey;
                block17: {
                    block18: {
                        buf = OpenSslKey.convertPrivateKey(buf);
                        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(buf);
                        privateKey = keyFactory.generatePrivate(privKeySpec);
                        if (is == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    is.close();
                }
                return privateKey;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    private X509Certificate[] loadCertificateChain(String keyFile) throws IOException, GeneralSecurityException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (InputStream is = Files.newInputStream(Paths.get(keyFile, new String[0]), new OpenOption[0]);){
            Collection<? extends Certificate> certs = cf.generateCertificates(is);
            int i = 0;
            X509Certificate[] chain = new X509Certificate[certs.size()];
            for (Certificate certificate : certs) {
                chain[i++] = (X509Certificate)certificate;
            }
            X509Certificate[] x509CertificateArray = chain;
            return x509CertificateArray;
        }
    }
}

