/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.serving.util;

import ai.djl.serving.util.ConfigManager;
import ai.djl.util.Utils;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Connector {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("((https|http)://([^:^/]+)(:([0-9]+))?)|(unix:(/.*))", 2);
    private static boolean useNativeIo = ConfigManager.getInstance().useNativeIo();
    private boolean uds;
    private String socketPath;
    private String bindIp;
    private int port;
    private boolean ssl;
    private ConnectorType type;

    private Connector(int port, boolean uds, String bindIp, String socketPath, boolean ssl, ConnectorType type) {
        this.port = port;
        this.uds = uds;
        this.bindIp = bindIp;
        this.socketPath = socketPath;
        this.ssl = ssl;
        this.type = type;
    }

    public static Connector parse(String binding, ConnectorType connectorType) {
        boolean uds;
        Matcher matcher = ADDRESS_PATTERN.matcher(binding);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid binding address: " + binding);
        }
        boolean bl = uds = matcher.group(7) != null;
        if (uds) {
            if (!useNativeIo) {
                throw new IllegalArgumentException("unix domain socket requires use_native_io set to true.");
            }
            String path = matcher.group(7);
            return new Connector(-1, true, "", path, false, connectorType);
        }
        String protocol = matcher.group(2);
        String host = matcher.group(3);
        String listeningPort = matcher.group(5);
        boolean ssl = "https".equalsIgnoreCase(protocol);
        int port = listeningPort == null ? (ssl ? 443 : 80) : Integer.parseInt(listeningPort);
        if (port >= Short.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid port number: " + binding);
        }
        return new Connector(port, false, host, String.valueOf(port), ssl, connectorType);
    }

    public String getSocketType() {
        return this.uds ? "unix" : "tcp";
    }

    public boolean isUds() {
        return this.uds;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getSocketPath() {
        return this.socketPath;
    }

    public SocketAddress getSocketAddress() {
        return this.uds ? new DomainSocketAddress(this.socketPath) : new InetSocketAddress(this.bindIp, this.port);
    }

    public ConnectorType getType() {
        return this.type;
    }

    public static EventLoopGroup newEventLoopGroup(int threads) {
        if (useNativeIo && Epoll.isAvailable()) {
            return new EpollEventLoopGroup(threads);
        }
        if (useNativeIo && KQueue.isAvailable()) {
            return new KQueueEventLoopGroup(threads);
        }
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(threads);
        eventLoopGroup.setIoRatio(ConfigManager.getInstance().getIoRatio());
        return eventLoopGroup;
    }

    public Class<? extends ServerChannel> getServerChannel() {
        if (useNativeIo && Epoll.isAvailable()) {
            return this.uds ? EpollServerDomainSocketChannel.class : EpollServerSocketChannel.class;
        }
        if (useNativeIo && KQueue.isAvailable()) {
            return this.uds ? KQueueServerDomainSocketChannel.class : KQueueServerSocketChannel.class;
        }
        return NioServerSocketChannel.class;
    }

    public Class<? extends Channel> getClientChannel() {
        if (useNativeIo && Epoll.isAvailable()) {
            return this.uds ? EpollDomainSocketChannel.class : EpollSocketChannel.class;
        }
        if (useNativeIo && KQueue.isAvailable()) {
            return this.uds ? KQueueDomainSocketChannel.class : KQueueSocketChannel.class;
        }
        return NioSocketChannel.class;
    }

    public void clean() {
        if (this.uds) {
            Utils.deleteQuietly((Path)Paths.get(this.socketPath, new String[0]));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connector connector = (Connector)o;
        return this.uds == connector.uds && this.port == connector.port && this.socketPath.equals(connector.socketPath) && this.bindIp.equals(connector.bindIp);
    }

    public int hashCode() {
        return Objects.hash(this.uds, this.socketPath, this.bindIp, this.port);
    }

    public String toString() {
        if (this.uds) {
            return "unix:" + this.socketPath;
        }
        if (this.ssl) {
            return "https://" + this.bindIp + ':' + this.port;
        }
        return "http://" + this.bindIp + ':' + this.port;
    }

    public static enum ConnectorType {
        INFERENCE,
        MANAGEMENT,
        BOTH;

    }
}

