/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.serving.util;

import ai.djl.ModelException;
import ai.djl.modality.Input;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.serving.http.BadRequestException;
import ai.djl.serving.http.ErrorResponse;
import ai.djl.serving.http.MethodNotAllowedException;
import ai.djl.serving.http.ResourceNotFoundException;
import ai.djl.serving.http.ServiceUnavailableException;
import ai.djl.serving.http.Session;
import ai.djl.serving.util.ConfigManager;
import ai.djl.util.JsonUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"ACCESS_LOG");
    private static final String REQUEST_ID = "x-request-id";
    private static final AttributeKey<Session> SESSION_KEY = AttributeKey.valueOf((String)"session");

    private NettyUtils() {
    }

    public static void requestReceived(Channel channel, HttpRequest request) {
        Session session = (Session)channel.attr(SESSION_KEY).get();
        assert (session == null);
        SocketAddress address = channel.remoteAddress();
        String remoteIp = address == null ? "0.0.0.0" : address.toString();
        channel.attr(SESSION_KEY).set((Object)new Session(remoteIp, request));
    }

    public static String getRequestId(Channel channel) {
        Session accessLog = (Session)channel.attr(SESSION_KEY).get();
        if (accessLog != null) {
            return accessLog.getRequestId();
        }
        return null;
    }

    public static void sendJsonResponse(ChannelHandlerContext ctx, Object json) {
        NettyUtils.sendJsonResponse(ctx, JsonUtils.GSON_PRETTY.toJson(json), HttpResponseStatus.OK);
    }

    public static void sendJsonResponse(ChannelHandlerContext ctx, Object json, HttpResponseStatus status) {
        NettyUtils.sendJsonResponse(ctx, JsonUtils.GSON_PRETTY.toJson(json), status);
    }

    public static void sendJsonResponse(ChannelHandlerContext ctx, String json) {
        NettyUtils.sendJsonResponse(ctx, json, HttpResponseStatus.OK);
    }

    public static void sendJsonResponse(ChannelHandlerContext ctx, String json, HttpResponseStatus status) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, false);
        resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        ByteBuf content = resp.content();
        content.writeCharSequence((CharSequence)json, CharsetUtil.UTF_8);
        content.writeByte(10);
        NettyUtils.sendHttpResponse(ctx, (FullHttpResponse)resp, true);
    }

    public static void sendError(ChannelHandlerContext ctx, Throwable t) {
        if (t instanceof ResourceNotFoundException || t instanceof ModelNotFoundException) {
            logger.trace("", t);
            NettyUtils.sendError(ctx, HttpResponseStatus.NOT_FOUND, t);
        } else if (t instanceof BadRequestException || t instanceof ModelException) {
            logger.trace("", t);
            NettyUtils.sendError(ctx, HttpResponseStatus.BAD_REQUEST, t);
        } else if (t instanceof MethodNotAllowedException) {
            logger.trace("", t);
            NettyUtils.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED, t);
        } else if (t instanceof ServiceUnavailableException) {
            logger.trace("", t);
            NettyUtils.sendError(ctx, HttpResponseStatus.SERVICE_UNAVAILABLE, t);
        } else {
            logger.error("", t);
            NettyUtils.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, t);
        }
    }

    public static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, Throwable t) {
        ErrorResponse error = new ErrorResponse(status.code(), t.getClass().getSimpleName(), t.getMessage());
        NettyUtils.sendJsonResponse(ctx, error, status);
    }

    public static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpResponse resp, boolean keepAlive) {
        Channel channel = ctx.channel();
        Session session = (Session)channel.attr(SESSION_KEY).getAndSet(null);
        HttpHeaders headers = resp.headers();
        ConfigManager configManager = ConfigManager.getInstance();
        int code = resp.status().code();
        if (session != null) {
            session.setCode(code);
            headers.set(REQUEST_ID, (Object)session.getRequestId());
            logger.info(session.toString());
        } else {
            logger.info("HTTP " + code);
        }
        String allowedOrigin = configManager.getCorsAllowedOrigin();
        String allowedMethods = configManager.getCorsAllowedMethods();
        String allowedHeaders = configManager.getCorsAllowedHeaders();
        if (allowedOrigin != null && !allowedOrigin.isEmpty() && !headers.contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN)) {
            headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)allowedOrigin);
        }
        if (allowedMethods != null && !allowedMethods.isEmpty() && !headers.contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS)) {
            headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, (Object)allowedMethods);
        }
        if (allowedHeaders != null && !allowedHeaders.isEmpty() && !headers.contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS)) {
            headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, (Object)allowedHeaders);
        }
        headers.set("Pragma", (Object)"no-cache");
        headers.set("Cache-Control", (Object)"no-cache; no-store, must-revalidate, private");
        headers.set("Expires", (Object)"Thu, 01 Jan 1970 00:00:00 UTC");
        HttpUtil.setContentLength((HttpMessage)resp, (long)resp.content().readableBytes());
        if (!keepAlive || code >= 400) {
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            ChannelFuture f = channel.writeAndFlush((Object)resp);
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            channel.writeAndFlush((Object)resp);
        }
    }

    public static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public static byte[] getBytes(ByteBuf buf) {
        if (buf.hasArray()) {
            return buf.array();
        }
        byte[] ret = new byte[buf.readableBytes()];
        int readerIndex = buf.readerIndex();
        buf.getBytes(readerIndex, ret);
        return ret;
    }

    public static String getParameter(QueryStringDecoder decoder, String key, String def) {
        List param = (List)decoder.parameters().get(key);
        if (param != null && !param.isEmpty()) {
            return (String)param.get(0);
        }
        return def;
    }

    public static int getIntParameter(QueryStringDecoder decoder, String key, int def) {
        String value = NettyUtils.getParameter(decoder, key, null);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static void addFormData(InterfaceHttpData data, Input input) {
        if (data == null) {
            return;
        }
        try {
            String name = data.getName();
            switch (data.getHttpDataType()) {
                case Attribute: {
                    Attribute attribute = (Attribute)data;
                    input.addData(name, attribute.getValue().getBytes(StandardCharsets.UTF_8));
                    break;
                }
                case FileUpload: {
                    FileUpload fileUpload = (FileUpload)data;
                    input.addData(name, NettyUtils.getBytes(fileUpload.getByteBuf()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Except form field, but got " + data.getHttpDataType());
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

