/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.serving.wlm;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.serving.wlm.Job;
import ai.djl.serving.wlm.ModelInfo;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.ArrayList;
import java.util.List;

class BatchAggregator {
    private ModelInfo model;
    private List<Job> jobs;

    public BatchAggregator(ModelInfo model) {
        this.model = model;
        this.jobs = new ArrayList<Job>();
    }

    public List<Input> getRequest() throws InterruptedException {
        this.model.pollBatch(this.jobs);
        ArrayList<Input> list = new ArrayList<Input>(this.jobs.size());
        for (Job job : this.jobs) {
            job.setScheduled();
            list.add(job.getInput());
        }
        return list;
    }

    public void sendResponse(List<Output> outputs) {
        if (this.jobs.size() != outputs.size()) {
            throw new IllegalStateException("Not all jobs get response.");
        }
        int i = 0;
        for (Output output : outputs) {
            Job job;
            String requestId = output.getRequestId();
            if (!(job = this.jobs.get(i++)).getRequestId().equals(requestId)) {
                throw new IllegalStateException("Request response mismatched.");
            }
            job.sendOutput(output);
        }
        this.jobs.clear();
    }

    public void sendError() {
        for (Job job : this.jobs) {
            job.sendError(HttpResponseStatus.INTERNAL_SERVER_ERROR, "Internal server error");
        }
        this.jobs.clear();
    }
}

