/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.serving.wlm;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.serving.http.InternalServerException;
import ai.djl.serving.util.NettyUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Job {
    private static final Logger logger = LoggerFactory.getLogger(Job.class);
    private ChannelHandlerContext ctx;
    private String modelName;
    private Input input;
    private long begin;
    private long scheduled;

    public Job(ChannelHandlerContext ctx, String modelName, Input input) {
        this.ctx = ctx;
        this.modelName = modelName;
        this.input = input;
        this.scheduled = this.begin = System.currentTimeMillis();
    }

    public String getRequestId() {
        return this.input.getRequestId();
    }

    public String getModelName() {
        return this.modelName;
    }

    public Input getInput() {
        return this.input;
    }

    public void setScheduled() {
        this.scheduled = System.currentTimeMillis();
    }

    public void sendOutput(Output output) {
        DefaultFullHttpResponse resp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, false);
        for (Map.Entry entry : output.getProperties().entrySet()) {
            resp.headers().set((String)entry.getKey(), entry.getValue());
        }
        resp.content().writeBytes(output.getContent());
        if (this.ctx != null) {
            NettyUtils.sendHttpResponse(this.ctx, (FullHttpResponse)resp, true);
        }
        logger.debug("Waiting time: {}, Backend time: {}", (Object)(this.scheduled - this.begin), (Object)(System.currentTimeMillis() - this.scheduled));
    }

    public void sendError(HttpResponseStatus status, String error) {
        if (this.ctx != null) {
            NettyUtils.sendError(this.ctx, status, new InternalServerException(error));
        }
        logger.debug("Waiting time: {}, Inference time: {}", (Object)(this.scheduled - this.begin), (Object)(System.currentTimeMillis() - this.begin));
    }
}

