/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.serving.wlm;

import ai.djl.modality.Input;
import ai.djl.modality.Output;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.serving.wlm.Job;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelInfo
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ModelInfo.class);
    private String modelName;
    private String modelUrl;
    private int minWorkers;
    private int maxWorkers;
    private int batchSize;
    private int maxBatchDelay;
    private ReentrantLock lock;
    private LinkedBlockingDeque<Job> jobs;
    private ZooModel<Input, Output> model;

    public ModelInfo(String modelName, String modelUrl, ZooModel<Input, Output> model, int queueSize) {
        this.modelName = modelName;
        this.modelUrl = modelUrl;
        this.model = model;
        this.batchSize = 1;
        this.maxBatchDelay = 100;
        this.jobs = new LinkedBlockingDeque(queueSize);
        this.lock = new ReentrantLock();
    }

    public ZooModel<Input, Output> getModel() {
        return this.model;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelUrl() {
        return this.modelUrl;
    }

    public Path getModelDir() {
        return this.model.getModelPath();
    }

    public int getMinWorkers() {
        return this.minWorkers;
    }

    public void setMinWorkers(int minWorkers) {
        this.minWorkers = minWorkers;
    }

    public int getMaxWorkers() {
        return this.maxWorkers;
    }

    public void setMaxWorkers(int maxWorkers) {
        this.maxWorkers = maxWorkers;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getMaxBatchDelay() {
        return this.maxBatchDelay;
    }

    public void setMaxBatchDelay(int maxBatchDelay) {
        this.maxBatchDelay = maxBatchDelay;
    }

    public boolean addJob(Job job) {
        return this.jobs.offer(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollBatch(List<Job> list) throws InterruptedException {
        try {
            long end;
            this.lock.lockInterruptibly();
            Job job = this.jobs.take();
            logger.trace("get first job: {}", (Object)job.getRequestId());
            list.add(job);
            long begin = System.currentTimeMillis();
            long maxDelay = this.maxBatchDelay;
            for (int i = 0; i < this.batchSize - 1 && maxDelay > 0L && (job = this.jobs.poll(maxDelay, TimeUnit.MILLISECONDS)) != null; maxDelay -= end - begin, ++i) {
                end = System.currentTimeMillis();
                begin = end;
                list.add(job);
            }
            logger.trace("sending jobs, size: {}", (Object)list.size());
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        if (this.model != null) {
            this.model.close();
        }
    }
}

