/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.spring.configuration;

import ai.djl.MalformedModelException;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.spring.configuration.ApplicationType;
import ai.djl.spring.configuration.DjlConfigurationProperties;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.ClassLoaderUtils;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Configuration
@ConditionalOnMissingBean(value={ZooModel.class})
@EnableConfigurationProperties(value={DjlConfigurationProperties.class})
public class DjlAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DjlAutoConfiguration.class);
    @Autowired
    private DjlConfigurationProperties properties;

    @Bean
    public ZooModel<?, ?> model() throws MalformedModelException, ModelNotFoundException, IOException {
        Class<Object> outputClass;
        ApplicationType applicationType = this.properties.getApplicationType();
        Map<String, String> filter = this.properties.getModelFilter();
        Map<String, Object> arguments = this.properties.getArguments();
        String artifactId = this.properties.getModelArtifactId();
        Class<Object> inputClass = this.properties.getInputClass();
        Object[] urls = this.properties.getUrls();
        String translatorFactory = this.properties.getTranslatorFactory();
        if (inputClass == null) {
            LOG.warn("Input class is not defined. Using default: BufferedImage");
            inputClass = Image.class;
        }
        if ((outputClass = this.properties.getOutputClass()) == null) {
            LOG.warn("Input class is not defined. Using default: DetectedObjects");
            outputClass = DetectedObjects.class;
        }
        Criteria.Builder builder = Criteria.builder().setTypes(inputClass, outputClass);
        if (applicationType != null) {
            builder.optApplication(applicationType.application());
        }
        if (filter != null) {
            builder.optFilters(filter);
        }
        if (artifactId != null) {
            builder.optArtifactId(artifactId);
        }
        if (arguments != null) {
            builder.optArguments(arguments);
        }
        if (translatorFactory != null) {
            ClassLoader cl = ClassLoaderUtils.getContextClassLoader();
            TranslatorFactory factory = (TranslatorFactory)ClassLoaderUtils.initClass((ClassLoader)cl, TranslatorFactory.class, (String)translatorFactory);
            builder.optTranslatorFactory(factory);
        }
        if (urls != null && urls.length > 0) {
            builder.optModelUrls(StringUtils.arrayToCommaDelimitedString((Object[])urls));
        }
        try {
            ZooModel zooModel = builder.build().loadModel();
            LOG.info("Successfully loaded model {}", (Object)zooModel.getName());
            return zooModel;
        }
        catch (ModelNotFoundException ex) {
            Yaml yaml = this.createYamlDumper();
            LOG.error("Requested model was not found");
            LOG.error("List of available models {}", (Object)yaml.dump((Object)ModelZoo.listModels()));
            throw ex;
        }
    }

    private Yaml createYamlDumper() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setPrettyFlow(true);
        return new Yaml(options);
    }

    @Bean
    public Supplier<Predictor<?, ?>> predictorProvider(ZooModel<?, ?> model) {
        return () -> model.newPredictor();
    }
}

