/*
 * Decompiled with CFR 0.152.
 */
package ai.dragonfly.viz.cli;

import ai.dragonfly.math.UnsupportedVectorDimension$;
import ai.dragonfly.math.geometry.Line$;
import ai.dragonfly.math.interval.Interval;
import ai.dragonfly.math.interval.Interval$;
import ai.dragonfly.math.vector.package$;
import ai.dragonfly.viz.cli.CLImg;
import ai.dragonfly.viz.cli.Chart$;
import ai.dragonfly.viz.cli.ChartConfig;
import ai.dragonfly.viz.cli.Glyph;
import ai.dragonfly.viz.cli.Glyph$;
import ai.dragonfly.viz.cli.SegmentedString;
import java.io.Serializable;
import narr.package;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Array;
import scala.scalajs.js.ArrayOps$;
import scala.scalajs.js.typedarray.Float64Array;

public class Chart
implements Product,
Serializable {
    private final ChartConfig conf;
    private final double scaleX;
    private final double scaleY;
    private final int aXa;
    private final int aYa;
    private final CLImg cimg;
    private final int leftPaddingWidth;
    private final TreeMap<String, Glyph> legend;
    private int maxItemNameLength;

    public static Chart apply(ChartConfig chartConfig) {
        return Chart$.MODULE$.apply(chartConfig);
    }

    public static Chart apply(String string, String string2, String string3, Interval<Object> interval, Interval<Object> interval2, int n, int n2) {
        return Chart$.MODULE$.apply(string, string2, string3, interval, interval2, n, n2);
    }

    public static Chart apply(String string, String string2, String string3, String string4, Interval<Object> interval, Interval<Object> interval2, int n, int n2) {
        return Chart$.MODULE$.apply(string, string2, string3, string4, interval, interval2, n, n2);
    }

    public static Chart fromProduct(Product product) {
        return Chart$.MODULE$.fromProduct(product);
    }

    public static Chart unapply(Chart chart) {
        return Chart$.MODULE$.unapply(chart);
    }

    public Chart(ChartConfig conf) {
        int n;
        this.conf = conf;
        this.scaleX = (double)conf.width() / BoxesRunTime.unboxToDouble((Object)conf.domain().norm());
        this.scaleY = (double)conf.height() / BoxesRunTime.unboxToDouble((Object)conf.range().norm());
        this.aXa = (int)(-BoxesRunTime.unboxToDouble((Object)conf.domain().min()) * this.scaleX()) % 2 == 0 ? 1 : 0;
        int n2 = (int)(-BoxesRunTime.unboxToDouble((Object)conf.range().min()) * this.scaleY()) % 4;
        switch (n2) {
            case 0: {
                n = 2;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 0;
                break;
            }
            case 3: {
                n = -1;
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
            }
        }
        this.aYa = n;
        this.cimg = new CLImg(conf.width(), conf.height());
        if (conf.domain().rangeContains(0.0)) {
            Float64Array float64Array;
            package$ package$2;
            Float64Array float64Array2;
            package$ package$3;
            package$ package$_this = package$3 = package$.MODULE$;
            ArraySeq d$proxy2 = ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, BoxesRunTime.unboxToDouble((Object)conf.range().min())});
            Integer ev = BoxesRunTime.boxToInteger((int)2);
            int dimension = 2;
            int supplied$proxy2 = d$proxy2.size();
            if (supplied$proxy2 != dimension) {
                throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy2, dimension);
            }
            int n3 = d$proxy2.size();
            int dim = n3;
            if (dim < 2) {
                throw UnsupportedVectorDimension$.MODULE$.apply(dim, UnsupportedVectorDimension$.MODULE$.$lessinit$greater$default$2());
            }
            switch (n3) {
                case 2: {
                    package$ package$4;
                    package$ package$_this2 = package$4 = package$3;
                    double x$proxy4 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(0));
                    double y$proxy4 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(1));
                    float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy4, y$proxy4}), ClassTag$.MODULE$.apply(Double.TYPE));
                    break;
                }
                case 3: {
                    package$ package$5;
                    package$ package$_this3 = package$5 = package$3;
                    double x$proxy5 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(0));
                    double y$proxy5 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(1));
                    double z$proxy3 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(2));
                    float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy5, y$proxy5, z$proxy3}), ClassTag$.MODULE$.apply(Double.TYPE));
                    break;
                }
                case 4: {
                    package$ package$6;
                    package$ package$_this4 = package$6 = package$3;
                    double x$proxy6 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(0));
                    double y$proxy6 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(1));
                    double z$proxy4 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(2));
                    double w$proxy2 = BoxesRunTime.unboxToDouble((Object)d$proxy2.apply(3));
                    float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy6, y$proxy6, z$proxy4, w$proxy2}), ClassTag$.MODULE$.apply(Double.TYPE));
                    break;
                }
                default: {
                    package$ package$7;
                    package$ package$_this5 = package$7 = package$3;
                    Float64Array a$proxy2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)d$proxy2, ClassTag$.MODULE$.apply(Double.TYPE));
                    Integer ev2 = BoxesRunTime.boxToInteger((int)dimension);
                    int requiredDimension$proxy2 = BoxesRunTime.unboxToInt((Object)ev2);
                    if (a$proxy2.length() != requiredDimension$proxy2) {
                        throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy2.length(), requiredDimension$proxy2);
                    }
                    float64Array2 = a$proxy2;
                    break;
                }
            }
            package$ package$_this6 = package$2 = package$.MODULE$;
            ArraySeq d$proxy3 = ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{0.0, BoxesRunTime.unboxToDouble((Object)conf.range().MAX())});
            Integer ev3 = BoxesRunTime.boxToInteger((int)2);
            int dimension2 = 2;
            int supplied$proxy3 = d$proxy3.size();
            if (supplied$proxy3 != dimension2) {
                throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy3, dimension2);
            }
            int n4 = d$proxy3.size();
            int dim2 = n4;
            if (dim2 < 2) {
                throw UnsupportedVectorDimension$.MODULE$.apply(dim2, UnsupportedVectorDimension$.MODULE$.$lessinit$greater$default$2());
            }
            switch (n4) {
                case 2: {
                    package$ package$8;
                    package$ package$_this7 = package$8 = package$2;
                    double x$proxy7 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(0));
                    double y$proxy7 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(1));
                    float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy7, y$proxy7}), ClassTag$.MODULE$.apply(Double.TYPE));
                    break;
                }
                case 3: {
                    package$ package$9;
                    package$ package$_this8 = package$9 = package$2;
                    double x$proxy8 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(0));
                    double y$proxy8 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(1));
                    double z$proxy5 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(2));
                    float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy8, y$proxy8, z$proxy5}), ClassTag$.MODULE$.apply(Double.TYPE));
                    break;
                }
                case 4: {
                    package$ package$10;
                    package$ package$_this9 = package$10 = package$2;
                    double x$proxy9 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(0));
                    double y$proxy9 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(1));
                    double z$proxy6 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(2));
                    double w$proxy3 = BoxesRunTime.unboxToDouble((Object)d$proxy3.apply(3));
                    float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy9, y$proxy9, z$proxy6, w$proxy3}), ClassTag$.MODULE$.apply(Double.TYPE));
                    break;
                }
                default: {
                    package$ package$11;
                    package$ package$_this10 = package$11 = package$2;
                    Float64Array a$proxy3 = (Float64Array)package.NArray$.MODULE$.apply((Seq)d$proxy3, ClassTag$.MODULE$.apply(Double.TYPE));
                    Integer ev4 = BoxesRunTime.boxToInteger((int)dimension2);
                    int requiredDimension$proxy3 = BoxesRunTime.unboxToInt((Object)ev4);
                    if (a$proxy3.length() != requiredDimension$proxy3) {
                        throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy3.length(), requiredDimension$proxy3);
                    }
                    float64Array = a$proxy3;
                    break;
                }
            }
            this.glyphLineSegment(float64Array2, float64Array, Glyph$.MODULE$.axis());
        }
        if (conf.range().rangeContains(0.0)) {
            Float64Array float64Array;
            package$ package$12;
            Float64Array float64Array3;
            package$ package$13;
            package$ package$_this = package$13 = package$.MODULE$;
            ArraySeq d$proxy4 = ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{BoxesRunTime.unboxToDouble((Object)conf.domain().min()), 0.0});
            Integer ev = BoxesRunTime.boxToInteger((int)2);
            int dimension = 2;
            int supplied$proxy4 = d$proxy4.size();
            if (supplied$proxy4 != dimension) {
                throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy4, dimension);
            }
            int n5 = d$proxy4.size();
            int dim = n5;
            if (dim < 2) {
                throw UnsupportedVectorDimension$.MODULE$.apply(dim, UnsupportedVectorDimension$.MODULE$.$lessinit$greater$default$2());
            }
            switch (n5) {
                case 2: {
                    package$ package$14;
                    package$ package$_this11 = package$14 = package$13;
                    double x$proxy10 = BoxesRunTime.unboxToDouble((Object)d$proxy4.apply(0));
                    double y$proxy10 = BoxesRunTime.unboxToDouble((Object)d$proxy4.apply(1));
                    float64Array3 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy10, y$proxy10}), ClassTag$.MODULE$.apply(Double.TYPE));
                    break;
                }
                case 3: {
                    package$ package$15;
                    package$ package$_this12 = package$15 = package$13;
                    double x$proxy11 = BoxesRunTime.unboxToDouble((Object)d$proxy4.apply(0));
                    double y$proxy11 = BoxesRunTime.unboxToDouble((Object)d$proxy4.apply(1));
                    double z$proxy7 = BoxesRunTime.unboxToDouble((Object)d$proxy4.apply(2));
                    float64Array3 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy11, y$proxy11, z$proxy7}), ClassTag$.MODULE$.apply(Double.TYPE));
                    break;
                }
                case 4: {
                    package$ package$16;
                    package$ package$_this13 = package$16 = package$13;
                    double x$proxy12 = BoxesRunTime.unboxToDouble((Object)d$proxy4.apply(0));
                    double y$proxy12 = BoxesRunTime.unboxToDouble((Object)d$proxy4.apply(1));
                    double z$proxy8 = BoxesRunTime.unboxToDouble((Object)d$proxy4.apply(2));
                    double w$proxy4 = BoxesRunTime.unboxToDouble((Object)d$proxy4.apply(3));
                    float64Array3 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy12, y$proxy12, z$proxy8, w$proxy4}), ClassTag$.MODULE$.apply(Double.TYPE));
                    break;
                }
                default: {
                    package$ package$17;
                    package$ package$_this14 = package$17 = package$13;
                    Float64Array a$proxy4 = (Float64Array)package.NArray$.MODULE$.apply((Seq)d$proxy4, ClassTag$.MODULE$.apply(Double.TYPE));
                    Integer ev5 = BoxesRunTime.boxToInteger((int)dimension);
                    int requiredDimension$proxy4 = BoxesRunTime.unboxToInt((Object)ev5);
                    if (a$proxy4.length() != requiredDimension$proxy4) {
                        throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy4.length(), requiredDimension$proxy4);
                    }
                    float64Array3 = a$proxy4;
                    break;
                }
            }
            package$ package$_this15 = package$12 = package$.MODULE$;
            ArraySeq d$proxy5 = ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{BoxesRunTime.unboxToDouble((Object)conf.domain().MAX()), 0.0});
            Integer ev6 = BoxesRunTime.boxToInteger((int)2);
            int dimension3 = 2;
            int supplied$proxy5 = d$proxy5.size();
            if (supplied$proxy5 != dimension3) {
                throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy5, dimension3);
            }
            int n6 = d$proxy5.size();
            int dim3 = n6;
            if (dim3 < 2) {
                throw UnsupportedVectorDimension$.MODULE$.apply(dim3, UnsupportedVectorDimension$.MODULE$.$lessinit$greater$default$2());
            }
            switch (n6) {
                case 2: {
                    package$ package$18;
                    package$ package$_this16 = package$18 = package$12;
                    double x$proxy13 = BoxesRunTime.unboxToDouble((Object)d$proxy5.apply(0));
                    double y$proxy13 = BoxesRunTime.unboxToDouble((Object)d$proxy5.apply(1));
                    float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy13, y$proxy13}), ClassTag$.MODULE$.apply(Double.TYPE));
                    break;
                }
                case 3: {
                    package$ package$19;
                    package$ package$_this17 = package$19 = package$12;
                    double x$proxy14 = BoxesRunTime.unboxToDouble((Object)d$proxy5.apply(0));
                    double y$proxy14 = BoxesRunTime.unboxToDouble((Object)d$proxy5.apply(1));
                    double z$proxy9 = BoxesRunTime.unboxToDouble((Object)d$proxy5.apply(2));
                    float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy14, y$proxy14, z$proxy9}), ClassTag$.MODULE$.apply(Double.TYPE));
                    break;
                }
                case 4: {
                    package$ package$20;
                    package$ package$_this18 = package$20 = package$12;
                    double x$proxy15 = BoxesRunTime.unboxToDouble((Object)d$proxy5.apply(0));
                    double y$proxy15 = BoxesRunTime.unboxToDouble((Object)d$proxy5.apply(1));
                    double z$proxy10 = BoxesRunTime.unboxToDouble((Object)d$proxy5.apply(2));
                    double w$proxy5 = BoxesRunTime.unboxToDouble((Object)d$proxy5.apply(3));
                    float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy15, y$proxy15, z$proxy10, w$proxy5}), ClassTag$.MODULE$.apply(Double.TYPE));
                    break;
                }
                default: {
                    package$ package$21;
                    package$ package$_this19 = package$21 = package$12;
                    Float64Array a$proxy5 = (Float64Array)package.NArray$.MODULE$.apply((Seq)d$proxy5, ClassTag$.MODULE$.apply(Double.TYPE));
                    Integer ev7 = BoxesRunTime.boxToInteger((int)dimension3);
                    int requiredDimension$proxy5 = BoxesRunTime.unboxToInt((Object)ev7);
                    if (a$proxy5.length() != requiredDimension$proxy5) {
                        throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy5.length(), requiredDimension$proxy5);
                    }
                    float64Array = a$proxy5;
                    break;
                }
            }
            this.glyphLineSegment(float64Array3, float64Array, Glyph$.MODULE$.axis());
        }
        this.leftPaddingWidth = Math.max(Math.max(conf.verticalLabel().length(), conf.range().MAX().toString().length()), conf.range().min().toString().length());
        this.legend = (TreeMap)TreeMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Ordering)Ordering.String$.MODULE$);
        this.maxItemNameLength = 0;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Chart)) return false;
        Chart chart = (Chart)object;
        ChartConfig chartConfig = this.conf();
        ChartConfig chartConfig2 = chart.conf();
        if (chartConfig == null) {
            if (chartConfig2 != null) {
                return false;
            }
        } else if (!chartConfig.equals(chartConfig2)) return false;
        if (!chart.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Chart;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "Chart";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "conf";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ChartConfig conf() {
        return this.conf;
    }

    public double scaleX() {
        return this.scaleX;
    }

    public double scaleY() {
        return this.scaleY;
    }

    public int aXa() {
        return this.aXa;
    }

    public int aYa() {
        return this.aYa;
    }

    public Float64Array mapToImageSpace(Float64Array v) {
        package$ package$2;
        package$ package$3;
        package$ package$_this = package$3 = package$.MODULE$;
        double[] dArray = new double[2];
        package$ package$4 = package$.MODULE$;
        Float64Array thisVector$proxy1 = v;
        dArray[0] = this.scaleX() * (BoxesRunTime.unboxToDouble((Object)thisVector$proxy1.apply(0)) - BoxesRunTime.unboxToDouble((Object)this.conf().domain().min())) + (double)this.aXa();
        package$ package$5 = package$.MODULE$;
        Float64Array thisVector$proxy2 = v;
        dArray[1] = this.scaleY() * (BoxesRunTime.unboxToDouble((Object)thisVector$proxy2.apply(1)) - BoxesRunTime.unboxToDouble((Object)this.conf().range().min())) + (double)this.aYa();
        ArraySeq d$proxy1 = ScalaRunTime$.MODULE$.wrapDoubleArray(dArray);
        Integer ev = BoxesRunTime.boxToInteger((int)2);
        int dimension = 2;
        int supplied$proxy1 = d$proxy1.size();
        if (supplied$proxy1 != dimension) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy1, dimension);
        }
        int n = d$proxy1.size();
        int dim = n;
        if (dim < 2) {
            throw UnsupportedVectorDimension$.MODULE$.apply(dim, UnsupportedVectorDimension$.MODULE$.$lessinit$greater$default$2());
        }
        switch (n) {
            case 2: {
                package$ package$6;
                package$ package$_this2 = package$6 = package$3;
                double x$proxy1 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(0));
                double y$proxy1 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(1));
                return (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy1, y$proxy1}), ClassTag$.MODULE$.apply(Double.TYPE));
            }
            case 3: {
                package$ package$7;
                package$ package$_this3 = package$7 = package$3;
                double x$proxy2 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(0));
                double y$proxy2 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(1));
                double z$proxy1 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(2));
                return (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy2, y$proxy2, z$proxy1}), ClassTag$.MODULE$.apply(Double.TYPE));
            }
            case 4: {
                package$ package$8;
                package$ package$_this4 = package$8 = package$3;
                double x$proxy3 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(0));
                double y$proxy3 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(1));
                double z$proxy2 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(2));
                double w$proxy1 = BoxesRunTime.unboxToDouble((Object)d$proxy1.apply(3));
                return (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy3, y$proxy3, z$proxy2, w$proxy1}), ClassTag$.MODULE$.apply(Double.TYPE));
            }
        }
        package$ package$_this5 = package$2 = package$3;
        Float64Array a$proxy1 = (Float64Array)package.NArray$.MODULE$.apply((Seq)d$proxy1, ClassTag$.MODULE$.apply(Double.TYPE));
        Integer ev2 = BoxesRunTime.boxToInteger((int)dimension);
        int requiredDimension$proxy1 = BoxesRunTime.unboxToInt((Object)ev2);
        if (a$proxy1.length() != requiredDimension$proxy1) {
            throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy1.length(), requiredDimension$proxy1);
        }
        return a$proxy1;
    }

    public CLImg cimg() {
        return this.cimg;
    }

    public int leftPaddingWidth() {
        return this.leftPaddingWidth;
    }

    public Chart glyphLineSegment(Float64Array p1, Float64Array p2, Glyph glyph) {
        Float64Array float64Array;
        package$ package$2;
        Float64Array float64Array2;
        package$ package$3;
        int unitWidth = 2;
        int unitHeight = 4;
        Float64Array pi1 = this.mapToImageSpace(p1);
        package$ package$_this = package$3 = package$.MODULE$;
        double[] dArray = new double[2];
        package$ package$4 = package$.MODULE$;
        Float64Array thisVector$proxy3 = pi1;
        dArray[0] = BoxesRunTime.unboxToDouble((Object)thisVector$proxy3.apply(0)) / (double)unitWidth;
        package$ package$5 = package$.MODULE$;
        Float64Array thisVector$proxy4 = pi1;
        dArray[1] = BoxesRunTime.unboxToDouble((Object)thisVector$proxy4.apply(1)) / (double)unitHeight;
        ArraySeq d$proxy6 = ScalaRunTime$.MODULE$.wrapDoubleArray(dArray);
        Integer ev = BoxesRunTime.boxToInteger((int)2);
        int dimension = 2;
        int supplied$proxy6 = d$proxy6.size();
        if (supplied$proxy6 != dimension) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy6, dimension);
        }
        int n = d$proxy6.size();
        int dim = n;
        if (dim < 2) {
            throw UnsupportedVectorDimension$.MODULE$.apply(dim, UnsupportedVectorDimension$.MODULE$.$lessinit$greater$default$2());
        }
        switch (n) {
            case 2: {
                package$ package$6;
                package$ package$_this2 = package$6 = package$3;
                double x$proxy16 = BoxesRunTime.unboxToDouble((Object)d$proxy6.apply(0));
                double y$proxy16 = BoxesRunTime.unboxToDouble((Object)d$proxy6.apply(1));
                float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy16, y$proxy16}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 3: {
                package$ package$7;
                package$ package$_this3 = package$7 = package$3;
                double x$proxy17 = BoxesRunTime.unboxToDouble((Object)d$proxy6.apply(0));
                double y$proxy17 = BoxesRunTime.unboxToDouble((Object)d$proxy6.apply(1));
                double z$proxy11 = BoxesRunTime.unboxToDouble((Object)d$proxy6.apply(2));
                float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy17, y$proxy17, z$proxy11}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 4: {
                package$ package$8;
                package$ package$_this4 = package$8 = package$3;
                double x$proxy18 = BoxesRunTime.unboxToDouble((Object)d$proxy6.apply(0));
                double y$proxy18 = BoxesRunTime.unboxToDouble((Object)d$proxy6.apply(1));
                double z$proxy12 = BoxesRunTime.unboxToDouble((Object)d$proxy6.apply(2));
                double w$proxy6 = BoxesRunTime.unboxToDouble((Object)d$proxy6.apply(3));
                float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy18, y$proxy18, z$proxy12, w$proxy6}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            default: {
                package$ package$9;
                package$ package$_this5 = package$9 = package$3;
                Float64Array a$proxy6 = (Float64Array)package.NArray$.MODULE$.apply((Seq)d$proxy6, ClassTag$.MODULE$.apply(Double.TYPE));
                Integer ev2 = BoxesRunTime.boxToInteger((int)dimension);
                int requiredDimension$proxy6 = BoxesRunTime.unboxToInt((Object)ev2);
                if (a$proxy6.length() != requiredDimension$proxy6) {
                    throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy6.length(), requiredDimension$proxy6);
                }
                float64Array2 = a$proxy6;
                break;
            }
        }
        Float64Array start = float64Array2;
        Float64Array pi2 = this.mapToImageSpace(p2);
        package$ package$_this6 = package$2 = package$.MODULE$;
        double[] dArray2 = new double[2];
        package$ package$10 = package$.MODULE$;
        Float64Array thisVector$proxy5 = pi2;
        dArray2[0] = BoxesRunTime.unboxToDouble((Object)thisVector$proxy5.apply(0)) / (double)unitWidth;
        package$ package$11 = package$.MODULE$;
        Float64Array thisVector$proxy6 = pi2;
        dArray2[1] = BoxesRunTime.unboxToDouble((Object)thisVector$proxy6.apply(1)) / (double)unitHeight;
        ArraySeq d$proxy7 = ScalaRunTime$.MODULE$.wrapDoubleArray(dArray2);
        Integer ev3 = BoxesRunTime.boxToInteger((int)2);
        int dimension2 = 2;
        int supplied$proxy7 = d$proxy7.size();
        if (supplied$proxy7 != dimension2) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy7, dimension2);
        }
        int n2 = d$proxy7.size();
        int dim2 = n2;
        if (dim2 < 2) {
            throw UnsupportedVectorDimension$.MODULE$.apply(dim2, UnsupportedVectorDimension$.MODULE$.$lessinit$greater$default$2());
        }
        switch (n2) {
            case 2: {
                package$ package$12;
                package$ package$_this7 = package$12 = package$2;
                double x$proxy19 = BoxesRunTime.unboxToDouble((Object)d$proxy7.apply(0));
                double y$proxy19 = BoxesRunTime.unboxToDouble((Object)d$proxy7.apply(1));
                float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy19, y$proxy19}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 3: {
                package$ package$13;
                package$ package$_this8 = package$13 = package$2;
                double x$proxy20 = BoxesRunTime.unboxToDouble((Object)d$proxy7.apply(0));
                double y$proxy20 = BoxesRunTime.unboxToDouble((Object)d$proxy7.apply(1));
                double z$proxy13 = BoxesRunTime.unboxToDouble((Object)d$proxy7.apply(2));
                float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy20, y$proxy20, z$proxy13}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 4: {
                package$ package$14;
                package$ package$_this9 = package$14 = package$2;
                double x$proxy21 = BoxesRunTime.unboxToDouble((Object)d$proxy7.apply(0));
                double y$proxy21 = BoxesRunTime.unboxToDouble((Object)d$proxy7.apply(1));
                double z$proxy14 = BoxesRunTime.unboxToDouble((Object)d$proxy7.apply(2));
                double w$proxy7 = BoxesRunTime.unboxToDouble((Object)d$proxy7.apply(3));
                float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy21, y$proxy21, z$proxy14, w$proxy7}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            default: {
                package$ package$15;
                package$ package$_this10 = package$15 = package$2;
                Float64Array a$proxy7 = (Float64Array)package.NArray$.MODULE$.apply((Seq)d$proxy7, ClassTag$.MODULE$.apply(Double.TYPE));
                Integer ev4 = BoxesRunTime.boxToInteger((int)dimension2);
                int requiredDimension$proxy7 = BoxesRunTime.unboxToInt((Object)ev4);
                if (a$proxy7.length() != requiredDimension$proxy7) {
                    throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy7.length(), requiredDimension$proxy7);
                }
                float64Array = a$proxy7;
                break;
            }
        }
        Float64Array end = float64Array;
        TreeMap hm = (TreeMap)TreeMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]), (Ordering)Ordering.Int$.MODULE$);
        Line$.MODULE$.trace2D(start, end, (Function2 & Serializable)(v1, v2) -> {
            this.glyphLineSegment$$anonfun$1(unitWidth, unitHeight, hm, BoxesRunTime.unboxToInt((Object)v1), BoxesRunTime.unboxToInt((Object)v2));
            return BoxedUnit.UNIT;
        });
        hm.withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
                Interval interval = (Interval)tuple2._2();
                if (true) {
                    int yi = n;
                    if (interval instanceof Interval) {
                        Interval xiv = interval;
                        return true;
                    }
                }
            }
            return false;
        }).foreach((Function1 & Serializable)x$1 -> {
            this.glyphLineSegment$$anonfun$3(glyph, unitWidth, (Tuple2)x$1);
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public Chart glyphLine(Float64Array point, double slope, String name, Glyph glyph) {
        Float64Array float64Array;
        package$ package$2;
        Float64Array float64Array2;
        package$ package$3;
        package$ package$4 = package$.MODULE$;
        Float64Array thisVector$proxy7 = point;
        package$ package$5 = package$.MODULE$;
        Float64Array thisVector$proxy8 = point;
        double b = -BoxesRunTime.unboxToDouble((Object)thisVector$proxy7.apply(0)) * slope + BoxesRunTime.unboxToDouble((Object)thisVector$proxy8.apply(1));
        package$ package$_this = package$3 = package$.MODULE$;
        ArraySeq d$proxy8 = ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{BoxesRunTime.unboxToDouble((Object)this.conf().domain().min()), BoxesRunTime.unboxToDouble((Object)this.conf().domain().min()) * slope + b});
        Integer ev = BoxesRunTime.boxToInteger((int)2);
        int dimension = 2;
        int supplied$proxy8 = d$proxy8.size();
        if (supplied$proxy8 != dimension) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy8, dimension);
        }
        int n = d$proxy8.size();
        int dim = n;
        if (dim < 2) {
            throw UnsupportedVectorDimension$.MODULE$.apply(dim, UnsupportedVectorDimension$.MODULE$.$lessinit$greater$default$2());
        }
        switch (n) {
            case 2: {
                package$ package$6;
                package$ package$_this2 = package$6 = package$3;
                double x$proxy22 = BoxesRunTime.unboxToDouble((Object)d$proxy8.apply(0));
                double y$proxy22 = BoxesRunTime.unboxToDouble((Object)d$proxy8.apply(1));
                float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy22, y$proxy22}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 3: {
                package$ package$7;
                package$ package$_this3 = package$7 = package$3;
                double x$proxy23 = BoxesRunTime.unboxToDouble((Object)d$proxy8.apply(0));
                double y$proxy23 = BoxesRunTime.unboxToDouble((Object)d$proxy8.apply(1));
                double z$proxy15 = BoxesRunTime.unboxToDouble((Object)d$proxy8.apply(2));
                float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy23, y$proxy23, z$proxy15}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 4: {
                package$ package$8;
                package$ package$_this4 = package$8 = package$3;
                double x$proxy24 = BoxesRunTime.unboxToDouble((Object)d$proxy8.apply(0));
                double y$proxy24 = BoxesRunTime.unboxToDouble((Object)d$proxy8.apply(1));
                double z$proxy16 = BoxesRunTime.unboxToDouble((Object)d$proxy8.apply(2));
                double w$proxy8 = BoxesRunTime.unboxToDouble((Object)d$proxy8.apply(3));
                float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy24, y$proxy24, z$proxy16, w$proxy8}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            default: {
                package$ package$9;
                package$ package$_this5 = package$9 = package$3;
                Float64Array a$proxy8 = (Float64Array)package.NArray$.MODULE$.apply((Seq)d$proxy8, ClassTag$.MODULE$.apply(Double.TYPE));
                Integer ev2 = BoxesRunTime.boxToInteger((int)dimension);
                int requiredDimension$proxy8 = BoxesRunTime.unboxToInt((Object)ev2);
                if (a$proxy8.length() != requiredDimension$proxy8) {
                    throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy8.length(), requiredDimension$proxy8);
                }
                float64Array2 = a$proxy8;
                break;
            }
        }
        Float64Array start = float64Array2;
        package$ package$_this6 = package$2 = package$.MODULE$;
        ArraySeq d$proxy9 = ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{BoxesRunTime.unboxToDouble((Object)this.conf().domain().MAX()), BoxesRunTime.unboxToDouble((Object)this.conf().domain().MAX()) * slope + b});
        Integer ev3 = BoxesRunTime.boxToInteger((int)2);
        int dimension2 = 2;
        int supplied$proxy9 = d$proxy9.size();
        if (supplied$proxy9 != dimension2) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy9, dimension2);
        }
        int n2 = d$proxy9.size();
        int dim2 = n2;
        if (dim2 < 2) {
            throw UnsupportedVectorDimension$.MODULE$.apply(dim2, UnsupportedVectorDimension$.MODULE$.$lessinit$greater$default$2());
        }
        switch (n2) {
            case 2: {
                package$ package$10;
                package$ package$_this7 = package$10 = package$2;
                double x$proxy25 = BoxesRunTime.unboxToDouble((Object)d$proxy9.apply(0));
                double y$proxy25 = BoxesRunTime.unboxToDouble((Object)d$proxy9.apply(1));
                float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy25, y$proxy25}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 3: {
                package$ package$11;
                package$ package$_this8 = package$11 = package$2;
                double x$proxy26 = BoxesRunTime.unboxToDouble((Object)d$proxy9.apply(0));
                double y$proxy26 = BoxesRunTime.unboxToDouble((Object)d$proxy9.apply(1));
                double z$proxy17 = BoxesRunTime.unboxToDouble((Object)d$proxy9.apply(2));
                float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy26, y$proxy26, z$proxy17}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 4: {
                package$ package$12;
                package$ package$_this9 = package$12 = package$2;
                double x$proxy27 = BoxesRunTime.unboxToDouble((Object)d$proxy9.apply(0));
                double y$proxy27 = BoxesRunTime.unboxToDouble((Object)d$proxy9.apply(1));
                double z$proxy18 = BoxesRunTime.unboxToDouble((Object)d$proxy9.apply(2));
                double w$proxy9 = BoxesRunTime.unboxToDouble((Object)d$proxy9.apply(3));
                float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy27, y$proxy27, z$proxy18, w$proxy9}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            default: {
                package$ package$13;
                package$ package$_this10 = package$13 = package$2;
                Float64Array a$proxy9 = (Float64Array)package.NArray$.MODULE$.apply((Seq)d$proxy9, ClassTag$.MODULE$.apply(Double.TYPE));
                Integer ev4 = BoxesRunTime.boxToInteger((int)dimension2);
                int requiredDimension$proxy9 = BoxesRunTime.unboxToInt((Object)ev4);
                if (a$proxy9.length() != requiredDimension$proxy9) {
                    throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy9.length(), requiredDimension$proxy9);
                }
                float64Array = a$proxy9;
                break;
            }
        }
        Float64Array end = float64Array;
        return this.glyphLineSegment(start, end, glyph);
    }

    public Chart lineSegment(Float64Array p1, Float64Array p2, String name) {
        Glyph glyph = (Glyph)this.legend.getOrElseUpdate((Object)name, this::$anonfun$2);
        this.maxItemNameLength = Math.max(this.maxItemNameLength, name.length() + 2);
        if (glyph.overlay()) {
            return this.glyphLineSegment(p1, p2, glyph);
        }
        Float64Array start = this.mapToImageSpace(p1);
        Float64Array end = this.mapToImageSpace(p2);
        Line$.MODULE$.trace2D(start, end, (Function2 & Serializable)(v1, v2) -> {
            this.lineSegment$$anonfun$1(glyph, BoxesRunTime.unboxToInt((Object)v1), BoxesRunTime.unboxToInt((Object)v2));
            return BoxedUnit.UNIT;
        });
        return this;
    }

    public Chart line(Float64Array point, double slope, String name) {
        Float64Array float64Array;
        package$ package$2;
        Float64Array float64Array2;
        package$ package$3;
        Glyph glyph = (Glyph)this.legend.getOrElseUpdate((Object)name, this::$anonfun$3);
        this.maxItemNameLength = Math.max(this.maxItemNameLength, name.length() + 2);
        if (glyph.overlay()) {
            return this.glyphLine(point, slope, name, glyph);
        }
        package$ package$4 = package$.MODULE$;
        Float64Array thisVector$proxy9 = point;
        package$ package$5 = package$.MODULE$;
        Float64Array thisVector$proxy10 = point;
        double b = -BoxesRunTime.unboxToDouble((Object)thisVector$proxy9.apply(0)) * slope + BoxesRunTime.unboxToDouble((Object)thisVector$proxy10.apply(1));
        package$ package$_this = package$3 = package$.MODULE$;
        ArraySeq d$proxy10 = ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{BoxesRunTime.unboxToDouble((Object)this.conf().domain().min()), BoxesRunTime.unboxToDouble((Object)this.conf().domain().min()) * slope + b});
        Integer ev = BoxesRunTime.boxToInteger((int)2);
        int dimension = 2;
        int supplied$proxy10 = d$proxy10.size();
        if (supplied$proxy10 != dimension) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy10, dimension);
        }
        int n = d$proxy10.size();
        int dim = n;
        if (dim < 2) {
            throw UnsupportedVectorDimension$.MODULE$.apply(dim, UnsupportedVectorDimension$.MODULE$.$lessinit$greater$default$2());
        }
        switch (n) {
            case 2: {
                package$ package$6;
                package$ package$_this2 = package$6 = package$3;
                double x$proxy28 = BoxesRunTime.unboxToDouble((Object)d$proxy10.apply(0));
                double y$proxy28 = BoxesRunTime.unboxToDouble((Object)d$proxy10.apply(1));
                float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy28, y$proxy28}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 3: {
                package$ package$7;
                package$ package$_this3 = package$7 = package$3;
                double x$proxy29 = BoxesRunTime.unboxToDouble((Object)d$proxy10.apply(0));
                double y$proxy29 = BoxesRunTime.unboxToDouble((Object)d$proxy10.apply(1));
                double z$proxy19 = BoxesRunTime.unboxToDouble((Object)d$proxy10.apply(2));
                float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy29, y$proxy29, z$proxy19}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 4: {
                package$ package$8;
                package$ package$_this4 = package$8 = package$3;
                double x$proxy30 = BoxesRunTime.unboxToDouble((Object)d$proxy10.apply(0));
                double y$proxy30 = BoxesRunTime.unboxToDouble((Object)d$proxy10.apply(1));
                double z$proxy20 = BoxesRunTime.unboxToDouble((Object)d$proxy10.apply(2));
                double w$proxy10 = BoxesRunTime.unboxToDouble((Object)d$proxy10.apply(3));
                float64Array2 = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy30, y$proxy30, z$proxy20, w$proxy10}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            default: {
                package$ package$9;
                package$ package$_this5 = package$9 = package$3;
                Float64Array a$proxy10 = (Float64Array)package.NArray$.MODULE$.apply((Seq)d$proxy10, ClassTag$.MODULE$.apply(Double.TYPE));
                Integer ev2 = BoxesRunTime.boxToInteger((int)dimension);
                int requiredDimension$proxy10 = BoxesRunTime.unboxToInt((Object)ev2);
                if (a$proxy10.length() != requiredDimension$proxy10) {
                    throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy10.length(), requiredDimension$proxy10);
                }
                float64Array2 = a$proxy10;
                break;
            }
        }
        Float64Array start = float64Array2;
        package$ package$_this6 = package$2 = package$.MODULE$;
        ArraySeq d$proxy11 = ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{BoxesRunTime.unboxToDouble((Object)this.conf().domain().MAX()), BoxesRunTime.unboxToDouble((Object)this.conf().domain().MAX()) * slope + b});
        Integer ev3 = BoxesRunTime.boxToInteger((int)2);
        int dimension2 = 2;
        int supplied$proxy11 = d$proxy11.size();
        if (supplied$proxy11 != dimension2) {
            throw UnsupportedVectorDimension$.MODULE$.apply(supplied$proxy11, dimension2);
        }
        int n2 = d$proxy11.size();
        int dim2 = n2;
        if (dim2 < 2) {
            throw UnsupportedVectorDimension$.MODULE$.apply(dim2, UnsupportedVectorDimension$.MODULE$.$lessinit$greater$default$2());
        }
        switch (n2) {
            case 2: {
                package$ package$10;
                package$ package$_this7 = package$10 = package$2;
                double x$proxy31 = BoxesRunTime.unboxToDouble((Object)d$proxy11.apply(0));
                double y$proxy31 = BoxesRunTime.unboxToDouble((Object)d$proxy11.apply(1));
                float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy31, y$proxy31}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 3: {
                package$ package$11;
                package$ package$_this8 = package$11 = package$2;
                double x$proxy32 = BoxesRunTime.unboxToDouble((Object)d$proxy11.apply(0));
                double y$proxy32 = BoxesRunTime.unboxToDouble((Object)d$proxy11.apply(1));
                double z$proxy21 = BoxesRunTime.unboxToDouble((Object)d$proxy11.apply(2));
                float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy32, y$proxy32, z$proxy21}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            case 4: {
                package$ package$12;
                package$ package$_this9 = package$12 = package$2;
                double x$proxy33 = BoxesRunTime.unboxToDouble((Object)d$proxy11.apply(0));
                double y$proxy33 = BoxesRunTime.unboxToDouble((Object)d$proxy11.apply(1));
                double z$proxy22 = BoxesRunTime.unboxToDouble((Object)d$proxy11.apply(2));
                double w$proxy11 = BoxesRunTime.unboxToDouble((Object)d$proxy11.apply(3));
                float64Array = (Float64Array)package.NArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{x$proxy33, y$proxy33, z$proxy22, w$proxy11}), ClassTag$.MODULE$.apply(Double.TYPE));
                break;
            }
            default: {
                package$ package$13;
                package$ package$_this10 = package$13 = package$2;
                Float64Array a$proxy11 = (Float64Array)package.NArray$.MODULE$.apply((Seq)d$proxy11, ClassTag$.MODULE$.apply(Double.TYPE));
                Integer ev4 = BoxesRunTime.boxToInteger((int)dimension2);
                int requiredDimension$proxy11 = BoxesRunTime.unboxToInt((Object)ev4);
                if (a$proxy11.length() != requiredDimension$proxy11) {
                    throw UnsupportedVectorDimension$.MODULE$.apply(a$proxy11.length(), requiredDimension$proxy11);
                }
                float64Array = a$proxy11;
                break;
            }
        }
        Float64Array end = float64Array;
        return this.lineSegment(start, end, name);
    }

    private void plotGlyph(Glyph glyph, Float64Array p) {
        Float64Array pT = this.mapToImageSpace(p);
        package$ package$2 = package$.MODULE$;
        Float64Array thisVector$proxy11 = pT;
        package$ package$3 = package$.MODULE$;
        Float64Array thisVector$proxy12 = pT;
        this.cimg().setGlyph((int)BoxesRunTime.unboxToDouble((Object)thisVector$proxy11.apply(0)), this.cimg().height() - 1 - (int)BoxesRunTime.unboxToDouble((Object)thisVector$proxy12.apply(1)), glyph);
    }

    private void plotPixel(Glyph glyph, Float64Array p) {
        Float64Array pT = this.mapToImageSpace(p);
        package$ package$2 = package$.MODULE$;
        Float64Array thisVector$proxy13 = pT;
        package$ package$3 = package$.MODULE$;
        Float64Array thisVector$proxy14 = pT;
        this.cimg().setPixel((int)BoxesRunTime.unboxToDouble((Object)thisVector$proxy13.apply(0)), this.cimg().height() - 1 - (int)BoxesRunTime.unboxToDouble((Object)thisVector$proxy14.apply(1)), glyph.color());
    }

    public Chart scatter(String name, Seq<Float64Array> points) {
        Glyph glyph = (Glyph)this.legend.getOrElseUpdate((Object)name, this::$anonfun$4);
        this.maxItemNameLength = Math.max(this.maxItemNameLength, name.length() + 2);
        points.foreach((Function1)(glyph.overlay() ? (Function1 & Serializable)p -> {
            this.scatter$$anonfun$1(glyph, (Float64Array)p);
            return BoxedUnit.UNIT;
        } : (Function1 & Serializable)p -> {
            this.scatter$$anonfun$2(glyph, (Float64Array)p);
            return BoxedUnit.UNIT;
        }));
        return this;
    }

    public Chart connectedScatter(String name, Seq<Float64Array> points) {
        Float64Array p = (Float64Array)points.head();
        Seq tail = (Seq)points.tail();
        while (tail.nonEmpty()) {
            this.lineSegment(p, (Float64Array)tail.head(), name);
            p = (Float64Array)tail.head();
            tail = (Seq)tail.tail();
        }
        return this;
    }

    public SegmentedString padLeft(String s, SegmentedString sb) {
        for (int i = 0; i < this.leftPaddingWidth() - s.length(); ++i) {
            sb.append(" ");
        }
        return sb.append(s);
    }

    public SegmentedString chartPadLeft(String s, SegmentedString sb) {
        for (int i = 0; i < (this.conf().width() / 2 - s.length()) / 2; ++i) {
            sb.append("\u2800");
        }
        return sb.append(s);
    }

    public SegmentedString topBorder(SegmentedString sb) {
        sb.append(" \u2880");
        for (int i = 0; i < this.conf().width() / 2; ++i) {
            sb.append("\u28c0");
        }
        return sb.append("\u2840");
    }

    public SegmentedString bottomBorder(SegmentedString sb) {
        sb.append(" \u2808");
        for (int i = 0; i < this.conf().width() / 2; ++i) {
            sb.append("\u2809");
        }
        return sb.append("\u2801");
    }

    public String toString() {
        String string;
        Iterator litr;
        Array<String> lines;
        LazyRef lazyRef;
        block12: {
            block9: {
                lazyRef = new LazyRef();
                this.padLeft("", Chart.ss$1(lazyRef));
                this.chartPadLeft(this.conf().title(), Chart.ss$1(lazyRef)).append("\n");
                this.padLeft("", Chart.ss$1(lazyRef));
                this.topBorder(Chart.ss$1(lazyRef)).append("\n");
                lines = this.cimg().lines(this.cimg().lines$default$1());
                Array array = Any$.MODULE$.jsArrayOps(lines);
                this.padLeft(this.conf().range().MAX().toString(), Chart.ss$1(lazyRef)).append(" \u28b8").append((String)ArrayOps$.MODULE$.head$extension(array)).append("\u001b[0m").append("\u2847\n");
                litr = this.legend.iterator();
                if (this.legend.size() <= lines.length()) break block9;
                LazyRef lazyRef2 = new LazyRef();
                this.padLeft("", Chart.lsb$1(lazyRef2));
                int lineLength = 0;
                while (litr.hasNext()) {
                    String itemName;
                    Glyph glyph;
                    block11: {
                        Tuple2 tuple2;
                        block10: {
                            tuple2 = (Tuple2)litr.next();
                            if (tuple2 == null) break block10;
                            String string2 = (String)tuple2._1();
                            glyph = (Glyph)tuple2._2();
                            if (string2 == null) break block10;
                            itemName = string2;
                            if (glyph != null) break block11;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    Glyph itemGlyph = glyph;
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)itemName, (Object)itemGlyph);
                    String itemName2 = (String)tuple2._1();
                    Glyph itemGlyph2 = (Glyph)tuple2._2();
                    String legendItem = new StringBuilder(2).append(" ").append(itemGlyph2.asIcon()).append(" ").append(itemName2).toString();
                    if (lineLength + legendItem.length() + 4 > this.conf().width()) {
                        Chart.lsb$1(lazyRef2).append("\n");
                        this.padLeft("", Chart.lsb$1(lazyRef2));
                        lineLength = legendItem.length() + 4;
                    } else {
                        lineLength = lineLength + legendItem.length() + 4;
                    }
                    Chart.lsb$1(lazyRef2).append(legendItem).append("  ");
                }
                string = Chart.lsb$1(lazyRef2).toString();
                break block12;
            }
            string = "";
        }
        String footerLegend = string;
        for (int i = 0; i < lines.length() - 1; ++i) {
            String l = i == lines.length() / 2 ? this.conf().verticalLabel() : "";
            this.padLeft(l, Chart.ss$1(lazyRef)).append(" \u28b8").append((String)lines.apply(i)).append("\u001b[0m").append("\u2847\u2800");
            if (litr.hasNext()) {
                Tuple2 tuple2 = (Tuple2)litr.next();
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String itemName = (String)tuple2._1();
                Glyph itemGlyph = (Glyph)tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)itemName, (Object)itemGlyph);
                String itemName3 = (String)tuple22._1();
                Glyph itemGlyph3 = (Glyph)tuple22._2();
                Chart.ss$1(lazyRef).append(new StringBuilder(2).append(" ").append(itemGlyph3.asIcon()).append(" ").append(itemName3).toString());
            }
            Chart.ss$1(lazyRef).append("\n");
        }
        Array array = Any$.MODULE$.jsArrayOps(lines);
        this.padLeft(this.conf().range().min().toString(), Chart.ss$1(lazyRef)).append(" \u28b8").append((String)ArrayOps$.MODULE$.last$extension(array)).append("\u001b[0m").append("\u2847 \n");
        this.padLeft("", Chart.ss$1(lazyRef));
        this.bottomBorder(Chart.ss$1(lazyRef)).append("\n");
        this.padLeft("", Chart.ss$1(lazyRef)).append(this.conf().domain().min());
        this.chartPadLeft(this.conf().horizontalLabel(), Chart.ss$1(lazyRef));
        return this.chartPadLeft(this.conf().domain().MAX().toString(), Chart.ss$1(lazyRef)).append("\n").append(footerLegend).append("\n").toString();
    }

    public Chart copy(ChartConfig conf) {
        return new Chart(conf);
    }

    public ChartConfig copy$default$1() {
        return this.conf();
    }

    public ChartConfig _1() {
        return this.conf();
    }

    private static final Interval $anonfun$1(int xi$1) {
        return Interval$.MODULE$.$u005B$u005D((Object)BoxesRunTime.boxToInteger((int)xi$1), (Object)BoxesRunTime.boxToInteger((int)xi$1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    private final /* synthetic */ void glyphLineSegment$$anonfun$1(int unitWidth$1, int unitHeight$1, TreeMap hm$1, int dX, int dY) {
        int xi = dX * unitWidth$1;
        int yi = this.conf().height() - 1 - dY * unitHeight$1;
        Interval interval = (Interval)hm$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)yi), () -> Chart.$anonfun$1(xi));
        hm$1.put((Object)BoxesRunTime.boxToInteger((int)yi), (Object)Interval$.MODULE$.$u005B$u005D((Object)BoxesRunTime.boxToInteger((int)Math.min(BoxesRunTime.unboxToInt((Object)interval.min()), xi)), (Object)BoxesRunTime.boxToInteger((int)Math.max(BoxesRunTime.unboxToInt((Object)interval.MAX()), xi)), (Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private final /* synthetic */ void glyphLineSegment$$anonfun$3(Glyph glyph$1, int unitWidth$2, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
            Interval interval = (Interval)tuple2._2();
            if (true) {
                int yi = n;
                if (interval instanceof Interval) {
                    Interval xiv = interval;
                    int middle = (BoxesRunTime.unboxToInt((Object)xiv.min()) + BoxesRunTime.unboxToInt((Object)xiv.MAX())) / 2;
                    int s = 1;
                    int step = 6;
                    int left = BoxesRunTime.unboxToInt((Object)xiv.min()) + s * step;
                    int right = BoxesRunTime.unboxToInt((Object)xiv.MAX()) - s * step;
                    boolean drew = false;
                    while (right - left > unitWidth$2) {
                        this.cimg().setGlyph(left, yi, glyph$1);
                        this.cimg().setGlyph(right, yi, glyph$1);
                        left = BoxesRunTime.unboxToInt((Object)xiv.min()) + ++s * step;
                        right = BoxesRunTime.unboxToInt((Object)xiv.MAX()) - s * step;
                        drew = true;
                    }
                    if (!drew) {
                        this.cimg().setGlyph(middle, yi, glyph$1);
                        return;
                    }
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private final Glyph $anonfun$2() {
        return Glyph$.MODULE$.apply(this.legend.size());
    }

    private final /* synthetic */ void lineSegment$$anonfun$1(Glyph glyph$2, int dX, int dY) {
        this.cimg().setPixel(dX, this.cimg().height() - 1 - dY, glyph$2.color());
    }

    private final Glyph $anonfun$3() {
        return Glyph$.MODULE$.apply(this.legend.size());
    }

    private final Glyph $anonfun$4() {
        return Glyph$.MODULE$.apply(this.legend.size());
    }

    private final /* synthetic */ void scatter$$anonfun$1(Glyph glyph$3, Float64Array p) {
        this.plotGlyph(glyph$3, p);
    }

    private final /* synthetic */ void scatter$$anonfun$2(Glyph glyph$4, Float64Array p) {
        this.plotPixel(glyph$4, p);
    }

    private static final SegmentedString ss$lzyINIT1$1(LazyRef ss$lzy1$1) {
        SegmentedString segmentedString;
        LazyRef lazyRef = ss$lzy1$1;
        synchronized (lazyRef) {
            segmentedString = (SegmentedString)(ss$lzy1$1.initialized() ? ss$lzy1$1.value() : ss$lzy1$1.initialize((Object)new SegmentedString().append("\u001b[0m")));
        }
        return segmentedString;
    }

    private static final SegmentedString ss$1(LazyRef ss$lzy1$2) {
        return (SegmentedString)(ss$lzy1$2.initialized() ? ss$lzy1$2.value() : Chart.ss$lzyINIT1$1(ss$lzy1$2));
    }

    private static final SegmentedString lsb$lzyINIT1$1(LazyRef lsb$lzy1$1) {
        SegmentedString segmentedString;
        LazyRef lazyRef = lsb$lzy1$1;
        synchronized (lazyRef) {
            segmentedString = (SegmentedString)(lsb$lzy1$1.initialized() ? lsb$lzy1$1.value() : lsb$lzy1$1.initialize((Object)new SegmentedString()));
        }
        return segmentedString;
    }

    private static final SegmentedString lsb$1(LazyRef lsb$lzy1$2) {
        return (SegmentedString)(lsb$lzy1$2.initialized() ? lsb$lzy1$2.value() : Chart.lsb$lzyINIT1$1(lsb$lzy1$2));
    }
}

